/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.agent.web;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.zookeeper.Watcher;

public class CuratorFactoryBean {
    private static final transient Log LOG = LogFactory.getLog(CuratorFactoryBean.class);
    private String connectString = System.getProperty("zookeeper.url", "localhost:2181");
    private String password = System.getProperty("zookeeper.password", "");
    private int timeout = 30000;
    private Watcher watcher;
    protected CuratorFramework curator;

    public String getConnectString() {
        return this.connectString;
    }

    public void setConnectString(String connectString) {
        this.connectString = connectString;
    }

    public Watcher getWatcher() {
        return this.watcher;
    }

    public void setWatcher(Watcher watcher) {
        this.watcher = watcher;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public CuratorFramework getObject() throws Exception {
        LOG.debug((Object)("Connecting to ZooKeeper on " + this.connectString));
        CuratorFrameworkFactory.Builder builder = CuratorFrameworkFactory.builder().connectString(this.connectString).retryPolicy((RetryPolicy)new ExponentialBackoffRetry(5, 10)).connectionTimeoutMs(this.getTimeout());
        if (this.password != null && !this.password.isEmpty()) {
            builder.authorization("digest", ("fabric:" + this.password).getBytes("UTF-8"));
        }
        this.curator = builder.build();
        LOG.debug((Object)("Starting curator " + this.curator));
        this.curator.start();
        return this.curator;
    }

    public Class<?> getObjectType() {
        return CuratorFramework.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void destroy() throws Exception {
        if (this.curator != null) {
            this.curator.close();
            this.curator = null;
        }
    }
}

