/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.agent.web;

import io.fabric8.agent.web.FabricWebRegistrationHandler;
import io.fabric8.api.FabricService;
import io.fabric8.zookeeper.ZkPath;
import io.fabric8.zookeeper.utils.ZooKeeperUtils;
import java.lang.management.ManagementFactory;
import java.util.HashSet;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.MBeanServerDelegate;
import javax.management.MalformedObjectNameException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.QueryExp;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.curator.framework.state.ConnectionStateListener;
import org.apache.zookeeper.CreateMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FabricWebRegistrationHandler
implements ConnectionStateListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(FabricWebRegistrationHandler.class);
    private FabricService fabricService;
    private CuratorFramework curator;
    private NotificationListener listener;
    private NotificationFilter filter;
    private MBeanServer mBeanServer;
    private int port = -1;
    String containerId = "tomcat1";
    String host = "localhost";

    public void init() throws Exception {
        LOGGER.info("Initialising " + this + " with fabricService: " + this.fabricService + " and curator: " + this.curator);
        if (this.mBeanServer == null) {
            this.mBeanServer = ManagementFactory.getPlatformMBeanServer();
        }
        if (this.mBeanServer != null) {
            Object handback = null;
            this.listener = this.getNotificationListener();
            this.filter = this.getNotificationFilter();
            this.mBeanServer.addNotificationListener(MBeanServerDelegate.DELEGATE_NAME, this.listener, this.filter, handback);
        }
        this.findWebAppMBeans();
    }

    public void destroy() throws Exception {
        if (this.mBeanServer != null && this.listener != null) {
            this.mBeanServer.removeNotificationListener(MBeanServerDelegate.DELEGATE_NAME, this.listener);
        }
    }

    protected void findWebAppMBeans() {
        try {
            Set objectNames;
            if (this.port < 0) {
                objectNames = this.findObjectNames(null, new String[]{"Catalina:type=Connector,*", "Tomcat:type=Connector,*"});
                for (ObjectName objectName : objectNames) {
                    Object portValue;
                    Object protocol = this.mBeanServer.getAttribute(objectName, "protocol");
                    if (protocol == null || !(protocol instanceof String) || !protocol.toString().toLowerCase().startsWith("http/") || !((portValue = this.mBeanServer.getAttribute(objectName, "port")) instanceof Number)) continue;
                    this.port = ((Number)portValue).intValue();
                    if (this.port <= 0) continue;
                    break;
                }
            }
            if (this.port > 0 && this.curator != null) {
                objectNames = this.findObjectNames(null, new String[]{"Catalina:j2eeType=WebModule,*", "Tomcat:j2eeType=WebModule,*"});
                for (ObjectName objectName : objectNames) {
                    Object pathValue = this.mBeanServer.getAttribute(objectName, "path");
                    if (pathValue == null || !(pathValue instanceof String)) continue;
                    String path = pathValue.toString();
                    String url = "http://" + this.host + ":" + this.port + path;
                    String name = path;
                    while (name.startsWith("/")) {
                        name = name.substring(1);
                    }
                    String version = "unknown";
                    String[] versionSplit = name.split("-\\d\\.\\d");
                    if (versionSplit.length < 2) {
                        versionSplit = name.split("-SNAPSHOT");
                    }
                    if (versionSplit.length > 1) {
                        String justName = versionSplit[0];
                        version = name.substring(justName.length() + 1);
                        name = justName;
                    }
                    LOGGER.info("Found name " + name + " version " + version + " url " + url + " from path " + path);
                    if (name.length() <= 0) continue;
                    this.registerWebapp(name, version, url);
                }
            }
        }
        catch (Throwable e) {
            LOGGER.warn("Failed to poll for web app mbeans " + e, e);
        }
    }

    protected Set<ObjectName> findObjectNames(QueryExp queryExp, String ... objectNames) throws MalformedObjectNameException {
        HashSet<ObjectName> answer = new HashSet<ObjectName>();
        for (String objectName : objectNames) {
            Set<ObjectName> set = this.mBeanServer.queryNames(new ObjectName(objectName), queryExp);
            if (set == null) continue;
            answer.addAll(set);
        }
        return answer;
    }

    protected NotificationListener getNotificationListener() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    protected NotificationFilter getNotificationFilter() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    protected void registerWebapp(String name, String version, String url) {
        String json = "{\"containerId\":\"" + this.containerId + "\", \"services\":[\"" + url + "\"],\"container\":\"" + this.containerId + "\"}";
        try {
            String zkPath = ZkPath.WEBAPPS_CONTAINER.getPath(new String[]{name, version, this.containerId});
            ZooKeeperUtils.setData((CuratorFramework)this.curator, (String)zkPath, (String)json, (CreateMode)CreateMode.EPHEMERAL);
        }
        catch (Exception e) {
            LOGGER.error("Failed to register webapp {}.", (Object)json, (Object)e);
        }
    }

    public void stateChanged(CuratorFramework client, ConnectionState newState) {
        switch (3.$SwitchMap$org$apache$curator$framework$state$ConnectionState[newState.ordinal()]) {
            case 1: 
            case 2: {
                this.curator = client;
                this.onConnected();
                break;
            }
            default: {
                this.onDisconnected();
                this.curator = null;
            }
        }
    }

    public void onConnected() {
    }

    public void onDisconnected() {
    }

    public FabricService getFabricService() {
        return this.fabricService;
    }

    public void setFabricService(FabricService fabricService) {
        this.fabricService = fabricService;
    }

    public CuratorFramework getCurator() {
        return this.curator;
    }

    public void setCurator(CuratorFramework curator) {
        this.curator = curator;
    }
}

