/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingOutputStream
extends OutputStream {
    private static final transient Logger LOG = LoggerFactory.getLogger(LoggingOutputStream.class);
    private final Logger logger;
    private int bufferSize = 4096;
    private ByteArrayOutputStream buffer = this.createBuffer();
    private boolean closed = false;

    public LoggingOutputStream() {
        this(LOG);
    }

    public LoggingOutputStream(Logger logger) {
        this.logger = logger;
    }

    @Override
    public void close() {
        this.flush();
        this.closed = true;
    }

    @Override
    public void flush() {
        byte[] bytes = this.buffer.toByteArray();
        if (bytes.length > 0) {
            String text = new String(bytes);
            this.logMessage(text);
            this.buffer = this.createBuffer();
        }
    }

    @Override
    public void write(int b) throws IOException {
        if (this.closed) {
            throw new IOException("Stream is closed");
        }
        char ch = (char)b;
        if (ch == '\n') {
            this.flush();
        } else {
            this.buffer.write(b);
        }
    }

    protected void logMessage(String text) {
        if (text.length() > 0) {
            this.logger.info(text);
        }
    }

    protected ByteArrayOutputStream createBuffer() {
        return new ByteArrayOutputStream(this.bufferSize);
    }
}

