/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.utils;

import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMXUtils {
    private static final transient Logger LOG = LoggerFactory.getLogger(JMXUtils.class);

    private JMXUtils() {
    }

    public static void registerMBean(Object bean, ObjectName objectName) {
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        if (mBeanServer != null) {
            try {
                JMXUtils.registerMBean(bean, mBeanServer, objectName);
            }
            catch (Exception e) {
                LOG.error("Failed to register in JMX bean " + bean + " at " + objectName + ". " + e, (Throwable)e);
            }
        }
    }

    public static void registerMBean(Object bean, MBeanServer mBeanServer, ObjectName objectName) throws Exception {
        if (!mBeanServer.isRegistered(objectName)) {
            mBeanServer.registerMBean(bean, objectName);
        } else {
            JMXUtils.unregisterMBean(mBeanServer, objectName);
            mBeanServer.registerMBean(bean, objectName);
        }
    }

    public static void unregisterMBean(ObjectName objectName) {
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        if (mBeanServer != null) {
            try {
                JMXUtils.unregisterMBean(mBeanServer, objectName);
            }
            catch (Exception e) {
                LOG.error("Failed to unregister " + objectName + ". " + e, (Throwable)e);
            }
        }
    }

    public static void unregisterMBean(MBeanServer mBeanServer, ObjectName objectName) throws Exception {
        if (mBeanServer.isRegistered(objectName)) {
            mBeanServer.unregisterMBean(objectName);
        }
    }
}

