/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.deployer;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.fabric8.agent.download.DownloadManager;
import io.fabric8.agent.download.DownloadManagers;
import io.fabric8.agent.download.ProfileDownloader;
import io.fabric8.agent.model.BundleInfo;
import io.fabric8.agent.model.Dependency;
import io.fabric8.agent.model.Feature;
import io.fabric8.agent.model.Repository;
import io.fabric8.agent.utils.AgentUtils;
import io.fabric8.api.Container;
import io.fabric8.api.FabricRequirements;
import io.fabric8.api.FabricService;
import io.fabric8.api.Profile;
import io.fabric8.api.ProfileBuilder;
import io.fabric8.api.ProfileRegistry;
import io.fabric8.api.ProfileRequirements;
import io.fabric8.api.ProfileService;
import io.fabric8.api.Profiles;
import io.fabric8.api.Version;
import io.fabric8.api.VersionBuilder;
import io.fabric8.api.scr.AbstractComponent;
import io.fabric8.api.scr.Configurer;
import io.fabric8.api.scr.ValidatingReference;
import io.fabric8.common.util.IOHelpers;
import io.fabric8.common.util.JMXUtils;
import io.fabric8.common.util.Lists;
import io.fabric8.common.util.Strings;
import io.fabric8.deployer.ProjectDeployer;
import io.fabric8.deployer.ProjectDeployerMXBean;
import io.fabric8.deployer.dto.DependencyDTO;
import io.fabric8.deployer.dto.DeployResults;
import io.fabric8.deployer.dto.DtoHelper;
import io.fabric8.deployer.dto.ProjectRequirements;
import io.fabric8.internal.Objects;
import io.fabric8.service.VersionPropertyPointerResolver;
import io.fabric8.utils.FabricValidations;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.felix.utils.version.VersionRange;
import org.apache.felix.utils.version.VersionTable;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(name="io.fabric8.deployer", label="Fabric8 Project Deploy Service", description="Allows projects (such as maven builds) to be deployed into a fabric profile.", policy=ConfigurationPolicy.OPTIONAL, immediate=true, metatype=true)
@Service(value={ProjectDeployer.class})
public final class ProjectDeployerImpl
extends AbstractComponent
implements ProjectDeployer,
ProjectDeployerMXBean {
    public static final String[] RESOLVER_IGNORE_BUNDLE_PREFIXES = new String[]{"org.slf4j", "log4j"};
    private static final transient Logger LOG = LoggerFactory.getLogger(ProjectDeployerImpl.class);
    public static ObjectName OBJECT_NAME;
    @Reference
    private Configurer configurer;
    @Reference(referenceInterface=FabricService.class)
    private final ValidatingReference<FabricService> fabricService = new ValidatingReference();
    @Reference(referenceInterface=MBeanServer.class, bind="bindMBeanServer", unbind="unbindMBeanServer")
    private MBeanServer mbeanServer;
    private ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
    private BundleContext bundleContext;
    private Map<String, String> servicemixBundles;
    private int downloadThreads;

    @Activate
    void activate(BundleContext context, Map<String, ?> configuration) throws Exception {
        this.bundleContext = context;
        this.configurer.configure(configuration, (Object)this, new String[0]);
        if (this.mbeanServer != null) {
            JMXUtils.registerMBean((Object)this, (MBeanServer)this.mbeanServer, (ObjectName)OBJECT_NAME);
        }
        this.loadServiceMixBundles();
        this.activateComponent();
    }

    @Modified
    void modified(Map<String, Object> configuration) throws Exception {
        this.configurer.configure(configuration, (Object)this, new String[0]);
    }

    @Deactivate
    void deactivate() throws Exception {
        if (this.mbeanServer != null) {
            JMXUtils.unregisterMBean((MBeanServer)this.mbeanServer, (ObjectName)OBJECT_NAME);
        }
        this.deactivateComponent();
    }

    @Override
    public DeployResults deployProjectJson(String requirementsJson) throws Exception {
        ProjectRequirements requirements = (ProjectRequirements)DtoHelper.getMapper().readValue(requirementsJson, ProjectRequirements.class);
        Objects.notNull((Object)requirements, (String)"ProjectRequirements");
        return this.deployProject(requirements);
    }

    @Override
    public DeployResults deployProject(ProjectRequirements requirements) throws Exception {
        return this.deployProject(requirements, false);
    }

    @Override
    public DeployResults deployProject(ProjectRequirements requirements, boolean merge) throws Exception {
        Version version = this.getOrCreateVersion(requirements);
        for (String parent : requirements.getParentProfiles()) {
            if (version.hasProfile(parent)) continue;
            throw new IllegalArgumentException("Parent profile " + parent + " does not exists in version " + version.getId());
        }
        Profile profile = this.getOrCreateProfile(version, requirements);
        boolean isAbstract = requirements.isAbstractProfile();
        ProfileBuilder builder = ProfileBuilder.Factory.createFrom((Profile)profile);
        builder.addAttribute("abstract", "" + isAbstract);
        ProjectRequirements oldRequirements = this.writeRequirementsJson(requirements, profile, builder);
        this.updateProfileConfiguration(version, profile, requirements, oldRequirements, builder, merge);
        return this.resolveProfileDeployments(requirements, (FabricService)this.fabricService.get(), profile, builder);
    }

    private void updateProfileConfiguration(Version version, Profile profile, ProjectRequirements requirements, ProjectRequirements oldRequirements, ProfileBuilder builder, boolean merge) {
        String fileName;
        byte[] data;
        String description;
        String webContextPath;
        List parentProfiles = Lists.mutableList((List)profile.getParentIds());
        List bundles = Lists.mutableList((List)profile.getBundles());
        List features = Lists.mutableList((List)profile.getFeatures());
        List repositories = Lists.mutableList((List)profile.getRepositories());
        if (!merge && oldRequirements != null) {
            this.removeAll(parentProfiles, oldRequirements.getParentProfiles());
            this.removeAll(bundles, oldRequirements.getBundles());
            this.removeAll(features, oldRequirements.getFeatures());
            this.removeAll(repositories, oldRequirements.getFeatureRepositories());
        }
        this.addAll(parentProfiles, requirements.getParentProfiles());
        this.addAll(bundles, requirements.getBundles());
        this.addAll(features, requirements.getFeatures());
        this.addAll(repositories, requirements.getFeatureRepositories());
        this.setParentProfileIds(builder, version, profile, parentProfiles);
        builder.setBundles(bundles);
        builder.setFeatures(features);
        builder.setRepositories(repositories);
        Boolean locked = requirements.getLocked();
        if (locked != null) {
            builder.setLocked(locked.booleanValue());
        }
        if (!Strings.isEmpty((String)(webContextPath = requirements.getWebContextPath()))) {
            String key;
            String current;
            HashMap<String, String> contextPathConfig = new HashMap<String, String>();
            Map oldValue = profile.getConfiguration("io.fabric8.web.contextPath");
            if (oldValue != null) {
                contextPathConfig.putAll(oldValue);
            }
            if (!Objects.equal((Object)(current = (String)contextPathConfig.get(key = requirements.getGroupId() + "/" + requirements.getArtifactId())), (Object)webContextPath)) {
                contextPathConfig.put(key, webContextPath);
                builder.addConfiguration("io.fabric8.web.contextPath", contextPathConfig);
            }
        }
        if (!(Strings.isEmpty((String)(description = requirements.getDescription())) || (data = profile.getFileConfiguration(fileName = "Summary.md")) != null && data.length != 0 && new String(data).trim().length() != 0)) {
            builder.addFileConfiguration(fileName, description.getBytes());
        }
    }

    private void setParentProfileIds(ProfileBuilder builder, Version version, Profile profile, List<String> parentProfileIds) {
        ArrayList<String> list = new ArrayList<String>();
        for (String parentProfileId : parentProfileIds) {
            if (version.hasProfile(parentProfileId)) {
                list.add(parentProfileId);
                continue;
            }
            LOG.warn("Could not find parent profile: " + parentProfileId + " in version " + version.getId());
        }
        builder.setParents(list);
    }

    private void addAll(List<String> list, List<String> values) {
        if (list != null && values != null) {
            for (String value : values) {
                if (list.contains(value)) continue;
                list.add(value);
            }
        }
    }

    private void removeAll(List<String> list, List<String> values) {
        if (list != null && values != null) {
            list.removeAll(values);
        }
    }

    private DeployResults resolveProfileDeployments(ProjectRequirements requirements, FabricService fabric, Profile profile, ProfileBuilder builder) throws Exception {
        String profileUrl;
        DependencyDTO rootDependency = requirements.getRootDependency();
        ProfileService profileService = (ProfileService)((FabricService)this.fabricService.get()).adapt(ProfileService.class);
        if (rootDependency != null) {
            boolean addBundleDependencies;
            LOG.info("Got root: " + rootDependency);
            List parentIds = profile.getParentIds();
            Profile overlay = profileService.getOverlayProfile(profile);
            String bundleUrl = rootDependency.toBundleUrlWithType();
            LOG.info("Using resolver to add extra features and bundles on " + bundleUrl);
            ArrayList<String> features = new ArrayList<String>();
            ArrayList<String> bundles = new ArrayList<String>();
            ArrayList<String> optionals = new ArrayList<String>();
            if (requirements.getFeatures() != null) {
                features.addAll(requirements.getFeatures());
            }
            if (requirements.getBundles() != null) {
                bundles.addAll(requirements.getBundles());
            }
            bundles.add(bundleUrl);
            LOG.info("Adding bundle: " + bundleUrl);
            boolean isKarafContainer = parentIds.contains("karaf") || parentIds.contains("containers-karaf");
            boolean bl = addBundleDependencies = Objects.equal((Object)"bundle", (Object)rootDependency.getType()) || isKarafContainer;
            if (addBundleDependencies && requirements.isUseResolver()) {
                ArrayList<Feature> availableFeatures = new ArrayList<Feature>();
                this.addAvailableFeaturesFromProfile(availableFeatures, fabric, overlay);
                HashSet<String> currentBundleLocations = new HashSet<String>();
                currentBundleLocations.addAll(bundles);
                DownloadManager downloadManager = DownloadManagers.createDownloadManager((FabricService)fabric, (ScheduledExecutorService)this.executorService);
                Set currentFeatures = AgentUtils.getFeatures((FabricService)fabric, (DownloadManager)downloadManager, (Profile)overlay);
                this.addBundlesFromProfile(currentBundleLocations, overlay);
                List<String> parentProfileIds = requirements.getParentProfiles();
                if (parentProfileIds != null) {
                    for (String parentProfileId : parentProfileIds) {
                        Profile parentProfile = profileService.getProfile(profile.getVersion(), parentProfileId);
                        Profile parentOverlay = profileService.getOverlayProfile(parentProfile);
                        Set parentFeatures = AgentUtils.getFeatures((FabricService)fabric, (DownloadManager)downloadManager, (Profile)parentOverlay);
                        currentFeatures.addAll(parentFeatures);
                        this.addAvailableFeaturesFromProfile(availableFeatures, fabric, parentOverlay);
                        this.addBundlesFromProfile(currentBundleLocations, parentOverlay);
                    }
                }
                for (DependencyDTO dependency : rootDependency.getChildren()) {
                    String prefix;
                    Feature feature;
                    String match;
                    if ("test".equals(dependency.getScope()) || "provided".equals(dependency.getScope())) continue;
                    if ("jar".equals(dependency.getType()) && (match = this.getAllServiceMixBundles().get(dependency.getGroupId() + ":" + dependency.getArtifactId() + ":" + dependency.getVersion())) != null) {
                        LOG.info("Replacing artifact " + dependency + " with servicemix bundle " + match);
                        String[] parts = match.split(":");
                        dependency.setGroupId(parts[0]);
                        dependency.setArtifactId(parts[1]);
                        dependency.setVersion(parts[2]);
                        dependency.setType("bundle");
                    }
                    if ((feature = this.findFeatureWithBundleLocationPrefix(currentFeatures, prefix = dependency.toBundleUrlWithoutVersion())) != null) {
                        LOG.info("Feature is already is in the profile " + feature.getId() + " for " + dependency.toBundleUrl());
                        continue;
                    }
                    feature = this.findFeatureWithBundleLocationPrefix(availableFeatures, prefix);
                    if (feature != null) {
                        String name = feature.getName();
                        if (features.contains(name)) {
                            LOG.info("Feature is already added " + name + " for " + dependency.toBundleUrl());
                            continue;
                        }
                        LOG.info("Found a matching feature for bundle " + dependency.toBundleUrl() + ": " + feature.getId());
                        features.add(name);
                        continue;
                    }
                    String bundleUrlWithType = dependency.toBundleUrlWithType();
                    String foundBundleUri = this.findBundleUri(currentBundleLocations, prefix);
                    if (foundBundleUri != null) {
                        LOG.info("Bundle already included " + foundBundleUri + " for " + bundleUrlWithType);
                        continue;
                    }
                    boolean ignore = false;
                    String bundleWithoutMvnPrefix = ProfileDownloader.getMavenCoords((String)bundleUrlWithType);
                    for (String ignoreBundlePrefix : RESOLVER_IGNORE_BUNDLE_PREFIXES) {
                        if (!bundleWithoutMvnPrefix.startsWith(ignoreBundlePrefix)) continue;
                        ignore = true;
                        break;
                    }
                    if (ignore) {
                        LOG.info("Ignoring bundle: " + bundleUrlWithType);
                        continue;
                    }
                    boolean optional = dependency.isOptional();
                    LOG.info("Adding " + (optional ? "optional " : "") + " bundle: " + bundleUrlWithType);
                    if (optional) {
                        optionals.add(bundleUrlWithType);
                        continue;
                    }
                    bundles.add(bundleUrlWithType);
                }
                builder.setOptionals(optionals).setFeatures(features);
            }
            builder.setBundles(bundles);
        }
        profile = profileService.updateProfile(builder.getProfile());
        Integer minimumInstances = requirements.getMinimumInstances();
        if (minimumInstances != null) {
            FabricRequirements fabricRequirements = ((FabricService)this.fabricService.get()).getRequirements();
            ProfileRequirements profileRequirements = fabricRequirements.getOrCreateProfileRequirement(profile.getId());
            profileRequirements.setMinimumInstances(minimumInstances);
            ((FabricService)this.fabricService.get()).setRequirements(fabricRequirements);
        }
        if ((profileUrl = this.findHawtioUrl(fabric)) == null) {
            profileUrl = "/";
        }
        if (!profileUrl.endsWith("/")) {
            profileUrl = profileUrl + "/";
        }
        String profilePath = Profiles.convertProfileIdToPath((String)profile.getId());
        profileUrl = profileUrl + "index.html#/wiki/branch/" + profile.getVersion() + "/view/fabric/profiles/" + profilePath;
        return new DeployResults(profile, profileUrl);
    }

    protected String findBundleUri(Set<String> bundleLocations, String prefix) {
        for (String bundleLocation : bundleLocations) {
            if (!bundleLocation.startsWith(prefix)) continue;
            return bundleLocation;
        }
        return null;
    }

    protected void addBundlesFromProfile(Set<String> currentBundleUris, Profile overlay) {
        List bundles = overlay.getBundles();
        if (bundles != null) {
            currentBundleUris.addAll(bundles);
        }
    }

    protected void addAvailableFeaturesFromProfile(Collection<Feature> allFeatures, FabricService fabric, Profile overlay) throws Exception {
        for (String repoUriWithExpressions : overlay.getRepositories()) {
            String repoUri = VersionPropertyPointerResolver.replaceVersions((FabricService)fabric, (Map)overlay.getConfigurations(), (String)repoUriWithExpressions);
            Repository repo = new Repository(URI.create(repoUri));
            repo.load();
            allFeatures.addAll(Arrays.asList(repo.getFeatures()));
        }
    }

    protected Feature findFeatureWithBundleLocationPrefix(Iterable<Feature> allFeatures, String prefix) {
        Feature feature = this.findFeatureWithBundleLocationPrefix(allFeatures, prefix, false);
        if (feature == null) {
            feature = this.findFeatureWithBundleLocationPrefix(allFeatures, prefix, true);
        }
        return feature;
    }

    protected Feature findFeatureWithBundleLocationPrefix(Iterable<Feature> allFeatures, String prefix, boolean includeDependencies) {
        for (Feature feature : allFeatures) {
            Feature matchedFeature = this.featureMatchesBundleLocationPrefix(allFeatures, feature, prefix, feature, includeDependencies);
            if (matchedFeature == null) continue;
            return matchedFeature;
        }
        return null;
    }

    protected Feature featureMatchesBundleLocationPrefix(Iterable<Feature> allFeatures, Feature feature, String prefix, Feature owningFeature, boolean includeDependencies) {
        for (BundleInfo bi : feature.getBundles()) {
            if (bi.isDependency() || !bi.getLocation().startsWith(prefix)) continue;
            return owningFeature;
        }
        if (includeDependencies) {
            for (Dependency dependency : feature.getDependencies()) {
                for (Feature f : allFeatures) {
                    Feature answer;
                    if (!f.getName().equals(dependency.getName()) || !new VersionRange(dependency.getVersion()).contains(VersionTable.getVersion(f.getVersion())) || (answer = this.featureMatchesBundleLocationPrefix(allFeatures, f, prefix, owningFeature, true)) == null) continue;
                    return answer;
                }
            }
        }
        return null;
    }

    private String findHawtioUrl(FabricService fabric) {
        Container[] containers = null;
        try {
            containers = fabric.getContainers();
        }
        catch (Exception e) {
            LOG.debug("Ignored exception trying to find containers: " + e, (Throwable)e);
            return null;
        }
        for (Container aContainer : containers) {
            Profile[] profiles;
            for (Profile aProfile : profiles = aContainer.getProfiles()) {
                String id = aProfile.getId();
                if (!id.equals("fabric")) continue;
                return fabric.profileWebAppURL("io.hawt.hawtio-web", id, aProfile.getVersion());
            }
        }
        return null;
    }

    void bindMBeanServer(MBeanServer mbeanServer) {
        this.mbeanServer = mbeanServer;
    }

    void unbindMBeanServer(MBeanServer mbeanServer) {
        this.mbeanServer = null;
    }

    void bindFabricService(FabricService fabricService) {
        this.fabricService.bind((Object)fabricService);
    }

    void unbindFabricService(FabricService fabricService) {
        this.fabricService.unbind((Object)fabricService);
    }

    private Profile getOrCreateProfile(Version version, ProjectRequirements requirements) {
        Profile profile;
        String profileId = this.getProfileId(requirements);
        if (Strings.isEmpty((String)profileId)) {
            throw new IllegalArgumentException("No profile ID could be deduced for requirements: " + requirements);
        }
        FabricValidations.validateProfileName(profileId);
        if (!version.hasProfile(profileId)) {
            LOG.info("Creating new profile " + profileId + " version " + version + " for requirements: " + requirements);
            String versionId = version.getId();
            ProfileService profileService = (ProfileService)((FabricService)this.fabricService.get()).adapt(ProfileService.class);
            ProfileBuilder builder = ProfileBuilder.Factory.create((String)versionId, (String)profileId);
            profile = profileService.createProfile(builder.getProfile());
        } else {
            profile = version.getRequiredProfile(profileId);
        }
        return profile;
    }

    private Version getOrCreateVersion(ProjectRequirements requirements) {
        ProfileService profileService = (ProfileService)((FabricService)this.fabricService.get()).adapt(ProfileService.class);
        String versionId = this.getVersionId(requirements);
        Version version = this.findVersion((FabricService)this.fabricService.get(), versionId);
        if (version == null) {
            String baseId = requirements.getBaseVersion();
            baseId = this.getVersionOrDefaultVersion((FabricService)this.fabricService.get(), baseId);
            Version baseVersion = this.findVersion((FabricService)this.fabricService.get(), baseId);
            if (baseVersion != null) {
                version = profileService.createVersionFrom(baseVersion.getId(), versionId, null);
            } else {
                version = VersionBuilder.Factory.create((String)versionId).getVersion();
                version = profileService.createVersion(version);
            }
        }
        return version;
    }

    private Version findVersion(FabricService fabricService, String versionId) {
        ProfileService profileService = (ProfileService)fabricService.adapt(ProfileService.class);
        return profileService.getVersion(versionId);
    }

    private String getVersionId(ProjectRequirements requirements) {
        String version = requirements.getVersion();
        return this.getVersionOrDefaultVersion((FabricService)this.fabricService.get(), version);
    }

    private String getVersionOrDefaultVersion(FabricService fabricService, String versionId) {
        if (Strings.isEmpty((String)versionId) && Strings.isEmpty((String)(versionId = fabricService.getDefaultVersionId()))) {
            versionId = "1.0";
        }
        return versionId;
    }

    private String getProfileId(ProjectRequirements requirements) {
        String profileId = requirements.getProfileId();
        if (Strings.isEmpty((String)profileId)) {
            String groupId = requirements.getGroupId();
            String artifactId = requirements.getArtifactId();
            if (Strings.isEmpty((String)groupId)) {
                profileId = artifactId;
            }
            profileId = Strings.isEmpty((String)artifactId) ? groupId : groupId + "-" + artifactId;
        }
        return profileId;
    }

    private ProjectRequirements writeRequirementsJson(ProjectRequirements requirements, Profile profile, ProfileBuilder builder) throws IOException {
        ObjectMapper mapper = DtoHelper.getMapper();
        byte[] json = mapper.writeValueAsBytes((Object)requirements);
        String fileName = DtoHelper.getRequirementsConfigFileName(requirements);
        ProfileRegistry profileRegistry = (ProfileRegistry)((FabricService)this.fabricService.get()).adapt(ProfileRegistry.class);
        byte[] oldData = profile.getFileConfiguration(fileName);
        LOG.info("Writing file " + fileName + " to profile " + profile);
        builder.addFileConfiguration(fileName, json);
        if (oldData == null || oldData.length == 0) {
            return null;
        }
        return (ProjectRequirements)mapper.reader(ProjectRequirements.class).readValue(oldData);
    }

    private synchronized Map<String, String> getAllServiceMixBundles() throws InterruptedException {
        this.doGetAllServiceMixBundles();
        while (this.downloadThreads > 0) {
            this.wait();
        }
        return this.servicemixBundles;
    }

    private void loadServiceMixBundles() {
        File file = this.bundleContext.getDataFile("servicemix-bundles.properties");
        if (file.exists() && file.isFile()) {
            Properties props = new Properties();
            try (FileInputStream fis = new FileInputStream(file);){
                props.load(fis);
                HashMap<String, String> map = new HashMap<String, String>();
                Enumeration<?> e = props.propertyNames();
                while (e.hasMoreElements()) {
                    String name = (String)e.nextElement();
                    map.put(name, props.getProperty(name));
                }
                long date = Long.parseLong((String)map.get("timestamp"));
                if (System.currentTimeMillis() - date < 86400000L) {
                    this.servicemixBundles = map;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.doGetAllServiceMixBundles();
    }

    private synchronized void doGetAllServiceMixBundles() {
        final ExecutorService executor = Executors.newFixedThreadPool(64);
        if (this.servicemixBundles != null) {
            return;
        }
        this.servicemixBundles = new HashMap<String, String>();
        ++this.downloadThreads;
        executor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    String md = IOHelpers.readFully((InputStream)new URL("http://central.maven.org/maven2/org/apache/servicemix/bundles/").openStream());
                    Matcher matcher = Pattern.compile("<a href=\"(org\\.apache\\.servicemix\\.bundles\\.[^\"]*)/\">").matcher(md);
                    while (matcher.find()) {
                        final String artifactId = matcher.group(1);
                        ProjectDeployerImpl projectDeployerImpl = ProjectDeployerImpl.this;
                        synchronized (projectDeployerImpl) {
                            ProjectDeployerImpl.this.downloadThreads++;
                        }
                        executor.execute(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                try {
                                    String mda = IOHelpers.readFully((InputStream)new URL("http://central.maven.org/maven2/org/apache/servicemix/bundles/" + artifactId).openStream());
                                    Matcher matcher = Pattern.compile("<a href=\"([^\\.][^\"]*)/\">").matcher(mda);
                                    while (matcher.find()) {
                                        final String version = matcher.group(1);
                                        ProjectDeployerImpl projectDeployerImpl = ProjectDeployerImpl.this;
                                        synchronized (projectDeployerImpl) {
                                            ProjectDeployerImpl.this.downloadThreads++;
                                        }
                                        executor.execute(new Runnable(){

                                            /*
                                             * WARNING - Removed try catching itself - possible behaviour change.
                                             */
                                            @Override
                                            public void run() {
                                                block11: {
                                                    try {
                                                        String pom = IOHelpers.readFully((InputStream)new URL("http://central.maven.org/maven2/org/apache/servicemix/bundles/" + artifactId + "/" + version + "/" + artifactId + "-" + version + ".pom").openStream());
                                                        String pkgGroupId = ProjectDeployerImpl.this.extract(pom, "<pkgGroupId>(.*)</pkgGroupId>");
                                                        String pkgArtifactId = ProjectDeployerImpl.this.extract(pom, "<pkgArtifactId>(.*)</pkgArtifactId>");
                                                        String pkgVersion = ProjectDeployerImpl.this.extract(pom, "<pkgVersion>(.*)</pkgVersion>");
                                                        if (pkgGroupId == null || pkgArtifactId == null || pkgVersion == null) break block11;
                                                        String key = pkgGroupId + ":" + pkgArtifactId + ":" + pkgVersion;
                                                        ProjectDeployerImpl projectDeployerImpl = ProjectDeployerImpl.this;
                                                        synchronized (projectDeployerImpl) {
                                                            String cur = (String)ProjectDeployerImpl.this.servicemixBundles.get(key);
                                                            if (cur == null) {
                                                                ProjectDeployerImpl.this.servicemixBundles.put(key, "org.apache.servicemix.bundles:" + artifactId + ":" + version);
                                                            } else {
                                                                int v1 = ProjectDeployerImpl.this.extractBundleRelease(cur);
                                                                int v2 = ProjectDeployerImpl.this.extractBundleRelease(version);
                                                                if (v2 > v1) {
                                                                    ProjectDeployerImpl.this.servicemixBundles.put(key, "org.apache.servicemix.bundles:" + artifactId + ":" + version);
                                                                }
                                                            }
                                                        }
                                                    }
                                                    catch (IOException iOException) {
                                                    }
                                                    finally {
                                                        ProjectDeployerImpl.this.downloadThreadDone(executor);
                                                    }
                                                }
                                            }
                                        });
                                    }
                                }
                                catch (IOException iOException) {
                                }
                                finally {
                                    ProjectDeployerImpl.this.downloadThreadDone(executor);
                                }
                            }
                        });
                    }
                }
                catch (IOException iOException) {
                }
                finally {
                    ProjectDeployerImpl.this.downloadThreadDone(executor);
                }
            }
        });
    }

    private synchronized void downloadThreadDone(ExecutorService executor) {
        if (--this.downloadThreads == 0) {
            executor.shutdown();
            try {
                File file = this.bundleContext.getDataFile("servicemix-bundles.properties");
                Properties props = new Properties();
                props.putAll(this.servicemixBundles);
                props.put("timestamp", Long.toString(System.currentTimeMillis()));
                try (FileOutputStream fos = new FileOutputStream(file);){
                    props.store(fos, "ServiceMix Bundles");
                }
                catch (IOException e) {}
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        this.notifyAll();
    }

    private int extractBundleRelease(String version) {
        int i1;
        int i0 = version.lastIndexOf(95);
        int i = Math.max(i0, i1 = version.lastIndexOf(45));
        if (i > 0) {
            return Integer.parseInt(version.substring(i + 1));
        }
        return -1;
    }

    private String extract(String string, String regexp) {
        Matcher matcher = Pattern.compile(regexp).matcher(string);
        return matcher.find() ? matcher.group(1) : null;
    }

    static {
        try {
            OBJECT_NAME = new ObjectName("io.fabric8:type=ProjectDeployer");
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            // empty catch block
        }
    }

    protected void bindConfigurer(Configurer configurer) {
        this.configurer = configurer;
    }

    protected void unbindConfigurer(Configurer configurer) {
        if (this.configurer == configurer) {
            this.configurer = null;
        }
    }
}

