/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.deployer;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.fabric8.api.Container;
import io.fabric8.api.Containers;
import io.fabric8.api.DataStore;
import io.fabric8.api.FabricRequirements;
import io.fabric8.api.FabricService;
import io.fabric8.api.Profile;
import io.fabric8.api.ProfileRequirements;
import io.fabric8.api.Profiles;
import io.fabric8.api.Version;
import io.fabric8.api.scr.AbstractComponent;
import io.fabric8.api.scr.Configurer;
import io.fabric8.api.scr.ValidatingReference;
import io.fabric8.common.util.JMXUtils;
import io.fabric8.deployer.ProjectDeployer;
import io.fabric8.deployer.ProjectDeployerMXBean;
import io.fabric8.deployer.dto.DependencyDTO;
import io.fabric8.deployer.dto.DeployResults;
import io.fabric8.deployer.dto.DtoHelper;
import io.fabric8.deployer.dto.ProjectRequirements;
import io.fabric8.insight.log.support.Strings;
import io.fabric8.internal.Objects;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.karaf.features.BundleInfo;
import org.apache.karaf.features.Feature;
import org.apache.karaf.features.internal.RepositoryImpl;
import org.codehaus.plexus.util.IOUtil;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(name="io.fabric8.deployer", label="Fabric8 Project Deploy Service", description="Allows projects (such as maven builds) to be deployed into a fabric profile.", policy=ConfigurationPolicy.OPTIONAL, immediate=true, metatype=true)
@Service(value={ProjectDeployer.class})
public final class ProjectDeployerImpl
extends AbstractComponent
implements ProjectDeployer,
ProjectDeployerMXBean {
    private static final transient Logger LOG = LoggerFactory.getLogger(ProjectDeployerImpl.class);
    public static ObjectName OBJECT_NAME;
    @Reference
    private Configurer configurer;
    @Reference(referenceInterface=FabricService.class, bind="bindFabricService", unbind="unbindFabricService")
    private final ValidatingReference<FabricService> fabricService = new ValidatingReference();
    @Reference(referenceInterface=MBeanServer.class, bind="bindMBeanServer", unbind="unbindMBeanServer")
    private MBeanServer mbeanServer;
    private BundleContext bundleContext;
    private Map<String, String> servicemixBundles;
    private int downloadThreads;

    @Activate
    void activate(BundleContext context, Map<String, ?> configuration) throws Exception {
        this.bundleContext = context;
        this.configurer.configure(configuration, (Object)this, new String[0]);
        if (this.mbeanServer != null) {
            JMXUtils.registerMBean((Object)this, (MBeanServer)this.mbeanServer, (ObjectName)OBJECT_NAME);
        }
        this.loadServiceMixBundles();
        this.activateComponent();
    }

    @Modified
    void modified(Map<String, Object> configuration) throws Exception {
        this.configurer.configure(configuration, (Object)this, new String[0]);
    }

    @Deactivate
    void deactivate() throws Exception {
        if (this.mbeanServer != null) {
            JMXUtils.unregisterMBean((MBeanServer)this.mbeanServer, (ObjectName)OBJECT_NAME);
        }
        this.deactivateComponent();
    }

    @Override
    public DeployResults deployProjectJson(String requirementsJson) throws Exception {
        ProjectRequirements requirements = (ProjectRequirements)DtoHelper.getMapper().readValue(requirementsJson, ProjectRequirements.class);
        Objects.notNull((Object)requirements, (String)"ProjectRequirements");
        return this.deployProject(requirements);
    }

    @Override
    public DeployResults deployProject(ProjectRequirements requirements) throws Exception {
        FabricService fabric = this.getFabricService();
        Version version = this.getOrCreateVersion(requirements);
        for (String parent : requirements.getParentProfiles()) {
            if (version.hasProfile(parent)) continue;
            throw new IllegalArgumentException("Parent profile " + parent + " does not exists in version " + version.getId());
        }
        Profile profile = this.getOrCreateProfile(version, requirements);
        if (requirements.isAbstractProfile()) {
            profile.setAttribute("abstract", "true");
        } else {
            profile.setAttribute("abstract", "false");
        }
        ProjectRequirements oldRequirements = this.writeRequirementsJson(requirements, profile);
        this.updateProfileConfiguration(version, profile, requirements, oldRequirements);
        Profile overlay = profile.getOverlay(true);
        Container container = null;
        try {
            container = fabric.getCurrentContainer();
        }
        catch (Exception e) {
            // empty catch block
        }
        Integer minimumInstances = requirements.getMinimumInstances();
        if (minimumInstances != null) {
            FabricRequirements fabricRequirements = fabric.getRequirements();
            ProfileRequirements profileRequirements = fabricRequirements.getOrCreateProfileRequirement(profile.getId());
            profileRequirements.setMinimumInstances(minimumInstances);
            fabric.setRequirements(fabricRequirements);
        }
        return this.resolveProfileDeployments(requirements, fabric, container, profile, overlay);
    }

    protected void updateProfileConfiguration(Version version, Profile profile, ProjectRequirements requirements, ProjectRequirements oldRequirements) {
        String fileName;
        byte[] data;
        String description;
        List parentProfiles = Containers.getParentProfileIds((Profile)profile);
        List bundles = profile.getBundles();
        List features = profile.getFeatures();
        List repositories = profile.getRepositories();
        if (oldRequirements != null) {
            this.removeAll(parentProfiles, oldRequirements.getParentProfiles());
            this.removeAll(bundles, oldRequirements.getBundles());
            this.removeAll(features, oldRequirements.getFeatures());
            this.removeAll(repositories, oldRequirements.getFeatureRepositories());
        }
        this.addAll(parentProfiles, requirements.getParentProfiles());
        this.addAll(bundles, requirements.getBundles());
        this.addAll(features, requirements.getFeatures());
        this.addAll(repositories, requirements.getFeatureRepositories());
        Containers.setParentProfileIds((Version)version, (Profile)profile, (List)parentProfiles);
        profile.setBundles(bundles);
        profile.setFeatures(features);
        profile.setRepositories(repositories);
        String webContextPath = requirements.getWebContextPath();
        if (!Strings.isEmpty((String)webContextPath)) {
            String key;
            String current;
            HashMap<String, String> contextPathConfig = profile.getConfiguration("io.fabric8.web.contextPath");
            if (contextPathConfig == null) {
                contextPathConfig = new HashMap<String, String>();
            }
            if (!Objects.equal((Object)(current = (String)contextPathConfig.get(key = requirements.getGroupId() + "/" + requirements.getArtifactId())), (Object)webContextPath)) {
                contextPathConfig.put(key, webContextPath);
                profile.setConfiguration("io.fabric8.web.contextPath", contextPathConfig);
            }
        }
        if (!(Strings.isEmpty((String)(description = requirements.getDescription())) || (data = profile.getFileConfiguration(fileName = "Summary.md")) != null && data.length != 0 && new String(data).trim().length() != 0)) {
            profile.setConfigurationFile(fileName, description.getBytes());
        }
    }

    protected void addAll(List<String> list, List<String> values) {
        if (list != null && values != null) {
            for (String value : values) {
                if (list.contains(value)) continue;
                list.add(value);
            }
        }
    }

    protected void removeAll(List<String> list, List<String> values) {
        if (list != null && values != null) {
            list.removeAll(values);
        }
    }

    protected DeployResults resolveProfileDeployments(ProjectRequirements requirements, FabricService fabric, Container container, Profile profile, Profile overlay) throws Exception {
        String profileUrl;
        DependencyDTO rootDependency = requirements.getRootDependency();
        ArrayList<Feature> allFeatures = new ArrayList<Feature>();
        for (String repoUri : overlay.getRepositories()) {
            RepositoryImpl repo = new RepositoryImpl(URI.create(repoUri));
            repo.load();
            allFeatures.addAll(Arrays.asList(repo.getFeatures()));
        }
        if (rootDependency != null) {
            LOG.info("Got root: " + rootDependency);
            String bundleUrl = rootDependency.toBundleUrlWithType();
            ArrayList<String> features = new ArrayList<String>();
            ArrayList<String> bundles = new ArrayList<String>();
            ArrayList<String> optionals = new ArrayList<String>();
            if (requirements.getFeatures() != null) {
                features.addAll(requirements.getFeatures());
            }
            if (requirements.getBundles() != null) {
                bundles.addAll(requirements.getBundles());
            }
            bundles.add(bundleUrl);
            LOG.info("Adding bundle: " + bundleUrl);
            for (DependencyDTO dependency : rootDependency.getChildren()) {
                String match;
                if ("test".equals(dependency.getScope()) || "provided".equals(dependency.getScope())) continue;
                if ("jar".equals(dependency.getType()) && (match = this.getAllServiceMixBundles().get(dependency.getGroupId() + ":" + dependency.getArtifactId() + ":" + dependency.getVersion())) != null) {
                    LOG.info("Replacing artifact " + dependency + " with servicemix bundle " + match);
                    String[] parts = match.split(":");
                    dependency.setGroupId(parts[0]);
                    dependency.setArtifactId(parts[1]);
                    dependency.setVersion(parts[2]);
                    dependency.setType("bundle");
                }
                String prefix = dependency.toBundleUrlWithoutVersion();
                ArrayList<Feature> matching = new ArrayList<Feature>();
                block2: for (Feature feature : allFeatures) {
                    for (BundleInfo bi : feature.getBundles()) {
                        if (bi.isDependency() || !bi.getLocation().startsWith(prefix)) continue;
                        matching.add(feature);
                        continue block2;
                    }
                }
                if (matching.size() == 1) {
                    LOG.info("Found a matching feature for bundle " + dependency.toBundleUrl() + ": " + ((Feature)matching.get(0)).getId());
                    features.add(((Feature)matching.get(0)).getName());
                    continue;
                }
                LOG.info("Adding optional bundle: " + dependency.toBundleUrlWithType());
                optionals.add(dependency.toBundleUrlWithType());
            }
            profile.setBundles(bundles);
            profile.setOptionals(optionals);
            profile.setFeatures(features);
        }
        if ((profileUrl = this.findHawtioUrl(fabric)) == null) {
            profileUrl = "/";
        }
        if (!profileUrl.endsWith("/")) {
            profileUrl = profileUrl + "/";
        }
        String profilePath = Profiles.convertProfileIdToPath((String)profile.getId());
        profileUrl = profileUrl + "index.html#/wiki/branch/" + profile.getVersion() + "/view/fabric/profiles/" + profilePath;
        return new DeployResults(profile, profileUrl);
    }

    protected String findHawtioUrl(FabricService fabric) {
        Container[] containers = null;
        try {
            containers = fabric.getContainers();
        }
        catch (Exception e) {
            LOG.debug("Ignored exception trying to find containers: " + e, (Throwable)e);
            return null;
        }
        for (Container aContainer : containers) {
            Profile[] profiles;
            for (Profile aProfile : profiles = aContainer.getProfiles()) {
                String id = aProfile.getId();
                if (!id.equals("fabric")) continue;
                return fabric.profileWebAppURL("io.hawt.hawtio-web", id, aProfile.getVersion());
            }
        }
        return null;
    }

    void bindMBeanServer(MBeanServer mbeanServer) {
        this.mbeanServer = mbeanServer;
    }

    void unbindMBeanServer(MBeanServer mbeanServer) {
        this.mbeanServer = null;
    }

    void bindFabricService(FabricService fabricService) {
        this.fabricService.bind((Object)fabricService);
    }

    void unbindFabricService(FabricService fabricService) {
        this.fabricService.unbind((Object)fabricService);
    }

    public FabricService getFabricService() {
        return (FabricService)this.fabricService.get();
    }

    protected Profile getOrCreateProfile(Version version, ProjectRequirements requirements) {
        String profileId = this.getProfileId(requirements);
        if (Strings.isEmpty((String)profileId)) {
            throw new IllegalArgumentException("No profile ID could be deduced for requirements: " + requirements);
        }
        if (!version.hasProfile(profileId)) {
            version.createProfile(profileId);
            LOG.info("Creating new profile " + profileId + " version " + version + " for requirements: " + requirements);
        } else {
            LOG.info("Updating profile " + profileId + " version " + version + " for requirements: " + requirements);
        }
        Profile profile = version.getProfile(profileId);
        Objects.notNull((Object)profile, (String)"Profile could not be created");
        return profile;
    }

    protected Version getOrCreateVersion(ProjectRequirements requirements) {
        String versionId;
        FabricService fabric = this.getFabricService();
        Version version = this.findVersion(fabric, versionId = this.getVersionId(requirements));
        if (version == null) {
            String baseVersionId = requirements.getBaseVersion();
            Version baseVersion = this.findVersion(fabric, baseVersionId = this.getVersionOrDefaultVersion(fabric, baseVersionId));
            version = baseVersion != null ? fabric.createVersion(baseVersion, versionId) : fabric.createVersion(versionId);
        }
        return version;
    }

    protected Version findVersion(FabricService fabric, String versionId) {
        Version version = null;
        try {
            version = fabric.getVersion(versionId);
        }
        catch (Exception e) {
            LOG.debug("Ignoring error looking up version " + versionId + ". It probably doesn't exist yet: " + e, (Throwable)e);
        }
        return version;
    }

    protected String getVersionId(ProjectRequirements requirements) {
        FabricService fabric = this.getFabricService();
        String version = requirements.getVersion();
        return this.getVersionOrDefaultVersion(fabric, version);
    }

    private String getVersionOrDefaultVersion(FabricService fabric, String version) {
        if (Strings.isEmpty((String)version)) {
            Version defaultVersion = fabric.getDefaultVersion();
            if (defaultVersion != null) {
                version = defaultVersion.getId();
            }
            if (Strings.isEmpty((String)version)) {
                version = "1.0";
            }
        }
        return version;
    }

    protected String getProfileId(ProjectRequirements requirements) {
        FabricService fabric = this.getFabricService();
        String profileId = requirements.getProfileId();
        if (Strings.isEmpty((String)profileId)) {
            String groupId = requirements.getGroupId();
            String artifactId = requirements.getArtifactId();
            if (Strings.isEmpty((String)groupId)) {
                profileId = artifactId;
            }
            profileId = Strings.isEmpty((String)artifactId) ? groupId : groupId + "-" + artifactId;
        }
        return profileId;
    }

    protected ProjectRequirements writeRequirementsJson(ProjectRequirements requirements, Profile profile) throws IOException {
        ObjectMapper mapper = DtoHelper.getMapper();
        byte[] json = mapper.writeValueAsBytes((Object)requirements);
        String name = DtoHelper.getRequirementsConfigFileName(requirements);
        DataStore dataStore = this.getFabricService().getDataStore();
        String version = profile.getVersion();
        String profileId = profile.getId();
        byte[] oldData = dataStore.getFileConfiguration(version, profileId, name);
        LOG.info("Writing file " + name + " to profile " + profile);
        dataStore.setFileConfiguration(version, profileId, name, json);
        if (oldData == null || oldData.length == 0) {
            return null;
        }
        return (ProjectRequirements)mapper.reader(ProjectRequirements.class).readValue(oldData);
    }

    private synchronized Map<String, String> getAllServiceMixBundles() throws InterruptedException {
        this.doGetAllServiceMixBundles();
        while (this.downloadThreads > 0) {
            this.wait();
        }
        return this.servicemixBundles;
    }

    private void loadServiceMixBundles() {
        File file = this.bundleContext.getDataFile("servicemix-bundles.properties");
        if (file.exists() && file.isFile()) {
            Properties props = new Properties();
            try (FileInputStream fis = new FileInputStream(file);){
                props.load(fis);
                HashMap<String, String> map = new HashMap<String, String>();
                Enumeration<?> e = props.propertyNames();
                while (e.hasMoreElements()) {
                    String name = (String)e.nextElement();
                    map.put(name, props.getProperty(name));
                }
                long date = Long.parseLong((String)map.get("timestamp"));
                if (System.currentTimeMillis() - date < 86400000L) {
                    this.servicemixBundles = map;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.doGetAllServiceMixBundles();
    }

    private synchronized void doGetAllServiceMixBundles() {
        final ExecutorService executor = Executors.newFixedThreadPool(64);
        if (this.servicemixBundles != null) {
            return;
        }
        this.servicemixBundles = new HashMap<String, String>();
        ++this.downloadThreads;
        executor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    String md = IOUtil.toString((InputStream)new URL("http://central.maven.org/maven2/org/apache/servicemix/bundles/").openStream());
                    Matcher matcher = Pattern.compile("<a href=\"(org\\.apache\\.servicemix\\.bundles\\.[^\"]*)/\">").matcher(md);
                    while (matcher.find()) {
                        final String artifactId = matcher.group(1);
                        ProjectDeployerImpl projectDeployerImpl = ProjectDeployerImpl.this;
                        synchronized (projectDeployerImpl) {
                            ProjectDeployerImpl.this.downloadThreads++;
                        }
                        executor.execute(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                try {
                                    String mda = IOUtil.toString((InputStream)new URL("http://central.maven.org/maven2/org/apache/servicemix/bundles/" + artifactId).openStream());
                                    Matcher matcher = Pattern.compile("<a href=\"([^\\.][^\"]*)/\">").matcher(mda);
                                    while (matcher.find()) {
                                        final String version = matcher.group(1);
                                        ProjectDeployerImpl projectDeployerImpl = ProjectDeployerImpl.this;
                                        synchronized (projectDeployerImpl) {
                                            ProjectDeployerImpl.this.downloadThreads++;
                                        }
                                        executor.execute(new Runnable(){

                                            /*
                                             * WARNING - Removed try catching itself - possible behaviour change.
                                             */
                                            @Override
                                            public void run() {
                                                block11: {
                                                    try {
                                                        String pom = IOUtil.toString((InputStream)new URL("http://central.maven.org/maven2/org/apache/servicemix/bundles/" + artifactId + "/" + version + "/" + artifactId + "-" + version + ".pom").openStream());
                                                        String pkgGroupId = ProjectDeployerImpl.this.extract(pom, "<pkgGroupId>(.*)</pkgGroupId>");
                                                        String pkgArtifactId = ProjectDeployerImpl.this.extract(pom, "<pkgArtifactId>(.*)</pkgArtifactId>");
                                                        String pkgVersion = ProjectDeployerImpl.this.extract(pom, "<pkgVersion>(.*)</pkgVersion>");
                                                        if (pkgGroupId == null || pkgArtifactId == null || pkgVersion == null) break block11;
                                                        String key = pkgGroupId + ":" + pkgArtifactId + ":" + pkgVersion;
                                                        ProjectDeployerImpl projectDeployerImpl = ProjectDeployerImpl.this;
                                                        synchronized (projectDeployerImpl) {
                                                            String cur = (String)ProjectDeployerImpl.this.servicemixBundles.get(key);
                                                            if (cur == null) {
                                                                ProjectDeployerImpl.this.servicemixBundles.put(key, "org.apache.servicemix.bundles:" + artifactId + ":" + version);
                                                            } else {
                                                                int v1 = ProjectDeployerImpl.this.extractBundleRelease(cur);
                                                                int v2 = ProjectDeployerImpl.this.extractBundleRelease(version);
                                                                if (v2 > v1) {
                                                                    ProjectDeployerImpl.this.servicemixBundles.put(key, "org.apache.servicemix.bundles:" + artifactId + ":" + version);
                                                                }
                                                            }
                                                        }
                                                    }
                                                    catch (IOException iOException) {
                                                    }
                                                    finally {
                                                        ProjectDeployerImpl.this.downloadThreadDone();
                                                    }
                                                }
                                            }
                                        });
                                    }
                                }
                                catch (IOException iOException) {
                                }
                                finally {
                                    ProjectDeployerImpl.this.downloadThreadDone();
                                }
                            }
                        });
                    }
                }
                catch (IOException iOException) {
                }
                finally {
                    ProjectDeployerImpl.this.downloadThreadDone();
                }
            }
        });
    }

    private synchronized void downloadThreadDone() {
        if (--this.downloadThreads == 0) {
            File file = this.bundleContext.getDataFile("servicemix-bundles.properties");
            Properties props = new Properties();
            props.putAll(this.servicemixBundles);
            props.put("timestamp", Long.toString(System.currentTimeMillis()));
            try (FileOutputStream fos = new FileOutputStream(file);){
                props.store(fos, "ServiceMix Bundles");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.notifyAll();
    }

    private int extractBundleRelease(String version) {
        int i1;
        int i0 = version.lastIndexOf(95);
        int i = Math.max(i0, i1 = version.lastIndexOf(45));
        if (i > 0) {
            return Integer.parseInt(version.substring(i + 1));
        }
        return -1;
    }

    private String extract(String string, String regexp) {
        Matcher matcher = Pattern.compile(regexp).matcher(string);
        return matcher.find() ? matcher.group(1) : null;
    }

    static {
        try {
            OBJECT_NAME = new ObjectName("io.fabric8:type=ProjectDeployer");
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            // empty catch block
        }
    }

    protected void bindConfigurer(Configurer configurer) {
        this.configurer = configurer;
    }

    protected void unbindConfigurer(Configurer configurer) {
        if (this.configurer == configurer) {
            this.configurer = null;
        }
    }
}

