/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.deployer;

import io.fabric8.agent.download.DownloadManager;
import io.fabric8.agent.download.DownloadManagers;
import io.fabric8.agent.mvn.Parser;
import io.fabric8.agent.utils.AgentUtils;
import io.fabric8.api.Container;
import io.fabric8.api.FabricService;
import io.fabric8.api.Profile;
import io.fabric8.common.util.Objects;
import io.fabric8.common.util.Strings;
import io.fabric8.deployer.dto.DependencyDTO;
import io.fabric8.deployer.dto.DtoHelper;
import io.fabric8.deployer.dto.ProjectRequirements;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaContainers {
    private static final transient Logger LOGGER = LoggerFactory.getLogger(JavaContainers.class);

    public static Map<String, Parser> getJavaContainerArtifacts(FabricService fabric, List<Profile> profileList, ExecutorService downloadExecutor) throws Exception {
        DownloadManager downloadManager = DownloadManagers.createDownloadManager(fabric, downloadExecutor);
        TreeMap<String, Parser> artifacts = new TreeMap<String, Parser>();
        for (Profile profile : profileList) {
            Map<String, Parser> profileArtifacts = AgentUtils.getProfileArtifacts(fabric, downloadManager, profile);
            artifacts.putAll(profileArtifacts);
            JavaContainers.appendMavenDependencies(artifacts, profile);
        }
        return artifacts;
    }

    public static Map<String, File> getJavaContainerArtifactsFiles(FabricService fabric, List<Profile> profileList, ExecutorService downloadExecutor) throws Exception {
        DownloadManager downloadManager = DownloadManagers.createDownloadManager(fabric, downloadExecutor);
        HashMap<String, File> answer = new HashMap<String, File>();
        for (Profile profile : profileList) {
            Map<String, Parser> profileArtifacts = AgentUtils.getProfileArtifacts(fabric, downloadManager, profile.getOverlay());
            JavaContainers.appendMavenDependencies(profileArtifacts, profile);
            Set<String> rawUrls = profileArtifacts.keySet();
            ArrayList<String> cleanUrlsToDownload = new ArrayList<String>();
            for (String rawUrl : rawUrls) {
                String mvnUrl = JavaContainers.removeUriPrefixBeforeMaven(rawUrl);
                cleanUrlsToDownload.add(mvnUrl);
            }
            Map<String, File> profileFiles = AgentUtils.downloadLocations(downloadManager, cleanUrlsToDownload);
            if (profileFiles == null) continue;
            answer.putAll(profileFiles);
        }
        return answer;
    }

    public static String removeUriPrefixBeforeMaven(String rawUrl) {
        String answer = rawUrl;
        int idx = answer.indexOf(":mvn:");
        if (idx > 0) {
            answer = answer.substring(idx + 1);
        }
        return answer;
    }

    protected static void appendMavenDependencies(Map<String, Parser> artifacts, Profile profile) {
        List configurationFileNames = profile.getConfigurationFileNames();
        for (String configurationFileName : configurationFileNames) {
            if (!configurationFileName.startsWith("dependencies/") || !configurationFileName.endsWith("-requirements.json")) continue;
            byte[] data = profile.getFileConfiguration(configurationFileName);
            try {
                DependencyDTO rootDependency;
                ProjectRequirements requirements = (ProjectRequirements)DtoHelper.getMapper().readValue(data, ProjectRequirements.class);
                if (requirements == null || (rootDependency = requirements.getRootDependency()) == null) continue;
                JavaContainers.addMavenDependencies(artifacts, rootDependency);
            }
            catch (IOException e) {
                LOGGER.error("Failed to parse project requirements from " + configurationFileName + ". " + e, (Throwable)e);
            }
        }
    }

    protected static void addMavenDependencies(Map<String, Parser> artifacts, DependencyDTO dependency) throws MalformedURLException {
        List<DependencyDTO> children;
        String url = dependency.toBundleUrlWithType();
        Parser parser = Parser.parsePathWithSchemePrefix(url);
        String scope = dependency.getScope();
        if (!(artifacts.containsKey(url) || artifacts.containsValue(parser) || Objects.equal((Object)"test", (Object)scope))) {
            LOGGER.debug("Adding url: " + url + " parser: " + parser);
            artifacts.put(url, parser);
        }
        if ((children = dependency.getChildren()) != null) {
            for (DependencyDTO child : children) {
                JavaContainers.addMavenDependencies(artifacts, child);
            }
        }
    }

    public static void registerJolokiaUrl(Container container, String jolokiaUrl) {
        String currentUrl;
        if (Strings.isNotBlank((String)jolokiaUrl) && !Objects.equal((Object)jolokiaUrl, (Object)(currentUrl = container.getJolokiaUrl()))) {
            container.setJolokiaUrl(jolokiaUrl);
        }
    }
}

