/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.deployer;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.fabric8.api.Container;
import io.fabric8.api.Containers;
import io.fabric8.api.DataStore;
import io.fabric8.api.FabricRequirements;
import io.fabric8.api.FabricService;
import io.fabric8.api.Profile;
import io.fabric8.api.ProfileRequirements;
import io.fabric8.api.Profiles;
import io.fabric8.api.Version;
import io.fabric8.api.scr.AbstractComponent;
import io.fabric8.api.scr.Configurer;
import io.fabric8.api.scr.ValidatingReference;
import io.fabric8.common.util.JMXUtils;
import io.fabric8.deployer.ProjectDeployerMXBean;
import io.fabric8.deployer.dto.DependencyDTO;
import io.fabric8.deployer.dto.DeployResults;
import io.fabric8.deployer.dto.DtoHelper;
import io.fabric8.deployer.dto.ProjectRequirements;
import io.fabric8.insight.log.support.Strings;
import io.fabric8.internal.Objects;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(name="io.fabric8.deployer", label="Fabric8 Project Deploy Service", description="Allows projects (such as maven builds) to be deployed into a fabric profile.", policy=ConfigurationPolicy.OPTIONAL, immediate=true, metatype=true)
public final class ProjectDeployer
extends AbstractComponent
implements ProjectDeployerMXBean {
    private static final transient Logger LOG = LoggerFactory.getLogger(ProjectDeployer.class);
    public static ObjectName OBJECT_NAME;
    @Reference
    private Configurer configurer;
    @Reference(referenceInterface=FabricService.class, bind="bindFabricService", unbind="unbindFabricService")
    private final ValidatingReference<FabricService> fabricService = new ValidatingReference();
    @Reference(referenceInterface=MBeanServer.class, bind="bindMBeanServer", unbind="unbindMBeanServer")
    private MBeanServer mbeanServer;
    private ExecutorService executorService = Executors.newSingleThreadExecutor();

    @Activate
    void activate(Map<String, ?> configuration) throws Exception {
        this.configurer.configure(configuration, (Object)this);
        if (this.mbeanServer != null) {
            JMXUtils.registerMBean((Object)this, (MBeanServer)this.mbeanServer, (ObjectName)OBJECT_NAME);
        }
        this.activateComponent();
    }

    @Modified
    void modified(Map<String, ?> configuration) throws Exception {
        this.configurer.configure(configuration, (Object)this);
    }

    @Deactivate
    void deactivate() throws Exception {
        if (this.mbeanServer != null) {
            JMXUtils.unregisterMBean((MBeanServer)this.mbeanServer, (ObjectName)OBJECT_NAME);
        }
        this.deactivateComponent();
    }

    @Override
    public DeployResults deployProjectJson(String requirementsJson) throws Exception {
        ProjectRequirements requirements = (ProjectRequirements)DtoHelper.getMapper().readValue(requirementsJson, ProjectRequirements.class);
        Objects.notNull((Object)requirements, (String)"ProjectRequirements");
        return this.deployProject(requirements);
    }

    public DeployResults deployProject(ProjectRequirements requirements) throws Exception {
        FabricService fabric = this.getFabricService();
        Version version = this.getOrCreateVersion(requirements);
        Profile profile = this.getOrCreateProfile(version, requirements);
        ProjectRequirements oldRequirements = this.writeRequirementsJson(requirements, profile);
        this.updateProfileConfiguration(version, profile, requirements, oldRequirements);
        Profile overlay = profile.getOverlay();
        Container container = null;
        try {
            container = fabric.getCurrentContainer();
        }
        catch (Exception e) {
            // empty catch block
        }
        Integer minimumInstances = requirements.getMinimumInstances();
        if (minimumInstances != null) {
            FabricRequirements fabricRequirements = fabric.getRequirements();
            ProfileRequirements profileRequirements = fabricRequirements.getOrCreateProfileRequirement(profile.getId());
            profileRequirements.setMinimumInstances(minimumInstances);
            fabric.setRequirements(fabricRequirements);
        }
        return this.resolveProfileDeployments(requirements, fabric, container, profile, overlay);
    }

    protected void updateProfileConfiguration(Version version, Profile profile, ProjectRequirements requirements, ProjectRequirements oldRequirements) {
        List parentProfiles = Containers.getParentProfileIds((Profile)profile);
        List bundles = profile.getBundles();
        List features = profile.getFeatures();
        List repositories = profile.getRepositories();
        if (oldRequirements != null) {
            this.removeAll(parentProfiles, oldRequirements.getParentProfiles());
            this.removeAll(bundles, oldRequirements.getBundles());
            this.removeAll(features, oldRequirements.getFeatures());
            this.removeAll(repositories, oldRequirements.getFeatureRepositories());
        }
        this.addAll(parentProfiles, requirements.getParentProfiles());
        this.addAll(bundles, requirements.getBundles());
        this.addAll(features, requirements.getFeatures());
        this.addAll(repositories, requirements.getFeatureRepositories());
        Containers.setParentProfileIds((Version)version, (Profile)profile, (List)parentProfiles);
        profile.setBundles(bundles);
        profile.setFeatures(features);
        profile.setRepositories(repositories);
    }

    protected void addAll(List<String> list, List<String> values) {
        if (list != null && values != null) {
            for (String value : values) {
                if (list.contains(value)) continue;
                list.add(value);
            }
        }
    }

    protected void removeAll(List<String> list, List<String> values) {
        if (list != null && values != null) {
            list.removeAll(values);
        }
    }

    protected DeployResults resolveProfileDeployments(ProjectRequirements requirements, FabricService fabric, Container container, Profile profile, Profile overlay) throws Exception {
        String profileUrl;
        DependencyDTO rootDependency = requirements.getRootDependency();
        if (rootDependency != null) {
            LOG.info("Got root: " + rootDependency);
            String bundleUrl = rootDependency.toBundleUrlWithType();
            List bundles = profile.getBundles();
            String prefix = rootDependency.toBundleUrlWithoutVersion();
            ArrayList originalBundles = new ArrayList(bundles);
            for (String bundle : originalBundles) {
                if (!bundle.startsWith(prefix)) continue;
                bundles.remove(bundle);
                if (bundle.equals(bundleUrl)) continue;
                LOG.info("Removing old version " + bundle);
            }
            bundles.add(bundleUrl);
            profile.setBundles(bundles);
            LOG.info("Adding bundle: " + bundleUrl);
        }
        if ((profileUrl = this.findHawtioUrl(fabric)) == null) {
            profileUrl = "/";
        }
        if (!profileUrl.endsWith("/")) {
            profileUrl = profileUrl + "/";
        }
        String profilePath = Profiles.convertProfileIdToPath((String)profile.getId());
        profileUrl = profileUrl + "index.html#/wiki/branch/" + profile.getVersion() + "/view/fabric/profiles/" + profilePath;
        return new DeployResults(profile, profileUrl);
    }

    protected String findHawtioUrl(FabricService fabric) {
        Container[] containers = null;
        try {
            containers = fabric.getContainers();
        }
        catch (Exception e) {
            LOG.debug("Ignored exception trying to find containers: " + e, (Throwable)e);
            return null;
        }
        for (Container aContainer : containers) {
            Profile[] profiles;
            for (Profile aProfile : profiles = aContainer.getProfiles()) {
                String id = aProfile.getId();
                if (!id.equals("fabric")) continue;
                return fabric.profileWebAppURL("io.hawt.hawtio-web", id, aProfile.getVersion());
            }
        }
        return null;
    }

    void bindMBeanServer(MBeanServer mbeanServer) {
        this.mbeanServer = mbeanServer;
    }

    void unbindMBeanServer(MBeanServer mbeanServer) {
        this.mbeanServer = null;
    }

    void bindFabricService(FabricService fabricService) {
        this.fabricService.bind((Object)fabricService);
    }

    void unbindFabricService(FabricService fabricService) {
        this.fabricService.unbind((Object)fabricService);
    }

    public FabricService getFabricService() {
        return (FabricService)this.fabricService.get();
    }

    protected Profile getOrCreateProfile(Version version, ProjectRequirements requirements) {
        String profileId = this.getProfileId(requirements);
        if (Strings.isEmpty((String)profileId)) {
            throw new IllegalArgumentException("No profile ID could be deduced for requirements: " + requirements);
        }
        if (!version.hasProfile(profileId)) {
            version.createProfile(profileId);
            LOG.info("Creating new profile " + profileId + " version " + version + " for requirements: " + requirements);
        } else {
            LOG.info("Updating profile " + profileId + " version " + version + " for requirements: " + requirements);
        }
        Profile profile = version.getProfile(profileId);
        Objects.notNull((Object)profile, (String)"Profile could not be created");
        return profile;
    }

    protected Version getOrCreateVersion(ProjectRequirements requirements) {
        String versionId;
        FabricService fabric = this.getFabricService();
        Version version = this.findVersion(fabric, versionId = this.getVersionId(requirements));
        if (version == null) {
            String baseVersionId = requirements.getBaseVersion();
            Version baseVersion = this.findVersion(fabric, baseVersionId = this.getVersionOrDefaultVersion(fabric, baseVersionId));
            version = baseVersion != null ? fabric.createVersion(baseVersion, versionId) : fabric.createVersion(versionId);
        }
        return version;
    }

    protected Version findVersion(FabricService fabric, String versionId) {
        Version version = null;
        try {
            version = fabric.getVersion(versionId);
        }
        catch (Exception e) {
            LOG.debug("Ignoring error looking up version " + versionId + ". It probably doesn't exist yet: " + e, (Throwable)e);
        }
        return version;
    }

    protected String getVersionId(ProjectRequirements requirements) {
        FabricService fabric = this.getFabricService();
        String version = requirements.getVersion();
        return this.getVersionOrDefaultVersion(fabric, version);
    }

    private String getVersionOrDefaultVersion(FabricService fabric, String version) {
        if (Strings.isEmpty((String)version)) {
            Version defaultVersion = fabric.getDefaultVersion();
            if (defaultVersion != null) {
                version = defaultVersion.getId();
            }
            if (Strings.isEmpty((String)version)) {
                version = "1.0";
            }
        }
        return version;
    }

    protected String getProfileId(ProjectRequirements requirements) {
        FabricService fabric = this.getFabricService();
        String profileId = requirements.getProfileId();
        if (Strings.isEmpty((String)profileId)) {
            String groupId = requirements.getGroupId();
            String artifactId = requirements.getArtifactId();
            if (Strings.isEmpty((String)groupId)) {
                profileId = artifactId;
            }
            profileId = Strings.isEmpty((String)artifactId) ? groupId : groupId + "-" + artifactId;
        }
        return profileId;
    }

    protected ProjectRequirements writeRequirementsJson(ProjectRequirements requirements, Profile profile) throws IOException {
        ObjectMapper mapper = DtoHelper.getMapper();
        byte[] json = mapper.writeValueAsBytes((Object)requirements);
        String name = DtoHelper.getRequirementsConfigFileName(requirements);
        DataStore dataStore = this.getFabricService().getDataStore();
        String version = profile.getVersion();
        String profileId = profile.getId();
        byte[] oldData = dataStore.getFileConfiguration(version, profileId, name);
        LOG.info("Writing file " + name + " to profile " + profile);
        dataStore.setFileConfiguration(version, profileId, name, json);
        if (oldData == null || oldData.length == 0) {
            return null;
        }
        return (ProjectRequirements)mapper.reader(ProjectRequirements.class).readValue(oldData);
    }

    static {
        try {
            OBJECT_NAME = new ObjectName("io.fabric8:type=ProjectDeployer");
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            // empty catch block
        }
    }

    protected void bindConfigurer(Configurer configurer) {
        this.configurer = configurer;
    }

    protected void unbindConfigurer(Configurer configurer) {
        if (this.configurer == configurer) {
            this.configurer = null;
        }
    }
}

