/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.utils.manifest;

import org.apache.felix.utils.manifest.Attribute;
import org.apache.felix.utils.manifest.Directive;

public class Clause {
    private final String name;
    private final Directive[] directives;
    private final Attribute[] attributes;

    public Clause(String name, Directive[] directives, Attribute[] attributes) {
        this.name = name;
        this.directives = directives;
        this.attributes = attributes;
    }

    public String getName() {
        return this.name;
    }

    public Directive[] getDirectives() {
        return this.directives;
    }

    public Attribute[] getAttributes() {
        return this.attributes;
    }

    public String getDirective(String name) {
        for (int i = 0; i < this.directives.length; ++i) {
            if (!name.equals(this.directives[i].getName())) continue;
            return this.directives[i].getValue();
        }
        return null;
    }

    public String getAttribute(String name) {
        for (int i = 0; i < this.attributes.length; ++i) {
            if (!name.equals(this.attributes[i].getName())) continue;
            return this.attributes[i].getValue();
        }
        return null;
    }

    public String toString() {
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append(this.name);
        for (i = 0; this.directives != null && i < this.directives.length; ++i) {
            sb.append(";").append(this.directives[i].getName()).append(":=");
            if (this.directives[i].getValue().matches("[0-9a-zA-Z_\\-.]*")) {
                sb.append(this.directives[i].getValue());
                continue;
            }
            sb.append("\"").append(this.directives[i].getValue().replace("\"", "\\\"")).append("\"");
        }
        for (i = 0; this.attributes != null && i < this.attributes.length; ++i) {
            sb.append(";").append(this.attributes[i].getName());
            if (this.attributes[i].getType() != null) {
                sb.append(":").append(this.attributes[i].getType());
            }
            sb.append("=");
            if (this.attributes[i].getValue().matches("[0-9a-zA-Z_\\-.]*")) {
                sb.append(this.attributes[i].getValue());
                continue;
            }
            sb.append("\"").append(this.attributes[i].getValue().replace("\"", "\\\"")).append("\"");
        }
        return sb.toString();
    }
}

