/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.container.process;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.fabric8.api.Container;
import io.fabric8.api.CreateChildContainerOptions;
import io.fabric8.api.CreateContainerBasicOptions;
import io.fabric8.api.DataStore;
import io.fabric8.api.FabricService;
import io.fabric8.api.jcip.ThreadSafe;
import io.fabric8.api.scr.AbstractComponent;
import io.fabric8.api.scr.Configurer;
import io.fabric8.api.scr.ValidatingReference;
import io.fabric8.common.util.Objects;
import io.fabric8.container.process.JolokiaAgentHelper;
import io.fabric8.container.process.ProcessManagerController;
import io.fabric8.process.manager.Installation;
import io.fabric8.process.manager.ProcessManager;
import io.fabric8.service.child.ChildContainerController;
import io.fabric8.service.child.ChildContainers;
import io.fabric8.service.child.ProcessControllerFactory;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.curator.framework.CuratorFramework;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
@Component(name="io.fabric8.container.process.controller", label="Fabric8 Child Process Container Controller", policy=ConfigurationPolicy.OPTIONAL, immediate=true, metatype=true)
@Service(value={ProcessControllerFactory.class})
public class ProcessControllerFactoryService
extends AbstractComponent
implements ProcessControllerFactory {
    private static final transient Logger LOG = LoggerFactory.getLogger(ProcessControllerFactoryService.class);
    private static final int DEFAULT_EXTERNAL_PORT = 9000;
    @Reference
    private Configurer configurer;
    @Reference(referenceInterface=FabricService.class)
    private final ValidatingReference<FabricService> fabricService = new ValidatingReference();
    @Reference(referenceInterface=CuratorFramework.class, bind="bindCurator", unbind="unbindCurator")
    private final ValidatingReference<CuratorFramework> curator = new ValidatingReference();
    @Reference(referenceInterface=ProcessManager.class)
    private final ValidatingReference<ProcessManager> processManager = new ValidatingReference();
    @Property(name="monitorPollTime", longValue={1500L}, label="Monitor poll period", description="The number of milliseconds after which the processes will be polled to check they are started and still alive.")
    private long monitorPollTime = 1500L;
    private int externalJolokiaPort;
    private int externalPortCounter;
    private int[] containerLocalIp4Address = new int[]{127, 0, 0, 0};
    private Timer keepAliveTimer;
    protected final Runnable configurationChangeHandler = new Runnable(){

        @Override
        public void run() {
            ProcessControllerFactoryService.this.onConfigurationChanged();
        }
    };

    @Activate
    void activate() {
        this.activateComponent();
        this.keepAliveTimer = new Timer("fabric8-process-container-monitor");
        TimerTask timerTask = new TimerTask(){

            @Override
            public void run() {
                ProcessControllerFactoryService.this.checkProcessesStatus();
            }
        };
        this.keepAliveTimer.schedule(timerTask, this.monitorPollTime, this.monitorPollTime);
        DataStore dataStore = this.getDataStore();
        if (dataStore != null) {
            dataStore.trackConfiguration(this.configurationChangeHandler);
        }
    }

    @Deactivate
    void deactivate() {
        DataStore dataStore = this.getDataStore();
        if (dataStore != null) {
            dataStore.untrackConfiguration(this.configurationChangeHandler);
        }
        if (this.keepAliveTimer != null) {
            this.keepAliveTimer.cancel();
            this.keepAliveTimer = null;
        }
        this.deactivateComponent();
    }

    public ChildContainerController createController(CreateChildContainerOptions options) {
        FabricService fabric = this.getFabricService();
        boolean isJavaOrProcessContainer = ChildContainers.isJavaOrProcessContainer((FabricService)fabric, (CreateContainerBasicOptions)options);
        if (isJavaOrProcessContainer) {
            return this.createProcessManagerController();
        }
        return null;
    }

    public ChildContainerController getControllerForContainer(Container container) {
        Installation installation = this.getProcessManager().getInstallation(container.getId());
        ProcessManagerController answer = null;
        if (installation != null) {
            answer = this.createProcessManagerController();
        }
        return answer;
    }

    public synchronized int createJolokiaPort(String containerId) {
        FabricService fabricService = this.getFabricService();
        Container currentContainer = fabricService.getCurrentContainer();
        Set usedPortByHost = fabricService.getPortService().findUsedPortByHost(currentContainer);
        do {
            if (this.externalJolokiaPort <= 0) {
                this.externalJolokiaPort = 8778;
                continue;
            }
            ++this.externalJolokiaPort;
        } while (usedPortByHost.contains(this.externalJolokiaPort));
        Container container = fabricService.getCurrentContainer();
        String pid = "io.fabric8.jolokia";
        String key = containerId;
        fabricService.getPortService().registerPort(container, pid, key, this.externalJolokiaPort);
        return this.externalJolokiaPort;
    }

    public synchronized int createExternalPort(String containerId, String portKey, Set<Integer> usedPortByHost, CreateContainerBasicOptions options) {
        do {
            if (this.externalPortCounter <= 0) {
                this.externalPortCounter = options.getMinimumPort();
                if (this.externalPortCounter != 0) continue;
                this.externalPortCounter = 9000;
                continue;
            }
            ++this.externalPortCounter;
        } while (usedPortByHost.contains(this.externalPortCounter));
        Container container = this.getFabricService().getCurrentContainer();
        String pid = "io.fabric8.ports";
        String key = containerId + "-" + portKey;
        this.getFabricService().getPortService().registerPort(container, pid, key, this.externalPortCounter);
        return this.externalPortCounter;
    }

    public synchronized String createContainerLocalAddress(String containerId, CreateContainerBasicOptions options) {
        for (int i = this.containerLocalIp4Address.length - 1; i >= 0; --i) {
            int n = i;
            this.containerLocalIp4Address[n] = this.containerLocalIp4Address[n] + 1;
            int counter = this.containerLocalIp4Address[n];
            if (counter <= 255) break;
            this.containerLocalIp4Address[i] = 0;
        }
        StringBuilder builder = new StringBuilder();
        for (int counter : this.containerLocalIp4Address) {
            if (builder.length() > 0) {
                builder.append(".");
            }
            builder.append("" + counter);
        }
        return builder.toString();
    }

    protected void onConfigurationChanged() {
        ProcessManager manager = this.getProcessManager();
        FabricService fabric = this.getFabricService();
        if (manager != null && fabric != null) {
            ImmutableMap map = manager.listInstallationMap();
            ImmutableSet entries = map.entrySet();
            for (Map.Entry entry : entries) {
                String id = (String)entry.getKey();
                Installation installation = (Installation)entry.getValue();
                try {
                    ChildContainerController controllerForContainer;
                    Container container = null;
                    try {
                        container = fabric.getContainer(id);
                    }
                    catch (Exception e) {
                        LOG.debug("No container for id: " + id + ". " + e, (Throwable)e);
                    }
                    if (container == null || installation == null || !((controllerForContainer = this.getControllerForContainer(container)) instanceof ProcessManagerController)) continue;
                    ProcessManagerController processManagerController = (ProcessManagerController)controllerForContainer;
                    processManagerController.updateInstallation(container, installation);
                }
                catch (Exception e) {
                    LOG.warn("Failed to get PID for process " + id + ". " + e, (Throwable)e);
                }
            }
        }
    }

    protected ProcessManagerController createProcessManagerController() {
        return new ProcessManagerController(this, this.configurer, this.getProcessManager(), this.getFabricService(), this.getCuratorFramework());
    }

    CuratorFramework getCuratorFramework() {
        return (CuratorFramework)this.curator.get();
    }

    protected ProcessManager getProcessManager() {
        return (ProcessManager)this.processManager.get();
    }

    FabricService getFabricService() {
        return (FabricService)this.fabricService.get();
    }

    protected DataStore getDataStore() {
        FabricService service = this.getFabricService();
        if (service != null) {
            return service.getDataStore();
        }
        return null;
    }

    void bindConfigurer(Configurer configurer) {
        this.configurer = configurer;
    }

    void unbindConfigurer(Configurer configurer) {
        this.configurer = null;
    }

    void bindFabricService(FabricService fabricService) {
        this.fabricService.bind((Object)fabricService);
    }

    void unbindFabricService(FabricService fabricService) {
        this.fabricService.unbind((Object)fabricService);
    }

    void bindCurator(CuratorFramework curator) {
        this.curator.bind((Object)curator);
    }

    void unbindCurator(CuratorFramework curator) {
        this.curator.unbind((Object)curator);
    }

    void bindProcessManager(ProcessManager processManager) {
        this.processManager.bind((Object)processManager);
    }

    void unbindProcessManager(ProcessManager processManager) {
        this.processManager.unbind((Object)processManager);
    }

    protected void checkProcessesStatus() {
        ProcessManager manager = this.getProcessManager();
        FabricService fabric = this.getFabricService();
        if (manager != null && fabric != null) {
            ImmutableMap map = manager.listInstallationMap();
            ImmutableSet entries = map.entrySet();
            for (Map.Entry entry : entries) {
                String id = (String)entry.getKey();
                Installation installation = (Installation)entry.getValue();
                try {
                    Container container = null;
                    try {
                        container = fabric.getContainer(id);
                    }
                    catch (Exception e) {
                        LOG.debug("No container for id: " + id + ". " + e, (Throwable)e);
                    }
                    if (container == null) continue;
                    Long pid = installation.getActivePid();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Polling container " + id + " for its PID");
                    }
                    if (pid == null) {
                        if (!container.isAlive()) continue;
                        container.setAlive(false);
                        continue;
                    }
                    if (pid == null || pid == 0L) continue;
                    if (!container.isAlive()) {
                        container.setAlive(true);
                    }
                    if (!Objects.equal((Object)container.getProvisionResult(), (Object)"success")) {
                        container.setProvisionResult("success");
                    }
                    JolokiaAgentHelper.jolokiaKeepAliveCheck(fabric, container);
                }
                catch (Exception e) {
                    LOG.warn("Failed to get PID for process " + id + ". " + e, (Throwable)e);
                }
            }
        }
    }
}

