/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.container.process;

import io.fabric8.api.Container;
import io.fabric8.api.CreateChildContainerOptions;
import io.fabric8.api.scr.support.Strings;
import io.fabric8.container.process.ProcessContainerConfig;
import io.fabric8.zookeeper.utils.ZooKeeperUtils;
import java.util.Map;
import org.apache.curator.framework.CuratorFramework;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(name="io.fabric8.zk.publish", label="Fabric8 ZooKeeper Publish Rule", immediate=false, metatype=true)
public class ZooKeeperPublishConfig {
    public static final String PROCESS_CONTAINER_ZK_PUBLISH_PID = "io.fabric8.zookeeper.publish";
    private static final transient Logger LOG = LoggerFactory.getLogger(ZooKeeperPublishConfig.class);
    @Property(label="ZooKeeper Path", description="The path in ZooKeeper to publish to")
    private String path;
    @Property(label="Publish Value", description="The value to publish to ZooKeeper.")
    private String publishValue;
    @Property(label="Export environment variable", description="The name of the environment variable to export after the publish")
    private String exportEnvironmentName;
    @Property(label="Export value", description="The value which is evaluated which if it is not blank will export an environment variable after the publish to ZooKeeper.")
    private String exportValue;

    public String toString() {
        return "ZooKeeperPublishConfig{path='" + this.path + '\'' + ", publishValue='" + this.publishValue + '\'' + '}';
    }

    public void publish(CuratorFramework curator, CreateChildContainerOptions options, ProcessContainerConfig processConfig, Container container, Map<String, String> environmentVariables) {
        LOG.info("Publishing to ZK path: " + this.path + " value " + this.publishValue);
        if (!Strings.isNullOrBlank((String)this.path)) {
            try {
                ZooKeeperUtils.setData((CuratorFramework)curator, (String)this.path, (String)this.publishValue);
            }
            catch (Exception e) {
                LOG.error("Failed to write ZK path " + this.path + " value " + this.publishValue + ". " + e, (Throwable)e);
            }
        }
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getPublishValue() {
        return this.publishValue;
    }

    public void setPublishValue(String publishValue) {
        this.publishValue = publishValue;
    }

    public String getExportEnvironmentName() {
        return this.exportEnvironmentName;
    }

    public void setExportEnvironmentName(String exportEnvironmentName) {
        this.exportEnvironmentName = exportEnvironmentName;
    }

    public String getExportValue() {
        return this.exportValue;
    }

    public void setExportValue(String exportValue) {
        this.exportValue = exportValue;
    }
}

