/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.container.process;

import io.fabric8.api.Container;
import io.fabric8.api.CreateChildContainerMetadata;
import io.fabric8.api.CreateChildContainerOptions;
import io.fabric8.api.CreateContainerBasicOptions;
import io.fabric8.api.CreateContainerOptions;
import io.fabric8.api.CreationStateListener;
import io.fabric8.api.FabricService;
import io.fabric8.api.Profiles;
import io.fabric8.api.scr.Configurer;
import io.fabric8.api.scr.support.Strings;
import io.fabric8.common.util.Objects;
import io.fabric8.container.process.JavaContainerConfig;
import io.fabric8.container.process.JolokiaAgentHelper;
import io.fabric8.container.process.ProcessContainerConfig;
import io.fabric8.container.process.ProcessControllerFactoryService;
import io.fabric8.container.process.ZooKeeperPublishConfig;
import io.fabric8.deployer.JavaContainers;
import io.fabric8.process.manager.InstallOptions;
import io.fabric8.process.manager.InstallTask;
import io.fabric8.process.manager.Installation;
import io.fabric8.process.manager.ProcessManager;
import io.fabric8.process.manager.support.ApplyConfigurationTask;
import io.fabric8.process.manager.support.CompositeTask;
import io.fabric8.process.manager.support.DownloadResourcesTask;
import io.fabric8.process.manager.support.InstallDeploymentsTask;
import io.fabric8.process.manager.support.ProcessUtils;
import io.fabric8.service.child.ChildContainerController;
import io.fabric8.service.child.ChildContainers;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.curator.framework.CuratorFramework;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessManagerController
implements ChildContainerController {
    private static final transient Logger LOG = LoggerFactory.getLogger(ProcessManagerController.class);
    private final ProcessControllerFactoryService owner;
    private final Configurer configurer;
    private final ProcessManager processManager;
    private final FabricService fabricService;
    private final ExecutorService downloadExecutor = Executors.newSingleThreadExecutor();
    private final CuratorFramework curator;

    public ProcessManagerController(ProcessControllerFactoryService owner, Configurer configurer, ProcessManager processManager, FabricService fabricService, CuratorFramework curator) {
        this.owner = owner;
        this.configurer = configurer;
        this.processManager = processManager;
        this.fabricService = fabricService;
        this.curator = curator;
    }

    public CreateChildContainerMetadata create(CreateChildContainerOptions options, CreationStateListener listener) throws Exception {
        String jolokiaUrl;
        CreateChildContainerMetadata metadata = new CreateChildContainerMetadata();
        String containerId = options.getName();
        metadata.setCreateOptions((CreateContainerOptions)options);
        metadata.setContainerName(containerId);
        Container container = null;
        try {
            container = this.fabricService.getContainer(containerId);
        }
        catch (Exception e) {
            LOG.debug("Could nto find container: " + containerId);
        }
        Map environmentVariables = ChildContainers.getEnvironmentVariables((FabricService)this.fabricService, (CreateContainerBasicOptions)options);
        ProcessContainerConfig processConfig = this.createProcessContainerConfig(options);
        if (container != null) {
            this.registerPorts(options, processConfig, container, environmentVariables);
        }
        JolokiaAgentHelper.substituteEnvironmentVariableExpressions(environmentVariables, environmentVariables);
        this.publishZooKeeperValues(options, processConfig, container, environmentVariables);
        Installation installation = null;
        InstallOptions parameters = null;
        try {
            if (ChildContainers.isJavaContainer((FabricService)this.fabricService, (CreateContainerBasicOptions)options)) {
                parameters = this.createJavaInstallOptions(container, metadata, options, environmentVariables);
                Objects.notNull((Object)parameters, (String)"JavaInstall parameters");
                installation = this.processManager.installJar(parameters);
            } else {
                parameters = this.createProcessInstallOptions(container, metadata, options, processConfig, environmentVariables);
                InstallTask postInstall = this.createProcessPostInstall(container, options, processConfig, environmentVariables);
                Objects.notNull((Object)parameters, (String)"process parameters");
                installation = this.processManager.install(parameters, postInstall);
            }
        }
        catch (Exception e) {
            this.handleException("Creating container " + containerId, e);
        }
        LOG.info("Creating process container with environment vars: " + environmentVariables);
        String defaultHost = this.fabricService.getCurrentContainer().getLocalHostname();
        if (Strings.isNullOrBlank((String)defaultHost)) {
            defaultHost = "localhost";
        }
        if (!Strings.isNullOrBlank((String)(jolokiaUrl = JolokiaAgentHelper.findJolokiaUrlFromEnvironmentVariables(environmentVariables, defaultHost)))) {
            JavaContainers.registerJolokiaUrl((Container)container, (String)jolokiaUrl);
        }
        if (installation != null) {
            installation.getController().start();
        }
        return metadata;
    }

    public void start(Container container) {
        Installation installation = this.getInstallation(container);
        if (installation != null) {
            try {
                installation.getController().start();
            }
            catch (Exception e) {
                this.handleException("Starting container " + container.getId(), e);
            }
        }
    }

    public void stop(Container container) {
        Installation installation = this.getInstallation(container);
        if (installation != null) {
            try {
                installation.getController().stop();
            }
            catch (Exception e) {
                this.handleException("Stopping container " + container.getId(), e);
            }
        }
    }

    public void destroy(Container container) {
        Installation installation = this.getInstallation(container);
        if (installation != null) {
            try {
                installation.getController().stop();
            }
            catch (Exception e) {
                LOG.info("Failed to stop process for container " + container.getId() + ". " + e, (Throwable)e);
            }
            installation.getController().uninstall();
        }
    }

    protected InstallOptions createJavaInstallOptions(Container container, CreateChildContainerMetadata metadata, CreateChildContainerOptions options, Map<String, String> environmentVariables) throws Exception {
        Set profileIds = options.getProfiles();
        String versionId = options.getVersion();
        Map javaContainerConfig = Profiles.getOverlayConfiguration((FabricService)this.fabricService, (Iterable)options.getProfiles(), (String)options.getVersion(), (String)"io.fabric8.container.java");
        JavaContainerConfig javaConfig = new JavaContainerConfig();
        this.configurer.configure(javaContainerConfig, (Object)javaConfig);
        boolean isJavaContainer = true;
        javaConfig.updateEnvironmentVariables(environmentVariables, isJavaContainer);
        if (JolokiaAgentHelper.hasJolokiaAgent(environmentVariables)) {
            int jolokiaPort = this.owner.createJolokiaPort(container.getId());
            JolokiaAgentHelper.substituteEnvironmentVariables(javaConfig, environmentVariables, isJavaContainer, JolokiaAgentHelper.getJolokiaPortOverride(jolokiaPort), JolokiaAgentHelper.getJolokiaAgentIdOverride(this.fabricService.getEnvironment()));
        } else {
            JolokiaAgentHelper.substituteEnvironmentVariables(javaConfig, environmentVariables, isJavaContainer, JolokiaAgentHelper.getJolokiaAgentIdOverride(this.fabricService.getEnvironment()));
        }
        List profiles = Profiles.getProfiles((FabricService)this.fabricService, (Iterable)profileIds, (String)versionId);
        Map javaArtifacts = JavaContainers.getJavaContainerArtifactsFiles((FabricService)this.fabricService, (List)profiles, (ExecutorService)this.downloadExecutor);
        this.setProvisionList(container, javaArtifacts);
        InstallOptions.InstallOptionsBuilder builder = InstallOptions.builder();
        builder.jarFiles(javaArtifacts.values());
        builder.id(options.getName());
        builder.environment(environmentVariables);
        String mainClass = environmentVariables.get("FABRIC8_JAVA_MAIN");
        String name = "java";
        if (!Strings.isNullOrBlank((String)mainClass)) {
            name = name + " " + mainClass;
        }
        builder.name(name);
        metadata.setContainerType(name);
        builder.mainClass(mainClass);
        return builder.build();
    }

    protected InstallOptions createProcessInstallOptions(Container container, CreateChildContainerMetadata metadata, CreateChildContainerOptions options, ProcessContainerConfig configObject, Map<String, String> environmentVariables) throws Exception {
        return configObject.createProcessInstallOptions(this.fabricService, metadata, options, environmentVariables);
    }

    private ProcessContainerConfig createProcessContainerConfig(CreateChildContainerOptions options) throws Exception {
        Set profileIds = options.getProfiles();
        String versionId = options.getVersion();
        Map configuration = Profiles.getOverlayConfiguration((FabricService)this.fabricService, (Iterable)profileIds, (String)versionId, (String)"io.fabric8.container.process");
        ProcessContainerConfig configObject = new ProcessContainerConfig();
        this.configurer.configure(configuration, (Object)configObject);
        return configObject;
    }

    protected InstallTask createProcessPostInstall(Container container, CreateChildContainerOptions options, ProcessContainerConfig configObject, Map<String, String> environmentVariables) throws Exception {
        Map javaArtifacts;
        Map overlayResources;
        Map configuration;
        Set profileIds = options.getProfiles();
        String versionId = options.getVersion();
        List profiles = Profiles.getProfiles((FabricService)this.fabricService, (Iterable)profileIds, (String)versionId);
        String layout = configObject.getOverlayFolder();
        InstallTask answer = null;
        if (layout != null && (configuration = ProcessUtils.getProcessLayout((List)profiles, (String)layout)) != null && !configuration.isEmpty()) {
            HashMap<String, String> variables = Profiles.getOverlayConfiguration((FabricService)this.fabricService, (Iterable)profileIds, (String)versionId, (String)"io.fabric8.template.variables");
            if (variables == null) {
                variables = new HashMap<String, String>();
            } else {
                JolokiaAgentHelper.substituteEnvironmentVariableExpressions((Map<String, String>)variables, environmentVariables);
            }
            variables.putAll(environmentVariables);
            LOG.info("Using template variables for MVEL: " + variables);
            answer = new ApplyConfigurationTask(configuration, variables);
        }
        if ((overlayResources = Profiles.getOverlayConfiguration((FabricService)this.fabricService, (Iterable)profileIds, (String)versionId, (String)"io.fabric8.container.process.overlay.resources")) != null && !overlayResources.isEmpty()) {
            answer = CompositeTask.combine(answer, (InstallTask)new DownloadResourcesTask(overlayResources));
        }
        if (!configObject.isInternalAgent() && !(javaArtifacts = JavaContainers.getJavaContainerArtifactsFiles((FabricService)this.fabricService, (List)profiles, (ExecutorService)this.downloadExecutor)).isEmpty()) {
            answer = CompositeTask.combine((InstallTask)answer, (InstallTask)new InstallDeploymentsTask(javaArtifacts));
            this.setProvisionList(container, javaArtifacts);
        }
        return answer;
    }

    protected void setProvisionList(Container container, Map<String, File> javaArtifacts) {
        if (container != null) {
            ArrayList<String> provisionList = new ArrayList<String>();
            for (String name : javaArtifacts.keySet()) {
                int idx = name.indexOf(":mvn:");
                if (idx > 0) {
                    name = name.substring(idx + 1);
                }
                provisionList.add(name);
            }
            Collections.sort(provisionList);
            container.setProvisionList(provisionList);
        }
    }

    protected void registerPorts(CreateChildContainerOptions options, ProcessContainerConfig processConfig, Container container, Map<String, String> environmentVariables) {
        String containerId = options.getName();
        HashMap exposedPorts = new HashMap();
        HashMap<String, Integer> internalPorts = new HashMap<String, Integer>();
        HashMap<String, Integer> externalPorts = new HashMap<String, Integer>();
        Set usedPortByHost = this.fabricService.getPortService().findUsedPortByHost(this.fabricService.getCurrentContainer());
        HashMap emptyMap = new HashMap();
        Set profileIds = options.getProfiles();
        String versionId = options.getVersion();
        Map ports = Profiles.getOverlayConfiguration((FabricService)this.fabricService, (Iterable)profileIds, (String)versionId, (String)"io.fabric8.ports");
        TreeMap<Integer, String> sortedInternalPorts = new TreeMap<Integer, String>();
        for (Map.Entry portEntry : ports.entrySet()) {
            String portName = (String)portEntry.getKey();
            String portText = (String)portEntry.getValue();
            if (portText == null || io.fabric8.common.util.Strings.isNullOrBlank((String)portText)) continue;
            Integer port = null;
            try {
                port = Integer.parseInt(portText);
            }
            catch (NumberFormatException e) {
                LOG.warn("Ignoring bad port number for " + portName + " value '" + portText + "' in PID: " + "io.fabric8.ports");
            }
            if (port != null) {
                sortedInternalPorts.put(port, portName);
                internalPorts.put(portName, port);
                exposedPorts.put(portText + "/tcp", emptyMap);
                continue;
            }
            LOG.info("No port for " + portName);
        }
        String jolokiaUrl = null;
        Container currentContainer = this.fabricService.getCurrentContainer();
        String listenHost = currentContainer.getLocalIp();
        if (Strings.isNullOrBlank((String)listenHost)) {
            listenHost = currentContainer.getLocalHostname();
        }
        if (Strings.isNullOrBlank((String)listenHost)) {
            listenHost = "localhost";
        }
        if (!environmentVariables.containsKey("FABRIC8_LISTEN_ADDRESS")) {
            environmentVariables.put("FABRIC8_LISTEN_ADDRESS", listenHost);
        }
        HashSet<String> disableDynamicPorts = new HashSet<String>();
        String[] dynamicPortArray = processConfig.getDisableDynamicPorts();
        if (dynamicPortArray != null) {
            disableDynamicPorts.addAll(Arrays.asList(dynamicPortArray));
        }
        for (Map.Entry entry : sortedInternalPorts.entrySet()) {
            Integer port = (Integer)entry.getKey();
            String portName = (String)entry.getValue();
            int externalPort = port;
            if (!disableDynamicPorts.contains(portName)) {
                externalPort = this.owner.createExternalPort(containerId, portName, usedPortByHost, (CreateContainerBasicOptions)options);
            }
            externalPorts.put(portName, externalPort);
            environmentVariables.put("FABRIC8_" + portName + "_PORT", "" + port);
            environmentVariables.put("FABRIC8_" + portName + "_PROXY_PORT", "" + externalPort);
            if (!portName.equals("JOLOKIA")) continue;
            jolokiaUrl = "http://" + listenHost + ":" + externalPort + "/jolokia/";
            LOG.info("Found Jolokia URL: " + jolokiaUrl);
        }
        if (processConfig.isCreateLocalContainerAddress()) {
            environmentVariables.put("FABRIC8_LOCAL_CONTAINER_ADDRESS", this.owner.createContainerLocalAddress(containerId, (CreateContainerBasicOptions)options));
        }
        if (jolokiaUrl != null) {
            JavaContainers.registerJolokiaUrl((Container)container, jolokiaUrl);
        }
    }

    protected void publishZooKeeperValues(CreateChildContainerOptions options, ProcessContainerConfig processConfig, Container container, Map<String, String> environmentVariables) {
        Map publishConfigurations = Profiles.getOverlayFactoryConfigurations((FabricService)this.fabricService, (Iterable)options.getProfiles(), (String)options.getVersion(), (String)"io.fabric8.zookeeper.publish");
        Set entries = publishConfigurations.entrySet();
        for (Map.Entry entry : entries) {
            String configName = (String)entry.getKey();
            Map exportConfig = (Map)entry.getValue();
            if (exportConfig == null || exportConfig.isEmpty()) continue;
            JolokiaAgentHelper.substituteEnvironmentVariableExpressions(exportConfig, environmentVariables);
            ZooKeeperPublishConfig config = new ZooKeeperPublishConfig();
            try {
                this.configurer.configure(exportConfig, (Object)config);
                config.publish(this.curator, options, processConfig, container, environmentVariables);
            }
            catch (Exception e) {
                LOG.warn("Failed to publish configuration " + configName + " of " + config + " due to: " + e, (Throwable)e);
            }
        }
    }

    protected Installation getInstallation(Container container) {
        return this.processManager.getInstallation(container.getId());
    }

    protected void handleException(String message, Exception cause) {
        throw new RuntimeException(message + ". " + cause, cause);
    }
}

