/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.container.process;

import io.fabric8.common.util.Strings;
import java.util.Map;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;

@Component(name="io.fabric8.container.java", label="Fabric8 Java Child Container Configuration", immediate=false, metatype=true)
public class JavaContainerConfig {
    @Property(label="Java main class", description="The name of the Java class which contains a static main(String[] args) function.")
    private String mainClass;
    @Property(label="Arguments", description="The Java main's command line arguments to pass in.")
    private String arguments;
    @Property(label="Java Agent", description="The JVM's Java Agent setting. Usually we enable jolokia for this value.")
    private String javaAgent;
    @Property(label="JVM arguments", description="The JVM command line options such as to set the memory size and garbage collection settings.")
    private String jvmArguments;

    public void updateEnvironmentVariables(Map<String, String> environmentVariables, boolean isJavaContainer) {
        if (Strings.isNotBlank((String)this.mainClass)) {
            environmentVariables.put("FABRIC8_JAVA_MAIN", this.mainClass);
        } else {
            if (isJavaContainer) {
                throw new IllegalArgumentException("No mainClass value is specified in the io.fabric8.container.java configuration!");
            }
            environmentVariables.remove("FABRIC8_JAVA_MAIN");
        }
        if (Strings.isNotBlank((String)this.arguments)) {
            environmentVariables.put("FABRIC8_MAIN_ARGS", this.arguments);
        }
        if (Strings.isNotBlank((String)this.javaAgent)) {
            environmentVariables.put("FABRIC8_JAVA_AGENT", this.javaAgent);
        }
        if (Strings.isNotBlank((String)this.jvmArguments)) {
            environmentVariables.put("FABRIC8_JVM_ARGS", this.jvmArguments);
        }
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public void setMainClass(String mainClass) {
        this.mainClass = mainClass;
    }

    public String getArguments() {
        return this.arguments;
    }

    public void setArguments(String arguments) {
        this.arguments = arguments;
    }

    public String getJavaAgent() {
        return this.javaAgent;
    }

    public void setJavaAgent(String javaAgent) {
        this.javaAgent = javaAgent;
    }

    public String getJvmArguments() {
        return this.jvmArguments;
    }

    public void setJvmArguments(String jvmArguments) {
        this.jvmArguments = jvmArguments;
    }
}

