/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.partition.internal.repositories;

import io.fabric8.api.DataStore;
import io.fabric8.api.FabricService;
import io.fabric8.api.scr.AbstractComponent;
import io.fabric8.api.scr.Configurer;
import io.fabric8.api.scr.ValidatingReference;
import io.fabric8.partition.WorkItemRepository;
import io.fabric8.partition.WorkItemRepositoryFactory;
import io.fabric8.partition.internal.repositories.ProfileWorkItemRepository;
import java.util.Map;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.osgi.service.url.URLStreamHandlerService;

@Component(name="io.fabric8.partition.repository.profile", label="Fabric8 Profile Work Item WorkItemRepository", metatype=true)
@Service(value={WorkItemRepositoryFactory.class})
@Properties(value={@Property(name="type", value={"profile"})})
public class ProfileWorkItemRepositoryFactory
extends AbstractComponent
implements WorkItemRepositoryFactory {
    public static final String TYPE = "profile";
    public static final String SCHEME = "profile";
    public static final String ID = "io.fabric8.partition.repository.profile";
    @Property(name="name", label="Container Name", description="The name of the container", value={"${runtime.id}"}, propertyPrivate=true)
    private String name;
    @Reference
    private Configurer configurer;
    @Reference(referenceInterface=DataStore.class)
    private final ValidatingReference<DataStore> dataStore = new ValidatingReference();
    @Reference(referenceInterface=FabricService.class)
    private final ValidatingReference<FabricService> fabricService = new ValidatingReference();
    @Reference(referenceInterface=URLStreamHandlerService.class, target="(url.handler.protocol=profile)")
    private final ValidatingReference<URLStreamHandlerService> urlHandler = new ValidatingReference();

    @Activate
    void activate(Map<String, ?> configuration) throws Exception {
        this.configurer.configure(configuration, (Object)this, new String[0]);
        this.activateComponent();
    }

    @Deactivate
    void deactivate() {
        this.deactivateComponent();
    }

    @Override
    public String getType() {
        return "profile";
    }

    @Override
    public WorkItemRepository build(String path) {
        this.assertValid();
        return new ProfileWorkItemRepository(this.name, (DataStore)this.dataStore.get(), path, (FabricService)this.fabricService.get());
    }

    void bindDataStore(DataStore dataStore) {
        this.dataStore.bind((Object)dataStore);
    }

    void unbindDataStore(DataStore dataStore) {
        this.dataStore.unbind((Object)dataStore);
    }

    void bindFabricService(FabricService fabricService) {
        this.fabricService.bind((Object)fabricService);
    }

    void unbindFabricService(FabricService fabricService) {
        this.fabricService.unbind((Object)fabricService);
    }

    void bindUrlHandler(URLStreamHandlerService urlHandler) {
        this.urlHandler.bind((Object)urlHandler);
    }

    void unbindUrlHandler(URLStreamHandlerService urlHandler) {
        this.urlHandler.unbind((Object)urlHandler);
    }

    protected void bindConfigurer(Configurer configurer) {
        this.configurer = configurer;
    }

    protected void unbindConfigurer(Configurer configurer) {
        if (this.configurer == configurer) {
            this.configurer = null;
        }
    }
}

