/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.partition.internal.repositories;

import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.io.Resources;
import io.fabric8.api.DataStore;
import io.fabric8.api.FabricException;
import io.fabric8.api.FabricService;
import io.fabric8.api.Profile;
import io.fabric8.api.ProfileRegistry;
import io.fabric8.api.ProfileService;
import io.fabric8.partition.internal.BaseWorkItemRepository;
import io.fabric8.partition.internal.repositories.ZkWorkItemRepository;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileWorkItemRepository
extends BaseWorkItemRepository
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZkWorkItemRepository.class);
    private final String name;
    private final FabricService fabricService;
    private final DataStore dataStore;
    private final String profileId;
    private final String folderPath;
    private volatile String lastModified = "";

    public ProfileWorkItemRepository(String name, DataStore dataStore, String partitionsPath, FabricService fabricService) {
        this.name = name;
        this.dataStore = dataStore;
        this.fabricService = fabricService;
        int index = partitionsPath.indexOf("/");
        this.profileId = partitionsPath.substring("profile:".length(), index);
        this.folderPath = partitionsPath.substring(index + 1);
    }

    @Override
    public void start() {
        this.dataStore.trackConfiguration((Runnable)this);
        this.run();
    }

    @Override
    public void stop() {
        this.dataStore.untrackConfiguration((Runnable)this);
    }

    @Override
    public void close() {
        this.stop();
    }

    @Override
    public List<String> listWorkItemLocations() {
        ArrayList items = Lists.newArrayList();
        try {
            ProfileService profileService = (ProfileService)this.fabricService.adapt(ProfileService.class);
            String version = this.dataStore.getContainerVersion(this.name);
            Profile p = profileService.getRequiredProfile(version, this.profileId);
            for (String f : p.getFileConfigurations().keySet()) {
                if (!f.startsWith(this.folderPath)) continue;
                items.add(f);
            }
        }
        catch (Exception e) {
            LOGGER.debug("Error getting work items from profile repository. Returning empty.", (Throwable)e);
        }
        return items;
    }

    @Override
    public String readContent(String location) {
        try {
            return Resources.toString((URL)new URL("profile:" + location), (Charset)Charsets.UTF_8);
        }
        catch (Exception e) {
            throw FabricException.launderThrowable((Throwable)e);
        }
    }

    @Override
    public void run() {
        String versionId;
        ProfileRegistry profileRegistry = (ProfileRegistry)this.fabricService.adapt(ProfileRegistry.class);
        Profile profile = profileRegistry.getProfile(versionId = this.dataStore.getContainerVersion(this.name), versionId);
        if (profile != null && !profile.getProfileHash().equals(this.lastModified)) {
            this.notifyListeners();
            this.lastModified = profile.getProfileHash();
        }
    }
}

