/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.partition.internal.repositories;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.io.Resources;
import io.fabric8.api.FabricException;
import io.fabric8.partition.internal.BaseWorkItemRepository;
import io.fabric8.partition.internal.functions.ChildDataToPath;
import io.fabric8.zookeeper.utils.ZooKeeperUtils;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.cache.PathChildrenCache;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheEvent;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkWorkItemRepository
extends BaseWorkItemRepository
implements PathChildrenCacheListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZkWorkItemRepository.class);
    private final ExecutorService executorService = Executors.newSingleThreadExecutor();
    private final String partitionsPath;
    private final CuratorFramework curator;
    private volatile PathChildrenCache partitionCache;

    public ZkWorkItemRepository(CuratorFramework curator, String partitionsPath) {
        this.partitionsPath = partitionsPath;
        this.curator = curator;
    }

    @Override
    public synchronized void start() {
        try {
            ZooKeeperUtils.createDefault((CuratorFramework)this.curator, (String)this.partitionsPath, null);
            if (this.partitionCache == null) {
                this.partitionCache = new PathChildrenCache(this.curator, this.partitionsPath, true, false, this.executorService);
                this.partitionCache.getListenable().addListener((Object)this);
                this.partitionCache.start(PathChildrenCache.StartMode.POST_INITIALIZED_EVENT);
                this.partitionCache.rebuild();
            }
        }
        catch (Exception e) {
            throw FabricException.launderThrowable((Throwable)e);
        }
    }

    @Override
    public synchronized void stop() {
        if (this.partitionCache != null) {
            try {
                this.partitionCache.close();
                this.partitionCache = null;
            }
            catch (IOException e) {
                throw FabricException.launderThrowable((Throwable)e);
            }
        }
    }

    @Override
    public void close() {
        this.stop();
        this.executorService.shutdownNow();
    }

    @Override
    public List<String> listWorkItemLocations() {
        List children = this.partitionCache.getCurrentData();
        return Lists.transform((List)children, (Function)ChildDataToPath.INSTANCE);
    }

    @Override
    public String readContent(String location) {
        try {
            return Resources.toString((URL)new URL("zk:" + location), (Charset)Charsets.UTF_8);
        }
        catch (Exception e) {
            throw FabricException.launderThrowable((Throwable)e);
        }
    }

    public void childEvent(CuratorFramework client, PathChildrenCacheEvent event) throws Exception {
        switch (event.getType()) {
            case INITIALIZED: 
            case CHILD_ADDED: 
            case CHILD_REMOVED: {
                this.notifyListeners();
            }
        }
    }
}

