/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.partition.internal.repositories;

import io.fabric8.api.scr.AbstractComponent;
import io.fabric8.api.scr.ValidatingReference;
import io.fabric8.partition.WorkItemRepository;
import io.fabric8.partition.WorkItemRepositoryFactory;
import io.fabric8.partition.internal.repositories.ZkWorkItemRepository;
import org.apache.curator.framework.CuratorFramework;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.osgi.service.url.URLStreamHandlerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(name="io.fabric8.partition.repository.zookeeper", label="Fabric8 ZooKeeper Work Item WorkItemRepository", metatype=false)
@Service(value={WorkItemRepositoryFactory.class})
@Properties(value={@Property(name="type", value={"zookeeper"})})
public class ZkWorkItemRepositoryFactory
extends AbstractComponent
implements WorkItemRepositoryFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZkWorkItemRepositoryFactory.class);
    public static final String TYPE = "zookeeper";
    public static final String SCHEME = "zk";
    public static final String ID = "io.fabric8.partition.repository.zookeeper";
    @Reference(referenceInterface=CuratorFramework.class)
    private final ValidatingReference<CuratorFramework> curator = new ValidatingReference();
    @Reference(referenceInterface=URLStreamHandlerService.class, target="url.handler.protocol=zk")
    private final ValidatingReference<URLStreamHandlerService> urlHandler = new ValidatingReference();

    @Activate
    void activate() {
        this.activateComponent();
    }

    @Deactivate
    void deactivate() {
        this.deactivateComponent();
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public WorkItemRepository build(String path) {
        this.assertValid();
        return new ZkWorkItemRepository((CuratorFramework)this.curator.get(), path);
    }

    void bindCurator(CuratorFramework curator) {
        this.curator.bind((Object)curator);
    }

    void unbindCurator(CuratorFramework curator) {
        this.curator.unbind((Object)curator);
    }

    void bindUrlHandler(URLStreamHandlerService urlHandler) {
        this.urlHandler.bind((Object)urlHandler);
    }

    void unbindUrlHandler(URLStreamHandlerService urlHandler) {
        this.urlHandler.unbind((Object)urlHandler);
    }
}

