/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.partition.internal.repositories;

import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.io.Resources;
import io.fabric8.api.FabricException;
import io.fabric8.api.FabricService;
import io.fabric8.api.Profile;
import io.fabric8.api.Version;
import io.fabric8.git.internal.GitDataStore;
import io.fabric8.partition.internal.BaseWorkItemRepository;
import io.fabric8.partition.internal.repositories.ZkWorkItemRepository;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileWorkItemRepository
extends BaseWorkItemRepository
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZkWorkItemRepository.class);
    private final String name;
    private final FabricService fabricService;
    private final GitDataStore dataStore;
    private final String profile;
    private final String folderPath;
    private volatile String lastModified = "";

    public ProfileWorkItemRepository(String name, GitDataStore dataStore, String partitionsPath, FabricService fabricService) {
        this.name = name;
        this.dataStore = dataStore;
        this.fabricService = fabricService;
        int index = partitionsPath.indexOf("/");
        this.profile = partitionsPath.substring("profile:".length(), index);
        this.folderPath = partitionsPath.substring(index + 1);
    }

    @Override
    public void start() {
        this.dataStore.trackConfiguration((Runnable)this);
        this.run();
    }

    @Override
    public void stop() {
        this.dataStore.untrackConfiguration((Runnable)this);
    }

    @Override
    public void close() {
        this.stop();
    }

    @Override
    public List<String> listWorkItemLocations() {
        ArrayList items = Lists.newArrayList();
        try {
            String version = this.dataStore.getContainerVersion(this.name);
            Version v = this.fabricService.getVersion(version);
            Profile p = v.getProfile(this.profile);
            for (String f : p.getFileConfigurations().keySet()) {
                if (!f.startsWith(this.folderPath)) continue;
                items.add(f);
            }
        }
        catch (Exception e) {
            LOGGER.debug("Error getting work items from profile repository. Returning empty.", (Throwable)e);
        }
        return items;
    }

    @Override
    public String readContent(String location) {
        try {
            return Resources.toString((URL)new URL("profile:" + location), (Charset)Charsets.UTF_8);
        }
        catch (Exception e) {
            throw FabricException.launderThrowable((Throwable)e);
        }
    }

    @Override
    public void run() {
        String modifed = this.dataStore.getLastModified(this.dataStore.getContainerVersion(this.name), this.profile);
        if (!modifed.equals(this.lastModified)) {
            this.notifyListeners();
            this.lastModified = modifed;
        }
    }
}

