/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.partition.internal;

import com.google.common.collect.LinkedHashMultimap;
import io.fabric8.api.jcip.ThreadSafe;
import io.fabric8.api.scr.AbstractComponent;
import io.fabric8.api.scr.ValidatingReference;
import io.fabric8.partition.BalancingPolicy;
import io.fabric8.partition.TaskContext;
import io.fabric8.partition.WorkerNode;
import io.fabric8.zookeeper.ZkPath;
import java.util.Collection;
import java.util.Iterator;
import org.apache.curator.framework.CuratorFramework;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
@Component(name="io.fabric8.partition.balancing.even", label="Fabric8 Partition Even Balancing Policy", immediate=true, metatype=false)
@Service(value={BalancingPolicy.class})
@Properties(value={@Property(name="type", value={"even"})})
public final class EvenBalancingPolicy
extends AbstractComponent
implements BalancingPolicy {
    private static final Logger LOGGER = LoggerFactory.getLogger(EvenBalancingPolicy.class);
    public static final String TYPE = "even";
    @Reference(referenceInterface=CuratorFramework.class)
    private final ValidatingReference<CuratorFramework> curator = new ValidatingReference();
    private final ObjectMapper mapper = new ObjectMapper();

    public EvenBalancingPolicy() {
        this.mapper.registerSubtypes(new Class[]{WorkerNode.class});
    }

    @Activate
    void activate() {
        this.activateComponent();
    }

    @Deactivate
    void deactivate() {
        this.deactivateComponent();
    }

    @Override
    public String getType() {
        this.assertValid();
        return TYPE;
    }

    @Override
    public synchronized void rebalance(TaskContext context, Collection<String> workItems, Collection<String> members) {
        this.assertValid();
        if (members == null || members.isEmpty()) {
            return;
        }
        LinkedHashMultimap distribution = LinkedHashMultimap.create();
        Iterator<String> iterator = members.iterator();
        for (String item : workItems) {
            if (!iterator.hasNext()) {
                iterator = members.iterator();
            }
            String path = iterator.next();
            distribution.put((Object)path, (Object)item);
        }
        for (String member : members) {
            try {
                WorkerNode node = (WorkerNode)((Object)this.mapper.readValue((byte[])((CuratorFramework)this.curator.get()).getData().forPath(member), WorkerNode.class));
                Collection assignedItems = distribution.get((Object)member);
                if (assignedItems != null) {
                    node.setItems(assignedItems.toArray(new String[assignedItems.size()]));
                } else {
                    node.setItems(new String[0]);
                }
                String targetPath = ZkPath.TASK_MEMBER_PARTITIONS.getPath(new String[]{node.getContainer(), context.getId()});
                ((CuratorFramework)this.curator.get()).setData().forPath(targetPath, this.mapper.writeValueAsBytes((Object)node));
            }
            catch (Exception ex) {
                LOGGER.error("Error while assigning work", (Throwable)ex);
            }
        }
    }

    void bindCurator(CuratorFramework curator) {
        this.curator.bind((Object)curator);
    }

    void unbindCurator(CuratorFramework curator) {
        this.curator.unbind((Object)curator);
    }
}

