/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.impl;

import io.fabric8.api.FabricConstants;
import io.fabric8.api.RuntimeProperties;
import io.fabric8.common.util.Closeables;
import io.fabric8.common.util.Files;
import io.fabric8.maven.impl.MavenProxyServletSupport;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class MavenDownloadProxyServlet
extends MavenProxyServletSupport {
    private final RuntimeProperties runtimeProperties;
    private final ConcurrentMap<String, ArtifactDownloadFuture> requestMap = new ConcurrentHashMap<String, ArtifactDownloadFuture>();
    private final ExecutorService executorService = Executors.newCachedThreadPool();

    public MavenDownloadProxyServlet(RuntimeProperties runtimeProperties, String localRepository, List<String> remoteRepositories, boolean appendSystemRepos, String updatePolicy, String checksumPolicy, String proxyProtocol, String proxyHost, int proxyPort, String proxyUsername, String proxyPassword, String proxyNonProxyHosts) {
        super(localRepository, remoteRepositories, appendSystemRepos, updatePolicy, checksumPolicy, proxyProtocol, proxyHost, proxyPort, proxyUsername, proxyPassword, proxyNonProxyHosts);
        this.runtimeProperties = runtimeProperties;
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doPost(req, resp);
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doPut(req, resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        block16: {
            FileInputStream is = null;
            Object bis = null;
            File artifactFile = null;
            ArtifactDownloadFuture masterFuture = null;
            try {
                String path;
                block15: {
                    path = req.getPathInfo();
                    if (path != null && path.startsWith("/")) {
                        path = path.substring(1);
                    }
                    ArtifactDownloadFuture future = new ArtifactDownloadFuture(path);
                    masterFuture = this.requestMap.putIfAbsent(path, future);
                    if (masterFuture == null) {
                        masterFuture = future;
                        this.executorService.submit(future);
                        artifactFile = masterFuture.get();
                    } else {
                        artifactFile = masterFuture.get();
                    }
                    this.requestMap.remove(path);
                    if (artifactFile != null) break block15;
                    resp.setStatus(404);
                    Closeables.closeQuitely(is);
                    if (masterFuture != null && artifactFile != null) {
                        masterFuture.release(artifactFile);
                    }
                    return;
                }
                try {
                    int length;
                    is = new FileInputStream(artifactFile);
                    LOGGER.log(Level.INFO, String.format("Writing response for file : %s", path));
                    resp.setStatus(200);
                    resp.setContentType("application/octet-stream");
                    resp.setDateHeader("Date", System.currentTimeMillis());
                    resp.setHeader("Connection", "close");
                    resp.setContentLength(((InputStream)is).available());
                    resp.setHeader("Server", "MavenProxy Proxy/" + FabricConstants.FABRIC_VERSION);
                    byte[] buffer = new byte[8192];
                    while ((length = ((InputStream)is).read(buffer)) != -1) {
                        resp.getOutputStream().write(buffer, 0, length);
                    }
                    resp.getOutputStream().flush();
                }
                catch (Exception ex) {
                    try {
                        LOGGER.warning("Error while downloading artifact:" + ex.getMessage());
                    }
                    catch (Throwable throwable) {
                        Closeables.closeQuitely(is);
                        if (masterFuture != null && artifactFile != null) {
                            masterFuture.release(artifactFile);
                        }
                        throw throwable;
                    }
                    Closeables.closeQuitely(is);
                    if (masterFuture != null && artifactFile != null) {
                        masterFuture.release(artifactFile);
                    }
                    break block16;
                }
                Closeables.closeQuitely((Closeable)is);
                if (masterFuture != null && artifactFile != null) {
                    masterFuture.release(artifactFile);
                }
            }
            catch (Exception ex) {
                resp.setStatus(500);
            }
        }
    }

    private class ArtifactDownloadTask
    implements Callable<File> {
        private final String path;

        private ArtifactDownloadTask(String path) {
            this.path = path;
        }

        @Override
        public File call() throws Exception {
            File download = MavenDownloadProxyServlet.this.download(this.path);
            if (download != null) {
                File tmpFile = io.fabric8.utils.Files.createTempFile(MavenDownloadProxyServlet.this.runtimeProperties.getDataPath());
                Files.copy((File)download, (File)tmpFile);
                return tmpFile;
            }
            return null;
        }
    }

    private class ArtifactDownloadFuture
    extends FutureTask<File> {
        private final AtomicInteger paritcipans;

        public ArtifactDownloadFuture(String path) {
            super(new ArtifactDownloadTask(path));
            this.paritcipans = new AtomicInteger();
        }

        @Override
        public File get() throws InterruptedException, ExecutionException {
            this.paritcipans.incrementAndGet();
            return (File)super.get();
        }

        public synchronized void release(File f) {
            if (this.paritcipans.decrementAndGet() == 0) {
                f.delete();
            }
        }
    }
}

