/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.aether.connector.wagon;

import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.connector.wagon.WagonConfigurator;
import org.sonatype.aether.connector.wagon.WagonProvider;
import org.sonatype.aether.connector.wagon.WagonRepositoryConnector;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.spi.connector.RepositoryConnector;
import org.sonatype.aether.spi.connector.RepositoryConnectorFactory;
import org.sonatype.aether.spi.io.FileProcessor;
import org.sonatype.aether.spi.locator.Service;
import org.sonatype.aether.spi.locator.ServiceLocator;
import org.sonatype.aether.spi.log.Logger;
import org.sonatype.aether.spi.log.NullLogger;
import org.sonatype.aether.transfer.NoRepositoryConnectorException;

@Component(role=RepositoryConnectorFactory.class, hint="wagon")
public class WagonRepositoryConnectorFactory
implements RepositoryConnectorFactory,
Service {
    @Requirement
    private Logger logger = NullLogger.INSTANCE;
    @Requirement
    private FileProcessor fileProcessor;
    @Requirement
    private WagonProvider wagonProvider;
    @Requirement
    private WagonConfigurator wagonConfigurator;
    private int priority;

    public WagonRepositoryConnectorFactory() {
    }

    public WagonRepositoryConnectorFactory(Logger logger, FileProcessor fileProcessor, WagonProvider wagonProvider, WagonConfigurator wagonConfigurator) {
        this.setLogger(logger);
        this.setFileProcessor(fileProcessor);
        this.setWagonProvider(wagonProvider);
        this.setWagonConfigurator(wagonConfigurator);
    }

    public void initService(ServiceLocator locator) {
        this.setLogger(locator.getService(Logger.class));
        this.setFileProcessor(locator.getService(FileProcessor.class));
        this.setWagonProvider(locator.getService(WagonProvider.class));
        this.setWagonConfigurator(locator.getService(WagonConfigurator.class));
    }

    public WagonRepositoryConnectorFactory setLogger(Logger logger) {
        this.logger = logger != null ? logger : NullLogger.INSTANCE;
        return this;
    }

    public WagonRepositoryConnectorFactory setFileProcessor(FileProcessor fileProcessor) {
        if (fileProcessor == null) {
            throw new IllegalArgumentException("file processor has not been specified");
        }
        this.fileProcessor = fileProcessor;
        return this;
    }

    public WagonRepositoryConnectorFactory setWagonProvider(WagonProvider wagonProvider) {
        this.wagonProvider = wagonProvider;
        return this;
    }

    public WagonRepositoryConnectorFactory setWagonConfigurator(WagonConfigurator wagonConfigurator) {
        this.wagonConfigurator = wagonConfigurator;
        return this;
    }

    public int getPriority() {
        return this.priority;
    }

    public WagonRepositoryConnectorFactory setPriority(int priority) {
        this.priority = priority;
        return this;
    }

    public RepositoryConnector newInstance(RepositorySystemSession session, RemoteRepository repository) throws NoRepositoryConnectorException {
        return new WagonRepositoryConnector(this.wagonProvider, this.wagonConfigurator, repository, session, this.fileProcessor, this.logger);
    }
}

