/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.util;

import io.fabric8.maven.util.MavenSecDispatcher;
import java.io.File;
import java.lang.reflect.Field;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.maven.settings.Mirror;
import org.apache.maven.settings.Profile;
import org.apache.maven.settings.Repository;
import org.apache.maven.settings.RepositoryPolicy;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.building.DefaultSettingsBuilderFactory;
import org.apache.maven.settings.building.DefaultSettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuilder;
import org.apache.maven.settings.building.SettingsBuildingException;
import org.apache.maven.settings.crypto.DefaultSettingsDecrypter;
import org.apache.maven.settings.crypto.DefaultSettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.apache.maven.settings.crypto.SettingsDecryptionResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.aether.repository.Authentication;
import org.sonatype.aether.repository.AuthenticationSelector;
import org.sonatype.aether.repository.MirrorSelector;
import org.sonatype.aether.repository.Proxy;
import org.sonatype.aether.repository.ProxySelector;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.util.repository.ConservativeAuthenticationSelector;
import org.sonatype.aether.util.repository.DefaultAuthenticationSelector;
import org.sonatype.aether.util.repository.DefaultMirrorSelector;
import org.sonatype.aether.util.repository.DefaultProxySelector;

public class MavenUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(MavenUtils.class);
    private static final SettingsBuilder settingsBuilder = new DefaultSettingsBuilderFactory().newInstance();
    private static final String USER_SETTINGS_FILE = System.getProperty("user.home") + "/.m2/settings.xml";
    private static final String GLOBAL_MAVEN_SETTINGS_FILE = System.getProperty("maven.home") + "/conf/settings.xml";
    private static final String GLOBAL_M2_SETTINGS_FILE = System.getenv("M2_HOME") + "/conf/settings.xml";
    private static final String USER_SETTINGS_SECURITY_FILE = System.getProperty("user.home") + "/.m2/settings-security.xml";

    public static synchronized Settings getSettings() {
        Settings settings = null;
        DefaultSettingsBuildingRequest request = new DefaultSettingsBuildingRequest();
        File userSettingsFile = MavenUtils.safeGetFile(USER_SETTINGS_FILE);
        File globalMavenSettingsFile = MavenUtils.safeGetFile(GLOBAL_MAVEN_SETTINGS_FILE);
        if (globalMavenSettingsFile == null) {
            globalMavenSettingsFile = MavenUtils.safeGetFile(GLOBAL_M2_SETTINGS_FILE);
        }
        if (userSettingsFile != null) {
            request.setUserSettingsFile(userSettingsFile);
        }
        if (globalMavenSettingsFile != null) {
            request.setGlobalSettingsFile(globalMavenSettingsFile);
        }
        request.setSystemProperties(System.getProperties());
        try {
            settings = settingsBuilder.build(request).getEffectiveSettings();
        }
        catch (SettingsBuildingException e) {
            LOGGER.warn("Could not process settings.xml: ", (Throwable)e);
        }
        try {
            SettingsDecrypter settingsDecrypter = MavenUtils.createSettingsDecrypter();
            SettingsDecryptionResult result = settingsDecrypter.decrypt(new DefaultSettingsDecryptionRequest(settings));
            settings.setServers(result.getServers());
            settings.setProxies(result.getProxies());
        }
        catch (Exception ex) {
            LOGGER.warn("Failed to decrypt maven settings.", (Throwable)ex);
        }
        return settings;
    }

    public static List<Repository> getRepositories() {
        LinkedList<Repository> repositories = new LinkedList<Repository>();
        Settings settings = MavenUtils.getSettings();
        LinkedHashSet<String> profileNames = new LinkedHashSet<String>();
        profileNames.addAll(settings.getActiveProfiles());
        for (Profile p : settings.getProfiles()) {
            if (p.getActivation() == null || !p.getActivation().isActiveByDefault()) continue;
            profileNames.add(p.getId());
        }
        for (String profileName : profileNames) {
            Object obj = settings.getProfilesAsMap().get(profileName);
            if (!Profile.class.isAssignableFrom(obj.getClass())) continue;
            Profile p = (Profile)obj;
            for (Repository repository : p.getRepositories()) {
                repositories.add(repository);
            }
        }
        return repositories;
    }

    public static List<RemoteRepository> getRemoteRepositories() {
        LinkedList<RemoteRepository> repositories = new LinkedList<RemoteRepository>();
        for (Repository repository : MavenUtils.getRepositories()) {
            Server server;
            RemoteRepository remote = new RemoteRepository();
            remote.setId(repository.getId());
            remote.setUrl(repository.getUrl());
            remote.setContentType("default");
            if (repository.getSnapshots().isEnabled()) {
                org.sonatype.aether.repository.RepositoryPolicy repositoryPolicy = new org.sonatype.aether.repository.RepositoryPolicy();
                if (repository.getSnapshots() != null) {
                    remote.setPolicy(true, MavenUtils.convertMavenRepositoryPolicy(repository.getSnapshots()));
                }
            }
            if (repository.getReleases() != null) {
                remote.setPolicy(false, MavenUtils.convertMavenRepositoryPolicy(repository.getReleases()));
            }
            if ((server = MavenUtils.getSettings().getServer(repository.getId())) != null) {
                String decodedUsername = MavenUtils.decode(server.getUsername());
                Authentication authentication = new Authentication(decodedUsername, server.getPassword(), server.getPrivateKey(), server.getPassphrase());
                remote.setAuthentication(authentication);
            }
            repositories.add(remote);
        }
        return repositories;
    }

    public static ProxySelector getProxySelector() {
        DefaultProxySelector selector = new DefaultProxySelector();
        Settings settings = MavenUtils.getSettings();
        for (org.apache.maven.settings.Proxy proxy : settings.getProxies()) {
            Authentication auth = new Authentication(proxy.getUsername(), proxy.getPassword());
            Proxy p = new Proxy(proxy.getProtocol(), proxy.getHost(), proxy.getPort(), auth);
            selector.add(p, proxy.getNonProxyHosts());
        }
        return selector;
    }

    public static ProxySelector getProxySelector(String protocol, String host, int port, String nonProxyHosts, String username, String password) {
        DefaultProxySelector selector = new DefaultProxySelector();
        Settings settings = MavenUtils.getSettings();
        if (protocol != null && !protocol.isEmpty() && host != null && !host.isEmpty() && port > 0) {
            Authentication auth = new Authentication(username, password);
            Proxy p = new Proxy(protocol, host, port, auth);
            selector.add(p, nonProxyHosts);
        }
        for (org.apache.maven.settings.Proxy proxy : settings.getProxies()) {
            Authentication auth = new Authentication(proxy.getUsername(), proxy.getPassword());
            Proxy p = new Proxy(proxy.getProtocol(), proxy.getHost(), proxy.getPort(), auth);
            selector.add(p, proxy.getNonProxyHosts());
        }
        return selector;
    }

    public static MirrorSelector getMirrorSelector() {
        DefaultMirrorSelector selector = new DefaultMirrorSelector();
        Settings settings = MavenUtils.getSettings();
        for (Mirror mirror : settings.getMirrors()) {
            selector.add(String.valueOf(mirror.getId()), mirror.getUrl(), mirror.getLayout(), false, mirror.getMirrorOf(), mirror.getMirrorOfLayouts());
        }
        return selector;
    }

    public static AuthenticationSelector getAuthSelector() {
        DefaultAuthenticationSelector selector = new DefaultAuthenticationSelector();
        Settings settings = MavenUtils.getSettings();
        for (Server server : settings.getServers()) {
            String decodedUsername = MavenUtils.decode(server.getUsername());
            Authentication auth = new Authentication(decodedUsername, server.getPassword(), server.getPrivateKey(), server.getPassphrase());
            selector.add(server.getId(), auth);
        }
        return new ConservativeAuthenticationSelector(selector);
    }

    private static String decode(String url) {
        if (url == null) {
            return null;
        }
        StringBuilder decoded = new StringBuilder();
        int pos = 0;
        while (pos < url.length()) {
            char ch = url.charAt(pos);
            if (ch == '%') {
                if (pos + 2 < url.length()) {
                    String hexStr = url.substring(pos + 1, pos + 3);
                    char hexChar = (char)Integer.parseInt(hexStr, 16);
                    decoded.append(hexChar);
                    pos += 3;
                    continue;
                }
                throw new IllegalStateException("'%' escape must be followed by two hex digits");
            }
            decoded.append(ch);
            ++pos;
        }
        return decoded.toString();
    }

    private static SettingsDecrypter createSettingsDecrypter() {
        MavenSecDispatcher secDispatcher = new MavenSecDispatcher();
        DefaultSettingsDecrypter decrypter = new DefaultSettingsDecrypter();
        try {
            Field field = decrypter.getClass().getDeclaredField("securityDispatcher");
            field.setAccessible(true);
            field.set(decrypter, secDispatcher);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        return decrypter;
    }

    private static org.sonatype.aether.repository.RepositoryPolicy convertMavenRepositoryPolicy(RepositoryPolicy repositoryPolicy) {
        org.sonatype.aether.repository.RepositoryPolicy policy = new org.sonatype.aether.repository.RepositoryPolicy();
        if (repositoryPolicy != null && repositoryPolicy.getChecksumPolicy() != null) {
            policy.setChecksumPolicy(repositoryPolicy.getChecksumPolicy());
        }
        policy.setEnabled(repositoryPolicy.isEnabled());
        policy.setUpdatePolicy(repositoryPolicy.getUpdatePolicy());
        return policy;
    }

    private static File safeGetFile(String filePath) {
        File file;
        if (filePath != null && (file = new File(filePath)).exists() && file.canRead() && file.isFile()) {
            return file;
        }
        return null;
    }
}

