/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.modify;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.codec.EncoderException;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.codec.LdapMessageCodec;
import org.apache.directory.shared.ldap.codec.MessageTypeEnum;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.Modification;
import org.apache.directory.shared.ldap.entry.ModificationOperation;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.entry.client.ClientModification;
import org.apache.directory.shared.ldap.entry.client.DefaultClientAttribute;
import org.apache.directory.shared.ldap.name.DN;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModifyRequestCodec
extends LdapMessageCodec {
    private static final Logger LOG = LoggerFactory.getLogger(ModifyRequestCodec.class);
    private DN object;
    private List<Modification> modifications;
    private EntryAttribute currentAttribute;
    private ModificationOperation currentOperation;
    private int modifyRequestLength;
    private int modificationsLength;
    private List<Integer> modificationSequenceLength;
    private List<Integer> modificationLength;
    private List<Integer> valuesLength;

    @Override
    public MessageTypeEnum getMessageType() {
        return MessageTypeEnum.MODIFY_REQUEST;
    }

    @Override
    public String getMessageTypeName() {
        return "MODIFY_REQUEST";
    }

    public void initModifications() {
        this.modifications = new ArrayList<Modification>();
    }

    public List<Modification> getModifications() {
        return this.modifications;
    }

    public void addModification(int operation) {
        this.currentOperation = ModificationOperation.getOperation(operation);
        if (this.currentAttribute == null) {
            this.modifications = new ArrayList<Modification>();
        }
    }

    public void addAttributeTypeAndValues(String type) {
        this.currentAttribute = new DefaultClientAttribute(type);
        ClientModification modification = new ClientModification(this.currentOperation, this.currentAttribute);
        this.modifications.add(modification);
    }

    public void addAttributeValue(String value) {
        this.currentAttribute.add(value);
    }

    public void addAttributeValue(Value<?> value) {
        this.currentAttribute.add(value);
    }

    public void addAttributeValue(byte[] value) {
        this.currentAttribute.add(new byte[][]{value});
    }

    public String getCurrentAttributeType() {
        return this.currentAttribute.getId();
    }

    public DN getObject() {
        return this.object;
    }

    public void setObject(DN object) {
        this.object = object;
    }

    public int getCurrentOperation() {
        return this.currentOperation.getValue();
    }

    public void setCurrentOperation(int currentOperation) {
        this.currentOperation = ModificationOperation.getOperation(currentOperation);
    }

    public void setCurrentOperation(ModificationOperation currentOperation) {
        this.currentOperation = currentOperation;
    }

    public void setModifications(List<Modification> modifications) {
        this.modifications = modifications;
    }

    @Override
    protected int computeLengthProtocolOp() {
        this.modifyRequestLength = 1 + TLV.getNbBytes(DN.getNbBytes(this.object)) + DN.getNbBytes(this.object);
        this.modificationsLength = 0;
        if (this.modifications != null && this.modifications.size() != 0) {
            this.modificationSequenceLength = new LinkedList<Integer>();
            this.modificationLength = new LinkedList<Integer>();
            this.valuesLength = new LinkedList<Integer>();
            for (Modification modification : this.modifications) {
                int localModificationSequenceLength = 3;
                int localValuesLength = 0;
                int typeLength = modification.getAttribute().getId().length();
                int localModificationLength = 1 + TLV.getNbBytes(typeLength) + typeLength;
                if (modification.getAttribute().size() != 0) {
                    for (Value value : modification.getAttribute()) {
                        localValuesLength += 1 + TLV.getNbBytes(value.getBytes().length) + value.getBytes().length;
                    }
                }
                this.modificationsLength += 1 + TLV.getNbBytes(localModificationSequenceLength += 1 + TLV.getNbBytes(localModificationLength += 1 + TLV.getNbBytes(localValuesLength) + localValuesLength) + localModificationLength) + localModificationSequenceLength;
                this.valuesLength.add(localValuesLength);
                this.modificationLength.add(localModificationLength);
                this.modificationSequenceLength.add(localModificationSequenceLength);
            }
            this.modifyRequestLength += 1 + TLV.getNbBytes(this.modificationsLength) + this.modificationsLength;
        }
        return 1 + TLV.getNbBytes(this.modifyRequestLength) + this.modifyRequestLength;
    }

    @Override
    protected void encodeProtocolOp(ByteBuffer buffer) throws EncoderException {
        try {
            buffer.put((byte)102);
            buffer.put(TLV.getBytes(this.modifyRequestLength));
            org.apache.directory.shared.asn1.ber.tlv.Value.encode(buffer, DN.getBytes(this.object));
            buffer.put((byte)48);
            buffer.put(TLV.getBytes(this.modificationsLength));
            if (this.modifications != null && this.modifications.size() != 0) {
                int modificationNumber = 0;
                for (Modification modification : this.modifications) {
                    buffer.put((byte)48);
                    int localModificationSequenceLength = this.modificationSequenceLength.get(modificationNumber);
                    buffer.put(TLV.getBytes(localModificationSequenceLength));
                    buffer.put((byte)10);
                    buffer.put((byte)1);
                    buffer.put((byte)modification.getOperation().getValue());
                    buffer.put((byte)48);
                    int localModificationLength = this.modificationLength.get(modificationNumber);
                    buffer.put(TLV.getBytes(localModificationLength));
                    org.apache.directory.shared.asn1.ber.tlv.Value.encode(buffer, modification.getAttribute().getId());
                    buffer.put((byte)49);
                    int localValuesLength = this.valuesLength.get(modificationNumber);
                    buffer.put(TLV.getBytes(localValuesLength));
                    if (modification.getAttribute().size() != 0) {
                        for (Value value : modification.getAttribute()) {
                            if (!value.isBinary()) {
                                org.apache.directory.shared.asn1.ber.tlv.Value.encode(buffer, value.getString());
                                continue;
                            }
                            org.apache.directory.shared.asn1.ber.tlv.Value.encode(buffer, value.getBytes());
                        }
                    }
                    ++modificationNumber;
                }
            }
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException(I18n.err("ERR_04005", new Object[0]));
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("    Modify Request\n");
        sb.append("        Object : '").append(this.object).append("'\n");
        if (this.modifications != null) {
            int i = 0;
            for (Modification modification : this.modifications) {
                sb.append("            Modification[").append(i).append("]\n");
                sb.append("                Operation : ");
                if (modification != null) {
                    switch (modification.getOperation()) {
                        case ADD_ATTRIBUTE: {
                            sb.append(" add\n");
                            break;
                        }
                        case REPLACE_ATTRIBUTE: {
                            sb.append(" replace\n");
                            break;
                        }
                        case REMOVE_ATTRIBUTE: {
                            sb.append(" delete\n");
                        }
                    }
                    sb.append("                Modification\n");
                    EntryAttribute attribute = modification.getAttribute();
                    if (attribute == null) continue;
                    sb.append(attribute);
                    continue;
                }
                sb.append(" unknown modification operation\n");
            }
        }
        return sb.toString();
    }
}

