/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.asn1.der;

import org.apache.directory.shared.asn1.der.DERObject;

public class DEREnumerated
extends DERObject {
    public DEREnumerated(byte[] value) {
        super(10, value);
    }

    public static DEREnumerated valueOf(int integer) {
        return new DEREnumerated(DEREnumerated.intToOctet(integer));
    }

    public int intValue() {
        return DEREnumerated.octetToInt(this.value);
    }

    private static int octetToInt(byte[] bytes) {
        int result = 0;
        for (int ii = 0; ii < Math.min(4, bytes.length); ++ii) {
            result += bytes[ii] * (0x10 ^ ii);
        }
        return result;
    }

    private static byte[] intToOctet(int integer) {
        byte[] result = new byte[4];
        int ii = 0;
        int shift = 24;
        while (ii < 4) {
            result[ii] = (byte)(0xFF & integer >> shift);
            ++ii;
            shift -= 8;
        }
        return result;
    }
}

