/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree.gui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.TreeNode;
import org.apache.directory.shared.ldap.filter.BranchNode;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASTNode
implements TreeNode {
    private static final Logger log = LoggerFactory.getLogger(ASTNode.class);
    private final ASTNode parent;
    private final ExprNode exprNode;
    private final List<ASTNode> children = new ArrayList<ASTNode>(2);

    public ASTNode(ASTNode parent, ExprNode exprNode) {
        this.exprNode = exprNode;
        this.parent = parent == null ? this : parent;
        try {
            if (exprNode.isLeaf()) {
                return;
            }
            BranchNode branch = (BranchNode)exprNode;
            for (ExprNode child : branch.getChildren()) {
                this.children.add(new ASTNode(this, child));
            }
        }
        catch (Exception e) {
            log.warn("Unexpected exception: parent=" + parent + ", exprNode=" + exprNode, (Throwable)e);
        }
    }

    public Enumeration<ASTNode> children() {
        return Collections.enumeration(this.children);
    }

    @Override
    public boolean getAllowsChildren() {
        return !this.exprNode.isLeaf();
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        return this.children.get(childIndex);
    }

    @Override
    public int getChildCount() {
        return this.children.size();
    }

    @Override
    public int getIndex(TreeNode child) {
        return this.children.indexOf(child);
    }

    @Override
    public TreeNode getParent() {
        return this.parent;
    }

    @Override
    public boolean isLeaf() {
        return this.children.size() <= 0;
    }

    public String toString() {
        return this.exprNode.toString();
    }

    public ExprNode getExprNode() {
        return this.exprNode;
    }
}

