/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.util.ComponentsMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSimpleComponentsMonitor
implements ComponentsMonitor {
    private List<String> components;

    public AbstractSimpleComponentsMonitor(String[] components) {
        this.components = new LinkedList<String>(Arrays.asList(components));
    }

    @Override
    public ComponentsMonitor useComponent(String component) throws IllegalArgumentException {
        if (!this.components.remove(component)) {
            throw new IllegalArgumentException(I18n.err("ERR_04336", component));
        }
        return this;
    }

    @Override
    public boolean allComponentsUsed() {
        return this.components.isEmpty();
    }

    @Override
    public List<String> getRemainingComponents() {
        return Collections.unmodifiableList(this.components);
    }

    @Override
    public abstract boolean finalStateValid();
}

