/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.schema.parsers;

import antlr.RecognitionException;
import antlr.TokenStreamException;
import java.text.ParseException;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.schema.DITStructureRule;
import org.apache.directory.shared.ldap.schema.parsers.AbstractSchemaParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DITStructureRuleDescriptionSchemaParser
extends AbstractSchemaParser {
    protected static final Logger LOG = LoggerFactory.getLogger(DITStructureRuleDescriptionSchemaParser.class);

    public synchronized DITStructureRule parseDITStructureRuleDescription(String ditStructureRuleDescription) throws ParseException {
        LOG.debug("Parsing a DITStructureRule : {}", (Object)ditStructureRuleDescription);
        if (ditStructureRuleDescription == null) {
            LOG.error(I18n.err("ERR_04233", new Object[0]));
            throw new ParseException("Null", 0);
        }
        this.reset(ditStructureRuleDescription);
        try {
            DITStructureRule ditStructureRule = this.parser.ditStructureRuleDescription();
            this.setSchemaName(ditStructureRule);
            return ditStructureRule;
        }
        catch (RecognitionException re) {
            String msg = I18n.err("ERR_04234", ditStructureRuleDescription, re.getMessage(), re.getColumn());
            LOG.error(msg);
            throw new ParseException(msg, re.getColumn());
        }
        catch (TokenStreamException tse) {
            String msg = I18n.err("ERR_04235", ditStructureRuleDescription, tse.getMessage());
            LOG.error(msg);
            throw new ParseException(msg, 0);
        }
    }

    public DITStructureRule parse(String schemaDescription) throws ParseException {
        return this.parseDITStructureRuleDescription(schemaDescription);
    }
}

