/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.messages.value;

import java.util.BitSet;

public abstract class Options {
    private BitSet options;
    private int maxSize;

    protected Options(int maxSize) {
        this.maxSize = maxSize;
        this.options = new BitSet(maxSize);
    }

    public boolean match(Options options, int option) {
        return options.get(option) == this.get(option);
    }

    public boolean get(int index) {
        return this.options.get(index);
    }

    public void set(int index) {
        this.options.set(index);
    }

    public void clear(int index) {
        this.options.clear(index);
    }

    public byte[] getBytes() {
        byte[] bytes = new byte[this.maxSize / 8];
        for (int ii = 0; ii < this.maxSize; ++ii) {
            if (!this.options.get(this.reversePosition(ii))) continue;
            int n = bytes.length - ii / 8 - 1;
            bytes[n] = (byte)(bytes[n] | 1 << ii % 8);
        }
        return bytes;
    }

    protected void setBytes(byte[] bytes) {
        for (int ii = 0; ii < bytes.length * 8; ++ii) {
            if ((bytes[bytes.length - ii / 8 - 1] & 1 << ii % 8) <= 0) continue;
            this.options.set(this.reversePosition(ii));
        }
    }

    private int reversePosition(int position) {
        return this.maxSize - 1 - position;
    }
}

