/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.dsmlv2.request;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.HashMap;
import org.apache.directory.shared.asn1.AbstractAsn1Object;
import org.apache.directory.shared.asn1.codec.DecoderException;
import org.apache.directory.shared.asn1.primitives.OID;
import org.apache.directory.shared.dsmlv2.AbstractGrammar;
import org.apache.directory.shared.dsmlv2.Dsmlv2Container;
import org.apache.directory.shared.dsmlv2.Dsmlv2StatesEnum;
import org.apache.directory.shared.dsmlv2.GrammarAction;
import org.apache.directory.shared.dsmlv2.GrammarTransition;
import org.apache.directory.shared.dsmlv2.IGrammar;
import org.apache.directory.shared.dsmlv2.ParserUtils;
import org.apache.directory.shared.dsmlv2.Tag;
import org.apache.directory.shared.dsmlv2.request.BatchRequest;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.codec.AttributeValueAssertion;
import org.apache.directory.shared.ldap.codec.abandon.AbandonRequestCodec;
import org.apache.directory.shared.ldap.codec.add.AddRequestCodec;
import org.apache.directory.shared.ldap.codec.bind.BindRequestCodec;
import org.apache.directory.shared.ldap.codec.bind.SimpleAuthentication;
import org.apache.directory.shared.ldap.codec.compare.CompareRequestCodec;
import org.apache.directory.shared.ldap.codec.controls.ControlImpl;
import org.apache.directory.shared.ldap.codec.del.DelRequestCodec;
import org.apache.directory.shared.ldap.codec.extended.ExtendedRequestCodec;
import org.apache.directory.shared.ldap.codec.modify.ModifyRequestCodec;
import org.apache.directory.shared.ldap.codec.modifyDn.ModifyDNRequestCodec;
import org.apache.directory.shared.ldap.codec.search.AndFilter;
import org.apache.directory.shared.ldap.codec.search.AttributeValueAssertionFilter;
import org.apache.directory.shared.ldap.codec.search.ExtensibleMatchFilter;
import org.apache.directory.shared.ldap.codec.search.Filter;
import org.apache.directory.shared.ldap.codec.search.NotFilter;
import org.apache.directory.shared.ldap.codec.search.OrFilter;
import org.apache.directory.shared.ldap.codec.search.PresentFilter;
import org.apache.directory.shared.ldap.codec.search.SearchRequestCodec;
import org.apache.directory.shared.ldap.codec.search.SubstringFilter;
import org.apache.directory.shared.ldap.entry.BinaryValue;
import org.apache.directory.shared.ldap.entry.StringValue;
import org.apache.directory.shared.ldap.exception.LdapException;
import org.apache.directory.shared.ldap.exception.LdapInvalidDnException;
import org.apache.directory.shared.ldap.filter.SearchScope;
import org.apache.directory.shared.ldap.message.control.Control;
import org.apache.directory.shared.ldap.name.DN;
import org.apache.directory.shared.ldap.name.RDN;
import org.apache.directory.shared.ldap.util.Base64;
import org.apache.directory.shared.ldap.util.StringTools;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class Dsmlv2Grammar
extends AbstractGrammar
implements IGrammar {
    private static Dsmlv2Grammar instance = new Dsmlv2Grammar();
    private final GrammarAction batchRequestCreation = new GrammarAction("Create Batch Request"){

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void action(Dsmlv2Container container) throws XmlPullParserException {
            BatchRequest batchRequest = new BatchRequest();
            container.setBatchRequest(batchRequest);
            XmlPullParser xpp = container.getParser();
            String attributeValue = xpp.getAttributeValue("", "requestID");
            if (attributeValue != null) {
                batchRequest.setRequestID(ParserUtils.parseAndVerifyRequestID(attributeValue, xpp));
            }
            if ((attributeValue = xpp.getAttributeValue("", "processing")) != null) {
                if ("sequential".equals(attributeValue)) {
                    batchRequest.setProcessing(BatchRequest.Processing.SEQUENTIAL);
                } else {
                    if (!"parallel".equals(attributeValue)) throw new XmlPullParserException(I18n.err("ERR_03013", new Object[0]), xpp, null);
                    batchRequest.setProcessing(BatchRequest.Processing.PARALLEL);
                }
            } else {
                batchRequest.setProcessing(BatchRequest.Processing.SEQUENTIAL);
            }
            attributeValue = xpp.getAttributeValue("", "onError");
            if (attributeValue != null) {
                if ("resume".equals(attributeValue)) {
                    batchRequest.setOnError(BatchRequest.OnError.RESUME);
                } else {
                    if (!"exit".equals(attributeValue)) throw new XmlPullParserException(I18n.err("ERR_03014", new Object[0]), xpp, null);
                    batchRequest.setOnError(BatchRequest.OnError.EXIT);
                }
            } else {
                batchRequest.setOnError(BatchRequest.OnError.EXIT);
            }
            attributeValue = xpp.getAttributeValue("", "responseOrder");
            if (attributeValue != null) {
                if ("sequential".equals(attributeValue)) {
                    batchRequest.setResponseOrder(BatchRequest.ResponseOrder.SEQUENTIAL);
                    return;
                } else {
                    if (!"unordered".equals(attributeValue)) throw new XmlPullParserException(I18n.err("ERR_03015", new Object[0]), xpp, null);
                    batchRequest.setResponseOrder(BatchRequest.ResponseOrder.UNORDERED);
                }
                return;
            } else {
                batchRequest.setResponseOrder(BatchRequest.ResponseOrder.SEQUENTIAL);
            }
        }
    };
    private final GrammarAction abandonRequestCreation = new GrammarAction("Create Abandon Request"){

        public void action(Dsmlv2Container container) throws XmlPullParserException {
            AbandonRequestCodec abandonRequest = new AbandonRequestCodec();
            container.getBatchRequest().addRequest(abandonRequest);
            XmlPullParser xpp = container.getParser();
            String attributeValue = xpp.getAttributeValue("", "requestID");
            if (attributeValue != null) {
                abandonRequest.setMessageId(ParserUtils.parseAndVerifyRequestID(attributeValue, xpp));
            } else if (ParserUtils.isRequestIdNeeded(container)) {
                throw new XmlPullParserException(I18n.err("ERR_03016", new Object[0]), xpp, null);
            }
            attributeValue = xpp.getAttributeValue("", "abandonID");
            if (attributeValue != null) {
                try {
                    abandonRequest.setAbandonedMessageId(Integer.parseInt(attributeValue));
                }
                catch (NumberFormatException e) {
                    throw new XmlPullParserException(I18n.err("ERR_03017", new Object[0]), xpp, null);
                }
            } else {
                throw new XmlPullParserException(I18n.err("ERR_03018", new Object[0]), xpp, null);
            }
        }
    };
    private final GrammarAction addRequestCreation = new GrammarAction("Create Add Request"){

        public void action(Dsmlv2Container container) throws XmlPullParserException {
            AddRequestCodec addRequest = new AddRequestCodec();
            container.getBatchRequest().addRequest(addRequest);
            addRequest.initEntry();
            XmlPullParser xpp = container.getParser();
            String attributeValue = xpp.getAttributeValue("", "requestID");
            if (attributeValue != null) {
                addRequest.setMessageId(ParserUtils.parseAndVerifyRequestID(attributeValue, xpp));
            } else if (ParserUtils.isRequestIdNeeded(container)) {
                throw new XmlPullParserException(I18n.err("ERR_03016", new Object[0]), xpp, null);
            }
            attributeValue = xpp.getAttributeValue("", "dn");
            if (attributeValue != null) {
                try {
                    addRequest.setEntryDn(new DN(attributeValue));
                }
                catch (LdapInvalidDnException e) {
                    throw new XmlPullParserException("" + e.getMessage(), xpp, null);
                }
            } else {
                throw new XmlPullParserException(I18n.err("ERR_03019", new Object[0]), xpp, null);
            }
        }
    };
    private final GrammarAction addRequestAddAttribute = new GrammarAction("Add Attribute to Add Request"){

        public void action(Dsmlv2Container container) throws XmlPullParserException {
            AddRequestCodec addRequest = (AddRequestCodec)container.getBatchRequest().getCurrentRequest();
            XmlPullParser xpp = container.getParser();
            String attributeValue = xpp.getAttributeValue("", "name");
            if (attributeValue != null) {
                try {
                    addRequest.addAttributeType(attributeValue);
                }
                catch (LdapException e) {
                    throw new XmlPullParserException(I18n.err("ERR_03020", new Object[0]), xpp, (Throwable)e);
                }
            } else {
                throw new XmlPullParserException(I18n.err("ERR_03012", new Object[0]), xpp, null);
            }
        }
    };
    private final GrammarAction addRequestAddValue = new GrammarAction("Add Value to Attribute"){

        public void action(Dsmlv2Container container) throws XmlPullParserException {
            AddRequestCodec addRequest = (AddRequestCodec)container.getBatchRequest().getCurrentRequest();
            XmlPullParser xpp = container.getParser();
            try {
                String typeValue = ParserUtils.getXsiTypeAttributeValue(xpp);
                String nextText = xpp.nextText();
                if (!nextText.equals("")) {
                    if (ParserUtils.isBase64BinaryValue(xpp, typeValue)) {
                        addRequest.addAttributeValue(Base64.decode(nextText.trim().toCharArray()));
                    } else {
                        addRequest.addAttributeValue(nextText.trim());
                    }
                }
            }
            catch (IOException e) {
                throw new XmlPullParserException(I18n.err("ERR_03008", e.getMessage()), xpp, null);
            }
        }
    };
    private final GrammarAction authRequestCreation = new GrammarAction("Create Auth Request"){

        public void action(Dsmlv2Container container) throws XmlPullParserException {
            BindRequestCodec authRequest = new BindRequestCodec();
            container.getBatchRequest().addRequest(authRequest);
            SimpleAuthentication simpleAuthentication = new SimpleAuthentication();
            simpleAuthentication.setSimple(StringTools.EMPTY_BYTES);
            authRequest.setAuthentication(simpleAuthentication);
            authRequest.setVersion(3);
            XmlPullParser xpp = container.getParser();
            String attributeValue = xpp.getAttributeValue("", "requestID");
            if (attributeValue != null) {
                authRequest.setMessageId(ParserUtils.parseAndVerifyRequestID(attributeValue, xpp));
            } else if (ParserUtils.isRequestIdNeeded(container)) {
                throw new XmlPullParserException(I18n.err("ERR_03016", new Object[0]), xpp, null);
            }
            attributeValue = xpp.getAttributeValue("", "principal");
            if (attributeValue != null) {
                try {
                    authRequest.setName(new DN(attributeValue));
                }
                catch (LdapInvalidDnException e) {
                    throw new XmlPullParserException("" + e.getMessage(), xpp, null);
                }
            } else {
                throw new XmlPullParserException(I18n.err("ERR_03021", new Object[0]), xpp, null);
            }
        }
    };
    private final GrammarAction compareRequestCreation = new GrammarAction("Create Compare Request"){

        public void action(Dsmlv2Container container) throws XmlPullParserException {
            CompareRequestCodec compareRequest = new CompareRequestCodec();
            container.getBatchRequest().addRequest(compareRequest);
            XmlPullParser xpp = container.getParser();
            String attributeValue = xpp.getAttributeValue("", "requestID");
            if (attributeValue != null) {
                compareRequest.setMessageId(ParserUtils.parseAndVerifyRequestID(attributeValue, xpp));
            } else if (ParserUtils.isRequestIdNeeded(container)) {
                throw new XmlPullParserException(I18n.err("ERR_03016", new Object[0]), xpp, null);
            }
            attributeValue = xpp.getAttributeValue("", "dn");
            if (attributeValue != null) {
                try {
                    compareRequest.setEntry(new DN(attributeValue));
                }
                catch (LdapInvalidDnException e) {
                    throw new XmlPullParserException("" + e.getMessage(), xpp, null);
                }
            } else {
                throw new XmlPullParserException(I18n.err("ERR_03019", new Object[0]), xpp, null);
            }
        }
    };
    private final GrammarAction compareRequestAddAssertion = new GrammarAction("Add Assertion to Compare Request"){

        public void action(Dsmlv2Container container) throws XmlPullParserException {
            CompareRequestCodec compareRequest = (CompareRequestCodec)container.getBatchRequest().getCurrentRequest();
            XmlPullParser xpp = container.getParser();
            String attributeValue = xpp.getAttributeValue("", "name");
            if (attributeValue == null) {
                throw new XmlPullParserException(I18n.err("ERR_03012", new Object[0]), xpp, null);
            }
            compareRequest.setAttributeDesc(attributeValue);
        }
    };
    private final GrammarAction compareRequestAddValue = new GrammarAction("Add Value to Compare Request"){

        public void action(Dsmlv2Container container) throws XmlPullParserException {
            CompareRequestCodec compareRequest = (CompareRequestCodec)container.getBatchRequest().getCurrentRequest();
            XmlPullParser xpp = container.getParser();
            try {
                String typeValue = ParserUtils.getXsiTypeAttributeValue(xpp);
                String nextText = xpp.nextText();
                if (!nextText.equals("")) {
                    if (ParserUtils.isBase64BinaryValue(xpp, typeValue)) {
                        compareRequest.setAssertionValue(Base64.decode(nextText.trim().toCharArray()));
                    } else {
                        compareRequest.setAssertionValue(nextText.trim());
                    }
                }
            }
            catch (IOException e) {
                throw new XmlPullParserException(I18n.err("ERR_03008", e.getMessage()), xpp, null);
            }
        }
    };
    private final GrammarAction delRequestCreation = new GrammarAction("Create Del Request"){

        public void action(Dsmlv2Container container) throws XmlPullParserException {
            DelRequestCodec delRequest = new DelRequestCodec();
            container.getBatchRequest().addRequest(delRequest);
            XmlPullParser xpp = container.getParser();
            String attributeValue = xpp.getAttributeValue("", "requestID");
            if (attributeValue != null) {
                delRequest.setMessageId(ParserUtils.parseAndVerifyRequestID(attributeValue, xpp));
            } else if (ParserUtils.isRequestIdNeeded(container)) {
                throw new XmlPullParserException(I18n.err("ERR_03016", new Object[0]), xpp, null);
            }
            attributeValue = xpp.getAttributeValue("", "dn");
            if (attributeValue != null) {
                try {
                    delRequest.setEntry(new DN(attributeValue));
                }
                catch (LdapInvalidDnException e) {
                    throw new XmlPullParserException("" + e.getMessage(), xpp, null);
                }
            } else {
                throw new XmlPullParserException(I18n.err("ERR_03019", new Object[0]), xpp, null);
            }
        }
    };
    private final GrammarAction extendedRequestCreation = new GrammarAction("Create Extended Request"){

        public void action(Dsmlv2Container container) throws XmlPullParserException {
            ExtendedRequestCodec extendedRequest = new ExtendedRequestCodec();
            container.getBatchRequest().addRequest(extendedRequest);
            XmlPullParser xpp = container.getParser();
            String attributeValue = xpp.getAttributeValue("", "requestID");
            if (attributeValue != null) {
                extendedRequest.setMessageId(ParserUtils.parseAndVerifyRequestID(attributeValue, xpp));
            } else if (ParserUtils.isRequestIdNeeded(container)) {
                throw new XmlPullParserException(I18n.err("ERR_03016", new Object[0]), xpp, null);
            }
        }
    };
    private final GrammarAction extendedRequestAddName = new GrammarAction("Add Name to Extended Request"){

        public void action(Dsmlv2Container container) throws XmlPullParserException {
            ExtendedRequestCodec extendedRequest = (ExtendedRequestCodec)container.getBatchRequest().getCurrentRequest();
            XmlPullParser xpp = container.getParser();
            try {
                String nextText = xpp.nextText();
                if (nextText.equals("")) {
                    throw new XmlPullParserException(I18n.err("ERR_03022", new Object[0]), xpp, null);
                }
                extendedRequest.setRequestName(new OID(nextText.trim()));
            }
            catch (IOException e) {
                throw new XmlPullParserException(I18n.err("ERR_03008", e.getMessage()), xpp, null);
            }
            catch (DecoderException e) {
                throw new XmlPullParserException(e.getMessage(), xpp, null);
            }
        }
    };
    private final GrammarAction extendedRequestAddValue = new GrammarAction("Add Value to Extended Request"){

        public void action(Dsmlv2Container container) throws XmlPullParserException {
            ExtendedRequestCodec extendedRequest = (ExtendedRequestCodec)container.getBatchRequest().getCurrentRequest();
            XmlPullParser xpp = container.getParser();
            try {
                String typeValue = ParserUtils.getXsiTypeAttributeValue(xpp);
                String nextText = xpp.nextText();
                if (!nextText.equals("")) {
                    if (ParserUtils.isBase64BinaryValue(xpp, typeValue)) {
                        extendedRequest.setRequestValue(Base64.decode(nextText.trim().toCharArray()));
                    } else {
                        extendedRequest.setRequestValue(nextText.trim().getBytes());
                    }
                }
            }
            catch (IOException e) {
                throw new XmlPullParserException(I18n.err("ERR_03008", e.getMessage()), xpp, null);
            }
        }
    };
    private final GrammarAction modDNRequestCreation = new GrammarAction("Create Modify DN Request"){

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void action(Dsmlv2Container container) throws XmlPullParserException {
            ModifyDNRequestCodec modifyDNRequest = new ModifyDNRequestCodec();
            container.getBatchRequest().addRequest(modifyDNRequest);
            XmlPullParser xpp = container.getParser();
            String attributeValue = xpp.getAttributeValue("", "requestID");
            if (attributeValue != null) {
                modifyDNRequest.setMessageId(ParserUtils.parseAndVerifyRequestID(attributeValue, xpp));
            } else if (ParserUtils.isRequestIdNeeded(container)) {
                throw new XmlPullParserException(I18n.err("ERR_03016", new Object[0]), xpp, null);
            }
            attributeValue = xpp.getAttributeValue("", "dn");
            if (attributeValue == null) throw new XmlPullParserException(I18n.err("ERR_03019", new Object[0]), xpp, null);
            try {
                modifyDNRequest.setEntry(new DN(attributeValue));
            }
            catch (LdapInvalidDnException e) {
                throw new XmlPullParserException("" + e.getMessage(), xpp, null);
            }
            attributeValue = xpp.getAttributeValue("", "newrdn");
            if (attributeValue == null) throw new XmlPullParserException(I18n.err("ERR_03023", new Object[0]), xpp, null);
            try {
                modifyDNRequest.setNewRDN(new RDN(attributeValue));
            }
            catch (LdapInvalidDnException e) {
                throw new XmlPullParserException("" + e.getMessage(), xpp, null);
            }
            attributeValue = xpp.getAttributeValue("", "deleteoldrdn");
            if (attributeValue != null) {
                if (attributeValue.equals("true") || attributeValue.equals("1")) {
                    modifyDNRequest.setDeleteOldRDN(true);
                } else {
                    if (!attributeValue.equals("false") && !attributeValue.equals("0")) throw new XmlPullParserException(I18n.err("ERR_03024", new Object[0]), xpp, null);
                    modifyDNRequest.setDeleteOldRDN(false);
                }
            } else {
                modifyDNRequest.setDeleteOldRDN(true);
            }
            attributeValue = xpp.getAttributeValue("", "newSuperior");
            if (attributeValue == null) return;
            try {
                modifyDNRequest.setNewSuperior(new DN(attributeValue));
                return;
            }
            catch (LdapInvalidDnException e) {
                throw new XmlPullParserException("" + e.getMessage(), xpp, null);
            }
        }
    };
    private final GrammarAction modifyRequestCreation = new GrammarAction("Create Modify Request"){

        public void action(Dsmlv2Container container) throws XmlPullParserException {
            ModifyRequestCodec modifyRequest = new ModifyRequestCodec();
            container.getBatchRequest().addRequest(modifyRequest);
            modifyRequest.initModifications();
            XmlPullParser xpp = container.getParser();
            String attributeValue = xpp.getAttributeValue("", "requestID");
            if (attributeValue != null) {
                modifyRequest.setMessageId(ParserUtils.parseAndVerifyRequestID(attributeValue, xpp));
            } else if (ParserUtils.isRequestIdNeeded(container)) {
                throw new XmlPullParserException(I18n.err("ERR_03016", new Object[0]), xpp, null);
            }
            attributeValue = xpp.getAttributeValue("", "dn");
            if (attributeValue != null) {
                try {
                    modifyRequest.setObject(new DN(attributeValue));
                }
                catch (LdapInvalidDnException e) {
                    throw new XmlPullParserException("" + e.getLocalizedMessage(), xpp, null);
                }
            } else {
                throw new XmlPullParserException("dn attribute is required", xpp, null);
            }
        }
    };
    private final GrammarAction modifyRequestAddModification = new GrammarAction("Adds Modification to Modify Request"){

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void action(Dsmlv2Container container) throws XmlPullParserException {
            ModifyRequestCodec modifyRequest = (ModifyRequestCodec)container.getBatchRequest().getCurrentRequest();
            XmlPullParser xpp = container.getParser();
            String attributeValue = xpp.getAttributeValue("", "operation");
            if (attributeValue == null) throw new XmlPullParserException(I18n.err("ERR_00025", new Object[0]), xpp, null);
            if ("add".equals(attributeValue)) {
                modifyRequest.setCurrentOperation(0);
            } else if ("delete".equals(attributeValue)) {
                modifyRequest.setCurrentOperation(1);
            } else {
                if (!"replace".equals(attributeValue)) throw new XmlPullParserException("unknown operation. Operation can be 'add', 'delete' or 'replace'.", xpp, null);
                modifyRequest.setCurrentOperation(2);
            }
            attributeValue = xpp.getAttributeValue("", "name");
            if (attributeValue == null) {
                throw new XmlPullParserException(I18n.err("ERR_03012", new Object[0]), xpp, null);
            }
            modifyRequest.addAttributeTypeAndValues(attributeValue);
        }
    };
    private final GrammarAction modifyRequestAddValue = new GrammarAction("Add Value to Modification of Modify Request"){

        public void action(Dsmlv2Container container) throws XmlPullParserException {
            ModifyRequestCodec modifyRequest = (ModifyRequestCodec)container.getBatchRequest().getCurrentRequest();
            XmlPullParser xpp = container.getParser();
            try {
                String typeValue = ParserUtils.getXsiTypeAttributeValue(xpp);
                String nextText = xpp.nextText();
                if (ParserUtils.isBase64BinaryValue(xpp, typeValue)) {
                    modifyRequest.addAttributeValue(Base64.decode(nextText.trim().toCharArray()));
                } else {
                    modifyRequest.addAttributeValue(nextText.trim());
                }
            }
            catch (IOException e) {
                throw new XmlPullParserException(I18n.err("ERR_03008", e.getMessage()), xpp, null);
            }
        }
    };
    private final GrammarAction searchRequestCreation = new GrammarAction("Create Search Request"){

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void action(Dsmlv2Container container) throws XmlPullParserException {
            SearchRequestCodec searchRequest = new SearchRequestCodec();
            container.getBatchRequest().addRequest(searchRequest);
            XmlPullParser xpp = container.getParser();
            String attributeValue = xpp.getAttributeValue("", "requestID");
            if (attributeValue != null) {
                searchRequest.setMessageId(ParserUtils.parseAndVerifyRequestID(attributeValue, xpp));
            } else if (ParserUtils.isRequestIdNeeded(container)) {
                throw new XmlPullParserException(I18n.err("ERR_03016", new Object[0]), xpp, null);
            }
            attributeValue = xpp.getAttributeValue("", "dn");
            if (attributeValue == null) throw new XmlPullParserException(I18n.err("ERR_03019", new Object[0]), xpp, null);
            try {
                searchRequest.setBaseObject(new DN(attributeValue));
            }
            catch (LdapInvalidDnException e) {
                throw new XmlPullParserException("" + e.getMessage(), xpp, null);
            }
            attributeValue = xpp.getAttributeValue("", "scope");
            if (attributeValue == null) throw new XmlPullParserException(I18n.err("ERR_03027", new Object[0]), xpp, null);
            if ("baseObject".equals(attributeValue)) {
                searchRequest.setScope(SearchScope.OBJECT);
            } else if ("singleLevel".equals(attributeValue)) {
                searchRequest.setScope(SearchScope.ONELEVEL);
            } else {
                if (!"wholeSubtree".equals(attributeValue)) throw new XmlPullParserException(I18n.err("ERR_03026", new Object[0]), xpp, null);
                searchRequest.setScope(SearchScope.SUBTREE);
            }
            attributeValue = xpp.getAttributeValue("", "derefAliases");
            if (attributeValue == null) throw new XmlPullParserException(I18n.err("ERR_03029", new Object[0]), xpp, null);
            if ("neverDerefAliases".equals(attributeValue)) {
                searchRequest.setDerefAliases(0);
            } else if ("derefInSearching".equals(attributeValue)) {
                searchRequest.setDerefAliases(1);
            } else if ("derefFindingBaseObj".equals(attributeValue)) {
                searchRequest.setDerefAliases(2);
            } else {
                if (!"derefAlways".equals(attributeValue)) throw new XmlPullParserException(I18n.err("ERR_03028", new Object[0]), xpp, null);
                searchRequest.setDerefAliases(3);
            }
            attributeValue = xpp.getAttributeValue("", "sizeLimit");
            if (attributeValue != null) {
                try {
                    searchRequest.setSizeLimit(Long.parseLong(attributeValue));
                }
                catch (NumberFormatException e) {
                    throw new XmlPullParserException(I18n.err("ERR_03030", new Object[0]), xpp, null);
                }
            } else {
                searchRequest.setSizeLimit(0L);
            }
            attributeValue = xpp.getAttributeValue("", "timeLimit");
            if (attributeValue != null) {
                try {
                    searchRequest.setTimeLimit(Integer.parseInt(attributeValue));
                }
                catch (NumberFormatException e) {
                    throw new XmlPullParserException(I18n.err("ERR_03031", new Object[0]), xpp, null);
                }
            } else {
                searchRequest.setTimeLimit(0);
            }
            attributeValue = xpp.getAttributeValue("", "typesOnly");
            if (attributeValue != null) {
                if (attributeValue.equals("true") || attributeValue.equals("1")) {
                    searchRequest.setTypesOnly(true);
                    return;
                } else {
                    if (!attributeValue.equals("false") && !attributeValue.equals("0")) throw new XmlPullParserException(I18n.err("ERR_03032", new Object[0]), xpp, null);
                    searchRequest.setTypesOnly(false);
                }
                return;
            } else {
                searchRequest.setTypesOnly(false);
            }
        }
    };
    private final GrammarAction searchRequestAddAttribute = new GrammarAction("Add Value to Modification of Modify Request"){

        public void action(Dsmlv2Container container) throws XmlPullParserException {
            SearchRequestCodec searchRequest = (SearchRequestCodec)container.getBatchRequest().getCurrentRequest();
            XmlPullParser xpp = container.getParser();
            String attributeValue = xpp.getAttributeValue("", "name");
            if (attributeValue == null) {
                throw new XmlPullParserException(I18n.err("ERR_03012", new Object[0]), xpp, null);
            }
            searchRequest.addAttribute(attributeValue);
        }
    };
    private final GrammarAction substringsFilterCreation = new GrammarAction("Create Substring Filter"){

        public void action(Dsmlv2Container container) throws XmlPullParserException {
            SearchRequestCodec searchRequest = (SearchRequestCodec)container.getBatchRequest().getCurrentRequest();
            XmlPullParser xpp = container.getParser();
            SubstringFilter filter = new SubstringFilter();
            try {
                searchRequest.addCurrentFilter(filter);
            }
            catch (DecoderException e) {
                throw new XmlPullParserException(e.getMessage(), xpp, null);
            }
            searchRequest.setTerminalFilter(filter);
            String attributeValue = xpp.getAttributeValue("", "name");
            if (attributeValue == null) {
                throw new XmlPullParserException(I18n.err("ERR_03012", new Object[0]), xpp, null);
            }
            filter.setType(attributeValue);
        }
    };
    private final GrammarAction substringsFilterSetInitial = new GrammarAction("Set Initial value to Substring Filter"){

        public void action(Dsmlv2Container container) throws XmlPullParserException {
            SearchRequestCodec searchRequest = (SearchRequestCodec)container.getBatchRequest().getCurrentRequest();
            SubstringFilter substringFilter = (SubstringFilter)searchRequest.getTerminalFilter();
            XmlPullParser xpp = container.getParser();
            try {
                String typeValue = ParserUtils.getXsiTypeAttributeValue(xpp);
                String nextText = xpp.nextText();
                if (!nextText.equals("")) {
                    if (ParserUtils.isBase64BinaryValue(xpp, typeValue)) {
                        substringFilter.setInitialSubstrings(new String(Base64.decode(nextText.trim().toCharArray())));
                    } else {
                        substringFilter.setInitialSubstrings(nextText.trim());
                    }
                }
            }
            catch (IOException e) {
                throw new XmlPullParserException(I18n.err("ERR_03008", e.getMessage()), xpp, null);
            }
        }
    };
    private final GrammarAction substringsFilterAddAny = new GrammarAction("Add Any value to Substring Filter"){

        public void action(Dsmlv2Container container) throws XmlPullParserException {
            SearchRequestCodec searchRequest = (SearchRequestCodec)container.getBatchRequest().getCurrentRequest();
            SubstringFilter substringFilter = (SubstringFilter)searchRequest.getTerminalFilter();
            XmlPullParser xpp = container.getParser();
            try {
                String typeValue = ParserUtils.getXsiTypeAttributeValue(xpp);
                String nextText = xpp.nextText();
                if (!nextText.equals("")) {
                    if (ParserUtils.isBase64BinaryValue(xpp, typeValue)) {
                        substringFilter.addAnySubstrings(new String(Base64.decode(nextText.trim().toCharArray())));
                    } else {
                        substringFilter.addAnySubstrings(nextText.trim());
                    }
                }
            }
            catch (IOException e) {
                throw new XmlPullParserException(I18n.err("ERR_03008", e.getMessage()), xpp, null);
            }
        }
    };
    private final GrammarAction substringsFilterSetFinal = new GrammarAction("Set Final value to Substring Filter"){

        public void action(Dsmlv2Container container) throws XmlPullParserException {
            SearchRequestCodec searchRequest = (SearchRequestCodec)container.getBatchRequest().getCurrentRequest();
            SubstringFilter substringFilter = (SubstringFilter)searchRequest.getTerminalFilter();
            XmlPullParser xpp = container.getParser();
            try {
                String typeValue = ParserUtils.getXsiTypeAttributeValue(xpp);
                String nextText = xpp.nextText();
                if (!nextText.equals("")) {
                    if (ParserUtils.isBase64BinaryValue(xpp, typeValue)) {
                        substringFilter.setFinalSubstrings(new String(Base64.decode(nextText.trim().toCharArray())));
                    } else {
                        substringFilter.setFinalSubstrings(nextText.trim());
                    }
                }
            }
            catch (IOException e) {
                throw new XmlPullParserException(I18n.err("ERR_03008", e.getMessage()), xpp, null);
            }
        }
    };
    private final GrammarAction substringsFilterClose = new GrammarAction("Close Substring Filter"){

        public void action(Dsmlv2Container container) throws XmlPullParserException {
            SearchRequestCodec searchRequest = (SearchRequestCodec)container.getBatchRequest().getCurrentRequest();
            searchRequest.setTerminalFilter(null);
        }
    };
    private final GrammarAction andFilterCreation = new GrammarAction("Create And Filter"){

        public void action(Dsmlv2Container container) throws XmlPullParserException {
            SearchRequestCodec searchRequest = (SearchRequestCodec)container.getBatchRequest().getCurrentRequest();
            XmlPullParser xpp = container.getParser();
            AndFilter filter = new AndFilter();
            try {
                searchRequest.addCurrentFilter(filter);
            }
            catch (DecoderException e) {
                throw new XmlPullParserException(e.getMessage(), xpp, null);
            }
        }
    };
    private final GrammarAction connectorFilterClose = new GrammarAction("Close Connector Filter"){

        public void action(Dsmlv2Container container) throws XmlPullParserException {
            SearchRequestCodec searchRequest = (SearchRequestCodec)container.getBatchRequest().getCurrentRequest();
            AbstractAsn1Object parent = searchRequest.getCurrentFilter().getParent();
            if (parent instanceof Filter) {
                Filter filter = (Filter)parent;
                searchRequest.setCurrentFilter(filter);
            } else {
                searchRequest.setCurrentFilter(null);
            }
        }
    };
    private final GrammarAction orFilterCreation = new GrammarAction("Create Or Filter"){

        public void action(Dsmlv2Container container) throws XmlPullParserException {
            SearchRequestCodec searchRequest = (SearchRequestCodec)container.getBatchRequest().getCurrentRequest();
            XmlPullParser xpp = container.getParser();
            OrFilter filter = new OrFilter();
            try {
                searchRequest.addCurrentFilter(filter);
            }
            catch (DecoderException e) {
                throw new XmlPullParserException(e.getMessage(), xpp, null);
            }
        }
    };
    private final GrammarAction notFilterCreation = new GrammarAction("Create Not Filter"){

        public void action(Dsmlv2Container container) throws XmlPullParserException {
            SearchRequestCodec searchRequest = (SearchRequestCodec)container.getBatchRequest().getCurrentRequest();
            XmlPullParser xpp = container.getParser();
            NotFilter filter = new NotFilter();
            try {
                searchRequest.addCurrentFilter(filter);
            }
            catch (DecoderException e) {
                throw new XmlPullParserException(e.getMessage(), xpp, null);
            }
        }
    };
    private final GrammarAction equalityMatchFilterCreation = new GrammarAction("Create Equality Match Filter"){

        public void action(Dsmlv2Container container) throws XmlPullParserException {
            SearchRequestCodec searchRequest = (SearchRequestCodec)container.getBatchRequest().getCurrentRequest();
            XmlPullParser xpp = container.getParser();
            AttributeValueAssertion assertion = new AttributeValueAssertion();
            String attributeValue = xpp.getAttributeValue("", "name");
            if (attributeValue == null) {
                throw new XmlPullParserException(I18n.err("ERR_03012", new Object[0]), xpp, null);
            }
            assertion.setAttributeDesc(new String(attributeValue.getBytes()));
            AttributeValueAssertionFilter filter = new AttributeValueAssertionFilter(0);
            filter.setAssertion(assertion);
            try {
                searchRequest.addCurrentFilter(filter);
            }
            catch (DecoderException e) {
                throw new XmlPullParserException(e.getMessage(), xpp, null);
            }
            searchRequest.setTerminalFilter(filter);
        }
    };
    private final GrammarAction greaterOrEqualFilterCreation = new GrammarAction("Create Greater Or Equal Filter"){

        public void action(Dsmlv2Container container) throws XmlPullParserException {
            SearchRequestCodec searchRequest = (SearchRequestCodec)container.getBatchRequest().getCurrentRequest();
            XmlPullParser xpp = container.getParser();
            AttributeValueAssertion assertion = new AttributeValueAssertion();
            String attributeValue = xpp.getAttributeValue("", "name");
            if (attributeValue == null) {
                throw new XmlPullParserException(I18n.err("ERR_03012", new Object[0]), xpp, null);
            }
            assertion.setAttributeDesc(new String(attributeValue.getBytes()));
            AttributeValueAssertionFilter filter = new AttributeValueAssertionFilter(1);
            filter.setAssertion(assertion);
            try {
                searchRequest.addCurrentFilter(filter);
            }
            catch (DecoderException e) {
                throw new XmlPullParserException(e.getMessage(), xpp, null);
            }
            searchRequest.setTerminalFilter(filter);
        }
    };
    private final GrammarAction lessOrEqualFilterCreation = new GrammarAction("Create Less Or Equal Filter"){

        public void action(Dsmlv2Container container) throws XmlPullParserException {
            SearchRequestCodec searchRequest = (SearchRequestCodec)container.getBatchRequest().getCurrentRequest();
            XmlPullParser xpp = container.getParser();
            AttributeValueAssertion assertion = new AttributeValueAssertion();
            String attributeValue = xpp.getAttributeValue("", "name");
            if (attributeValue == null) {
                throw new XmlPullParserException(I18n.err("ERR_03012", new Object[0]), xpp, null);
            }
            assertion.setAttributeDesc(new String(attributeValue.getBytes()));
            AttributeValueAssertionFilter filter = new AttributeValueAssertionFilter(2);
            filter.setAssertion(assertion);
            try {
                searchRequest.addCurrentFilter(filter);
            }
            catch (DecoderException e) {
                throw new XmlPullParserException(e.getMessage(), xpp, null);
            }
            searchRequest.setTerminalFilter(filter);
        }
    };
    private final GrammarAction approxMatchFilterCreation = new GrammarAction("Create Approx Match Filter"){

        public void action(Dsmlv2Container container) throws XmlPullParserException {
            SearchRequestCodec searchRequest = (SearchRequestCodec)container.getBatchRequest().getCurrentRequest();
            XmlPullParser xpp = container.getParser();
            AttributeValueAssertion assertion = new AttributeValueAssertion();
            String attributeValue = xpp.getAttributeValue("", "name");
            if (attributeValue == null) {
                throw new XmlPullParserException(I18n.err("ERR_03012", new Object[0]), xpp, null);
            }
            assertion.setAttributeDesc(new String(attributeValue.getBytes()));
            AttributeValueAssertionFilter filter = new AttributeValueAssertionFilter(3);
            filter.setAssertion(assertion);
            try {
                searchRequest.addCurrentFilter(filter);
            }
            catch (DecoderException e) {
                throw new XmlPullParserException(e.getMessage(), xpp, null);
            }
            searchRequest.setTerminalFilter(filter);
        }
    };
    private final GrammarAction filterAddValue = new GrammarAction("Adds Value to Filter"){

        public void action(Dsmlv2Container container) throws XmlPullParserException {
            SearchRequestCodec searchRequest = (SearchRequestCodec)container.getBatchRequest().getCurrentRequest();
            AttributeValueAssertionFilter filter = (AttributeValueAssertionFilter)searchRequest.getTerminalFilter();
            AttributeValueAssertion assertion = filter.getAssertion();
            XmlPullParser xpp = container.getParser();
            try {
                String typeValue = ParserUtils.getXsiTypeAttributeValue(xpp);
                String nextText = xpp.nextText();
                if (!nextText.equals("")) {
                    if (ParserUtils.isBase64BinaryValue(xpp, typeValue)) {
                        BinaryValue value = new BinaryValue(Base64.decode(nextText.trim().toCharArray()));
                        assertion.setAssertionValue(value);
                    } else {
                        StringValue value = new StringValue(nextText.trim());
                        assertion.setAssertionValue(value);
                    }
                }
            }
            catch (IOException e) {
                throw new XmlPullParserException(I18n.err("ERR_03008", e.getMessage()), xpp, null);
            }
        }
    };
    private final GrammarAction presentFilterCreation = new GrammarAction("Create Present Filter"){

        public void action(Dsmlv2Container container) throws XmlPullParserException {
            PresentFilter presentFilter = new PresentFilter();
            XmlPullParser xpp = container.getParser();
            SearchRequestCodec searchRequest = (SearchRequestCodec)container.getBatchRequest().getCurrentRequest();
            try {
                searchRequest.addCurrentFilter(presentFilter);
            }
            catch (DecoderException e) {
                throw new XmlPullParserException(e.getMessage(), xpp, null);
            }
            String attributeValue = xpp.getAttributeValue("", "name");
            if (attributeValue == null) {
                throw new XmlPullParserException("name attribute is required", xpp, null);
            }
            presentFilter.setAttributeDescription(new String(attributeValue.getBytes()));
        }
    };
    private final GrammarAction extensibleMatchFilterCreation = new GrammarAction("Create Extensible Match Filter"){

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void action(Dsmlv2Container container) throws XmlPullParserException {
            ExtensibleMatchFilter extensibleMatchFilter = new ExtensibleMatchFilter();
            XmlPullParser xpp = container.getParser();
            SearchRequestCodec searchRequest = (SearchRequestCodec)container.getBatchRequest().getCurrentRequest();
            try {
                searchRequest.addCurrentFilter(extensibleMatchFilter);
            }
            catch (DecoderException e) {
                throw new XmlPullParserException(I18n.err("ERR_03012", new Object[0]), xpp, null);
            }
            searchRequest.setTerminalFilter(extensibleMatchFilter);
            String attributeValue = xpp.getAttributeValue("", "dnAttributes");
            if (attributeValue != null) {
                if (attributeValue.equals("true") || attributeValue.equals("1")) {
                    extensibleMatchFilter.setDnAttributes(true);
                } else {
                    if (!attributeValue.equals("false") && !attributeValue.equals("0")) throw new XmlPullParserException(I18n.err("ERR_03033", new Object[0]), xpp, null);
                    extensibleMatchFilter.setDnAttributes(false);
                }
            } else {
                extensibleMatchFilter.setDnAttributes(false);
            }
            attributeValue = xpp.getAttributeValue("", "matchingRule");
            if (attributeValue != null) {
                extensibleMatchFilter.setMatchingRule(attributeValue);
            }
            if ((attributeValue = xpp.getAttributeValue("", "name")) == null) return;
            extensibleMatchFilter.setType(attributeValue);
        }
    };
    private final GrammarAction extensibleMatchAddValue = new GrammarAction("Adds Value to Extensible MatchFilter"){

        public void action(Dsmlv2Container container) throws XmlPullParserException {
            SearchRequestCodec searchRequest = (SearchRequestCodec)container.getBatchRequest().getCurrentRequest();
            ExtensibleMatchFilter filter = (ExtensibleMatchFilter)searchRequest.getTerminalFilter();
            XmlPullParser xpp = container.getParser();
            try {
                String typeValue = ParserUtils.getXsiTypeAttributeValue(xpp);
                String nextText = xpp.nextText();
                if (!nextText.equals("")) {
                    if (ParserUtils.isBase64BinaryValue(xpp, typeValue)) {
                        filter.setMatchValue(new BinaryValue(Base64.decode(nextText.trim().toCharArray())));
                    } else {
                        filter.setMatchValue(new StringValue(nextText.trim()));
                    }
                }
            }
            catch (IOException e) {
                throw new XmlPullParserException(I18n.err("ERR_03008", e.getMessage()), xpp, null);
            }
        }
    };
    private final GrammarAction controlCreation = new GrammarAction("Create Control"){

        public void action(Dsmlv2Container container) throws XmlPullParserException {
            ControlImpl control = null;
            XmlPullParser xpp = container.getParser();
            String attributeValue = xpp.getAttributeValue("", "type");
            if (attributeValue != null) {
                if (!OID.isOID(attributeValue)) {
                    throw new XmlPullParserException(I18n.err("ERR_03034", new Object[0]), xpp, null);
                }
            } else {
                throw new XmlPullParserException(I18n.err("ERR_03035", new Object[0]), xpp, null);
            }
            control = new ControlImpl(attributeValue);
            container.getBatchRequest().getCurrentRequest().addControl(control);
            attributeValue = xpp.getAttributeValue("", "criticality");
            if (attributeValue != null) {
                if (attributeValue.equals("true")) {
                    control.setCritical(true);
                } else if (attributeValue.equals("false")) {
                    control.setCritical(false);
                } else {
                    throw new XmlPullParserException(I18n.err("ERR_03007", new Object[0]), xpp, null);
                }
            }
        }
    };
    private final GrammarAction controlValueCreation = new GrammarAction("Add ControlValue to Control"){

        public void action(Dsmlv2Container container) throws XmlPullParserException {
            Control control = container.getBatchRequest().getCurrentRequest().getCurrentControl();
            XmlPullParser xpp = container.getParser();
            try {
                String typeValue = ParserUtils.getXsiTypeAttributeValue(xpp);
                String nextText = xpp.nextText();
                if (!nextText.equals("")) {
                    if (ParserUtils.isBase64BinaryValue(xpp, typeValue)) {
                        control.setValue(Base64.decode(nextText.trim().toCharArray()));
                    } else {
                        control.setValue(nextText.trim().getBytes());
                    }
                }
            }
            catch (IOException e) {
                throw new XmlPullParserException(I18n.err("ERR_03008", e.getMessage()), xpp, null);
            }
        }
    };

    private Dsmlv2Grammar() {
        this.name = Dsmlv2Grammar.class.getName();
        this.statesEnum = Dsmlv2StatesEnum.getInstance();
        this.transitions = (HashMap[])Array.newInstance(HashMap.class, 200);
        this.transitions[0] = new HashMap();
        this.transitions[104] = new HashMap();
        this.transitions[105] = new HashMap();
        this.transitions[1] = new HashMap();
        this.transitions[0].put(new Tag("batchRequest", Tag.START), new GrammarTransition(0, 104, this.batchRequestCreation));
        this.transitions[104].put(new Tag("batchRequest", Tag.END), new GrammarTransition(104, 1, null));
        this.transitions[105].put(new Tag("batchRequest", Tag.END), new GrammarTransition(105, -1, null));
        this.transitions[104].put(new Tag("abandonRequest", Tag.START), new GrammarTransition(104, 2, this.abandonRequestCreation));
        this.transitions[105].put(new Tag("abandonRequest", Tag.START), new GrammarTransition(105, 2, this.abandonRequestCreation));
        this.transitions[104].put(new Tag("addRequest", Tag.START), new GrammarTransition(104, 8, this.addRequestCreation));
        this.transitions[105].put(new Tag("addRequest", Tag.START), new GrammarTransition(105, 8, this.addRequestCreation));
        this.transitions[104].put(new Tag("authRequest", Tag.START), new GrammarTransition(104, 18, this.authRequestCreation));
        this.transitions[104].put(new Tag("compareRequest", Tag.START), new GrammarTransition(104, 24, this.compareRequestCreation));
        this.transitions[105].put(new Tag("compareRequest", Tag.START), new GrammarTransition(105, 24, this.compareRequestCreation));
        this.transitions[104].put(new Tag("delRequest", Tag.START), new GrammarTransition(104, 34, this.delRequestCreation));
        this.transitions[105].put(new Tag("delRequest", Tag.START), new GrammarTransition(105, 34, this.delRequestCreation));
        this.transitions[104].put(new Tag("extendedRequest", Tag.START), new GrammarTransition(104, 40, this.extendedRequestCreation));
        this.transitions[105].put(new Tag("extendedRequest", Tag.START), new GrammarTransition(105, 40, this.extendedRequestCreation));
        this.transitions[104].put(new Tag("modDNRequest", Tag.START), new GrammarTransition(104, 50, this.modDNRequestCreation));
        this.transitions[105].put(new Tag("modDNRequest", Tag.START), new GrammarTransition(105, 50, this.modDNRequestCreation));
        this.transitions[104].put(new Tag("modifyRequest", Tag.START), new GrammarTransition(104, 56, this.modifyRequestCreation));
        this.transitions[105].put(new Tag("modifyRequest", Tag.START), new GrammarTransition(105, 56, this.modifyRequestCreation));
        this.transitions[104].put(new Tag("searchRequest", Tag.START), new GrammarTransition(104, 66, this.searchRequestCreation));
        this.transitions[105].put(new Tag("searchRequest", Tag.START), new GrammarTransition(105, 66, this.searchRequestCreation));
        this.transitions[2] = new HashMap();
        this.transitions[4] = new HashMap();
        this.transitions[5] = new HashMap();
        this.transitions[7] = new HashMap();
        this.transitions[2].put(new Tag("abandonRequest", Tag.END), new GrammarTransition(2, 105, null));
        this.transitions[2].put(new Tag("control", Tag.START), new GrammarTransition(2, 4, this.controlCreation));
        this.transitions[4].put(new Tag("controlValue", Tag.START), new GrammarTransition(4, 7, this.controlValueCreation));
        this.transitions[7].put(new Tag("control", Tag.END), new GrammarTransition(7, 5, null));
        this.transitions[4].put(new Tag("control", Tag.END), new GrammarTransition(4, 5, null));
        this.transitions[5].put(new Tag("control", Tag.START), new GrammarTransition(5, 4, this.controlCreation));
        this.transitions[5].put(new Tag("abandonRequest", Tag.END), new GrammarTransition(5, 105, null));
        this.transitions[8] = new HashMap();
        this.transitions[10] = new HashMap();
        this.transitions[11] = new HashMap();
        this.transitions[13] = new HashMap();
        this.transitions[14] = new HashMap();
        this.transitions[15] = new HashMap();
        this.transitions[8].put(new Tag("addRequest", Tag.END), new GrammarTransition(8, 105, null));
        this.transitions[8].put(new Tag("control", Tag.START), new GrammarTransition(8, 10, this.controlCreation));
        this.transitions[10].put(new Tag("controlValue", Tag.START), new GrammarTransition(10, 13, this.controlValueCreation));
        this.transitions[13].put(new Tag("control", Tag.END), new GrammarTransition(13, 11, null));
        this.transitions[10].put(new Tag("control", Tag.END), new GrammarTransition(10, 11, null));
        this.transitions[11].put(new Tag("control", Tag.START), new GrammarTransition(11, 10, this.controlCreation));
        this.transitions[11].put(new Tag("addRequest", Tag.END), new GrammarTransition(11, 105, null));
        this.transitions[8].put(new Tag("attr", Tag.START), new GrammarTransition(8, 14, this.addRequestAddAttribute));
        this.transitions[11].put(new Tag("attr", Tag.START), new GrammarTransition(11, 14, this.addRequestAddAttribute));
        this.transitions[15].put(new Tag("attr", Tag.START), new GrammarTransition(15, 14, this.addRequestAddAttribute));
        this.transitions[14].put(new Tag("attr", Tag.END), new GrammarTransition(14, 15, null));
        this.transitions[14].put(new Tag("value", Tag.START), new GrammarTransition(14, 14, this.addRequestAddValue));
        this.transitions[15].put(new Tag("addRequest", Tag.END), new GrammarTransition(15, 105, null));
        this.transitions[18] = new HashMap();
        this.transitions[20] = new HashMap();
        this.transitions[21] = new HashMap();
        this.transitions[23] = new HashMap();
        this.transitions[18].put(new Tag("authRequest", Tag.END), new GrammarTransition(18, 105, null));
        this.transitions[18].put(new Tag("control", Tag.START), new GrammarTransition(18, 20, this.controlCreation));
        this.transitions[20].put(new Tag("controlValue", Tag.START), new GrammarTransition(20, 23, this.controlValueCreation));
        this.transitions[23].put(new Tag("control", Tag.END), new GrammarTransition(23, 21, null));
        this.transitions[20].put(new Tag("control", Tag.END), new GrammarTransition(20, 21, null));
        this.transitions[21].put(new Tag("control", Tag.START), new GrammarTransition(21, 20, this.controlCreation));
        this.transitions[21].put(new Tag("authRequest", Tag.END), new GrammarTransition(21, 105, null));
        this.transitions[24] = new HashMap();
        this.transitions[26] = new HashMap();
        this.transitions[27] = new HashMap();
        this.transitions[29] = new HashMap();
        this.transitions[30] = new HashMap();
        this.transitions[31] = new HashMap();
        this.transitions[33] = new HashMap();
        this.transitions[24].put(new Tag("control", Tag.START), new GrammarTransition(24, 26, this.controlCreation));
        this.transitions[26].put(new Tag("controlValue", Tag.START), new GrammarTransition(26, 29, this.controlValueCreation));
        this.transitions[29].put(new Tag("control", Tag.END), new GrammarTransition(29, 27, null));
        this.transitions[26].put(new Tag("control", Tag.END), new GrammarTransition(26, 27, null));
        this.transitions[27].put(new Tag("control", Tag.START), new GrammarTransition(27, 26, this.controlCreation));
        this.transitions[27].put(new Tag("compareRequest", Tag.END), new GrammarTransition(27, 105, null));
        this.transitions[24].put(new Tag("assertion", Tag.START), new GrammarTransition(26, 30, this.compareRequestAddAssertion));
        this.transitions[27].put(new Tag("assertion", Tag.START), new GrammarTransition(27, 30, this.compareRequestAddAssertion));
        this.transitions[30].put(new Tag("value", Tag.START), new GrammarTransition(30, 33, this.compareRequestAddValue));
        this.transitions[33].put(new Tag("assertion", Tag.END), new GrammarTransition(33, 31, null));
        this.transitions[31].put(new Tag("compareRequest", Tag.END), new GrammarTransition(31, 105, null));
        this.transitions[34] = new HashMap();
        this.transitions[36] = new HashMap();
        this.transitions[37] = new HashMap();
        this.transitions[39] = new HashMap();
        this.transitions[34].put(new Tag("delRequest", Tag.END), new GrammarTransition(34, 105, null));
        this.transitions[34].put(new Tag("control", Tag.START), new GrammarTransition(34, 36, this.controlCreation));
        this.transitions[36].put(new Tag("controlValue", Tag.START), new GrammarTransition(36, 39, this.controlValueCreation));
        this.transitions[39].put(new Tag("control", Tag.END), new GrammarTransition(39, 37, null));
        this.transitions[36].put(new Tag("control", Tag.END), new GrammarTransition(36, 37, null));
        this.transitions[37].put(new Tag("control", Tag.START), new GrammarTransition(37, 36, this.controlCreation));
        this.transitions[37].put(new Tag("delRequest", Tag.END), new GrammarTransition(37, 105, null));
        this.transitions[40] = new HashMap();
        this.transitions[42] = new HashMap();
        this.transitions[43] = new HashMap();
        this.transitions[45] = new HashMap();
        this.transitions[47] = new HashMap();
        this.transitions[49] = new HashMap();
        this.transitions[40].put(new Tag("control", Tag.START), new GrammarTransition(40, 42, this.controlCreation));
        this.transitions[42].put(new Tag("controlValue", Tag.START), new GrammarTransition(42, 45, this.controlValueCreation));
        this.transitions[45].put(new Tag("control", Tag.END), new GrammarTransition(45, 43, null));
        this.transitions[42].put(new Tag("control", Tag.END), new GrammarTransition(42, 43, null));
        this.transitions[43].put(new Tag("control", Tag.START), new GrammarTransition(43, 42, this.controlCreation));
        this.transitions[43].put(new Tag("extendedRequest", Tag.END), new GrammarTransition(43, 105, null));
        this.transitions[40].put(new Tag("requestName", Tag.START), new GrammarTransition(40, 47, this.extendedRequestAddName));
        this.transitions[43].put(new Tag("requestName", Tag.START), new GrammarTransition(43, 47, this.extendedRequestAddName));
        this.transitions[47].put(new Tag("extendedRequest", Tag.END), new GrammarTransition(47, 105, null));
        this.transitions[47].put(new Tag("requestValue", Tag.START), new GrammarTransition(47, 49, this.extendedRequestAddValue));
        this.transitions[49].put(new Tag("extendedRequest", Tag.END), new GrammarTransition(49, 105, null));
        this.transitions[50] = new HashMap();
        this.transitions[52] = new HashMap();
        this.transitions[53] = new HashMap();
        this.transitions[55] = new HashMap();
        this.transitions[50].put(new Tag("modDNRequest", Tag.END), new GrammarTransition(50, 105, null));
        this.transitions[50].put(new Tag("control", Tag.START), new GrammarTransition(50, 52, this.controlCreation));
        this.transitions[52].put(new Tag("controlValue", Tag.START), new GrammarTransition(52, 55, this.controlValueCreation));
        this.transitions[55].put(new Tag("control", Tag.END), new GrammarTransition(55, 53, null));
        this.transitions[52].put(new Tag("control", Tag.END), new GrammarTransition(52, 53, null));
        this.transitions[53].put(new Tag("control", Tag.START), new GrammarTransition(53, 52, this.controlCreation));
        this.transitions[53].put(new Tag("modDNRequest", Tag.END), new GrammarTransition(53, 105, null));
        this.transitions[56] = new HashMap();
        this.transitions[58] = new HashMap();
        this.transitions[59] = new HashMap();
        this.transitions[61] = new HashMap();
        this.transitions[62] = new HashMap();
        this.transitions[63] = new HashMap();
        this.transitions[65] = new HashMap();
        this.transitions[56].put(new Tag("modifyRequest", Tag.END), new GrammarTransition(56, 105, null));
        this.transitions[56].put(new Tag("control", Tag.START), new GrammarTransition(56, 58, this.controlCreation));
        this.transitions[58].put(new Tag("controlValue", Tag.START), new GrammarTransition(58, 61, this.controlValueCreation));
        this.transitions[61].put(new Tag("control", Tag.END), new GrammarTransition(61, 59, null));
        this.transitions[58].put(new Tag("control", Tag.END), new GrammarTransition(58, 59, null));
        this.transitions[59].put(new Tag("control", Tag.START), new GrammarTransition(59, 58, this.controlCreation));
        this.transitions[59].put(new Tag("modifyRequest", Tag.END), new GrammarTransition(59, 105, null));
        this.transitions[59].put(new Tag("modification", Tag.START), new GrammarTransition(59, 62, this.modifyRequestAddModification));
        this.transitions[56].put(new Tag("modification", Tag.START), new GrammarTransition(56, 62, this.modifyRequestAddModification));
        this.transitions[63].put(new Tag("modification", Tag.START), new GrammarTransition(63, 62, this.modifyRequestAddModification));
        this.transitions[62].put(new Tag("modification", Tag.END), new GrammarTransition(62, 63, null));
        this.transitions[62].put(new Tag("value", Tag.START), new GrammarTransition(62, 65, this.modifyRequestAddValue));
        this.transitions[65].put(new Tag("value", Tag.START), new GrammarTransition(65, 65, this.modifyRequestAddValue));
        this.transitions[65].put(new Tag("modification", Tag.END), new GrammarTransition(65, 63, null));
        this.transitions[63].put(new Tag("modifyRequest", Tag.END), new GrammarTransition(63, 105, null));
        this.transitions[66] = new HashMap();
        this.transitions[68] = new HashMap();
        this.transitions[69] = new HashMap();
        this.transitions[71] = new HashMap();
        this.transitions[74] = new HashMap();
        this.transitions[75] = new HashMap();
        this.transitions[76] = new HashMap();
        this.transitions[77] = new HashMap();
        this.transitions[66].put(new Tag("control", Tag.START), new GrammarTransition(66, 68, this.controlCreation));
        this.transitions[68].put(new Tag("controlValue", Tag.START), new GrammarTransition(68, 71, this.controlValueCreation));
        this.transitions[71].put(new Tag("control", Tag.END), new GrammarTransition(71, 69, null));
        this.transitions[68].put(new Tag("control", Tag.END), new GrammarTransition(68, 69, null));
        this.transitions[69].put(new Tag("control", Tag.START), new GrammarTransition(69, 68, this.controlCreation));
        this.transitions[74].put(new Tag("attributes", Tag.END), new GrammarTransition(74, 75, null));
        this.transitions[74].put(new Tag("attribute", Tag.START), new GrammarTransition(74, 76, this.searchRequestAddAttribute));
        this.transitions[76].put(new Tag("attribute", Tag.END), new GrammarTransition(76, 77, null));
        this.transitions[77].put(new Tag("attribute", Tag.START), new GrammarTransition(77, 76, this.searchRequestAddAttribute));
        this.transitions[77].put(new Tag("attributes", Tag.END), new GrammarTransition(77, 75, null));
        this.transitions[75].put(new Tag("searchRequest", Tag.END), new GrammarTransition(75, 105, null));
        this.transitions[72] = new HashMap();
        this.transitions[73] = new HashMap();
        this.transitions[106] = new HashMap();
        this.transitions[84] = new HashMap();
        this.transitions[88] = new HashMap();
        this.transitions[90] = new HashMap();
        this.transitions[94] = new HashMap();
        this.transitions[92] = new HashMap();
        this.transitions[96] = new HashMap();
        this.transitions[110] = new HashMap();
        this.transitions[108] = new HashMap();
        this.transitions[66].put(new Tag("filter", Tag.START), new GrammarTransition(66, 72, null));
        this.transitions[69].put(new Tag("filter", Tag.START), new GrammarTransition(69, 72, null));
        this.transitions[72].put(new Tag("and", Tag.START), new GrammarTransition(72, 106, this.andFilterCreation));
        this.transitions[106].put(new Tag("and", Tag.START), new GrammarTransition(106, 106, this.andFilterCreation));
        this.transitions[106].put(new Tag("and", Tag.END), new GrammarTransition(106, 106, this.connectorFilterClose));
        this.transitions[72].put(new Tag("or", Tag.START), new GrammarTransition(72, 106, this.orFilterCreation));
        this.transitions[106].put(new Tag("or", Tag.START), new GrammarTransition(106, 106, this.orFilterCreation));
        this.transitions[106].put(new Tag("or", Tag.END), new GrammarTransition(106, 106, this.connectorFilterClose));
        this.transitions[72].put(new Tag("not", Tag.START), new GrammarTransition(72, 106, this.notFilterCreation));
        this.transitions[106].put(new Tag("not", Tag.START), new GrammarTransition(106, 106, this.notFilterCreation));
        this.transitions[106].put(new Tag("not", Tag.END), new GrammarTransition(106, 106, this.connectorFilterClose));
        this.transitions[72].put(new Tag("substrings", Tag.START), new GrammarTransition(72, 86, this.substringsFilterCreation));
        this.transitions[106].put(new Tag("substrings", Tag.START), new GrammarTransition(106, 86, this.substringsFilterCreation));
        this.transitions[72].put(new Tag("equalityMatch", Tag.START), new GrammarTransition(72, 84, this.equalityMatchFilterCreation));
        this.transitions[106].put(new Tag("equalityMatch", Tag.START), new GrammarTransition(106, 84, this.equalityMatchFilterCreation));
        this.transitions[84].put(new Tag("value", Tag.START), new GrammarTransition(84, 108, this.filterAddValue));
        this.transitions[108].put(new Tag("equalityMatch", Tag.END), new GrammarTransition(108, 106, null));
        this.transitions[72].put(new Tag("greaterOrEqual", Tag.START), new GrammarTransition(72, 88, this.greaterOrEqualFilterCreation));
        this.transitions[106].put(new Tag("greaterOrEqual", Tag.START), new GrammarTransition(106, 88, this.greaterOrEqualFilterCreation));
        this.transitions[88].put(new Tag("value", Tag.START), new GrammarTransition(88, 108, this.filterAddValue));
        this.transitions[108].put(new Tag("greaterOrEqual", Tag.END), new GrammarTransition(108, 106, null));
        this.transitions[72].put(new Tag("lessOrEqual", Tag.START), new GrammarTransition(72, 90, this.lessOrEqualFilterCreation));
        this.transitions[106].put(new Tag("lessOrEqual", Tag.START), new GrammarTransition(106, 90, this.lessOrEqualFilterCreation));
        this.transitions[90].put(new Tag("value", Tag.START), new GrammarTransition(90, 108, this.filterAddValue));
        this.transitions[108].put(new Tag("lessOrEqual", Tag.END), new GrammarTransition(108, 106, null));
        this.transitions[72].put(new Tag("approxMatch", Tag.START), new GrammarTransition(72, 94, this.approxMatchFilterCreation));
        this.transitions[106].put(new Tag("approxMatch", Tag.START), new GrammarTransition(106, 94, this.approxMatchFilterCreation));
        this.transitions[94].put(new Tag("value", Tag.START), new GrammarTransition(94, 108, this.filterAddValue));
        this.transitions[108].put(new Tag("approxMatch", Tag.END), new GrammarTransition(108, 106, null));
        this.transitions[72].put(new Tag("present", Tag.START), new GrammarTransition(72, 92, this.presentFilterCreation));
        this.transitions[106].put(new Tag("present", Tag.START), new GrammarTransition(106, 92, this.presentFilterCreation));
        this.transitions[92].put(new Tag("present", Tag.END), new GrammarTransition(92, 106, null));
        this.transitions[72].put(new Tag("extensibleMatch", Tag.START), new GrammarTransition(72, 96, this.extensibleMatchFilterCreation));
        this.transitions[106].put(new Tag("extensibleMatch", Tag.START), new GrammarTransition(106, 96, this.extensibleMatchFilterCreation));
        this.transitions[96].put(new Tag("value", Tag.START), new GrammarTransition(96, 110, this.extensibleMatchAddValue));
        this.transitions[110].put(new Tag("extensibleMatch", Tag.END), new GrammarTransition(110, 106, null));
        this.transitions[106].put(new Tag("filter", Tag.END), new GrammarTransition(106, 73, null));
        this.transitions[73].put(new Tag("attributes", Tag.START), new GrammarTransition(73, 74, null));
        this.transitions[73].put(new Tag("searchRequest", Tag.END), new GrammarTransition(73, 105, null));
        this.transitions[86] = new HashMap();
        this.transitions[99] = new HashMap();
        this.transitions[101] = new HashMap();
        this.transitions[103] = new HashMap();
        this.transitions[87] = new HashMap();
        this.transitions[86].put(new Tag("substrings", Tag.END), new GrammarTransition(86, 106, null));
        this.transitions[86].put(new Tag("initial", Tag.START), new GrammarTransition(86, 99, this.substringsFilterSetInitial));
        this.transitions[99].put(new Tag("any", Tag.START), new GrammarTransition(99, 101, this.substringsFilterAddAny));
        this.transitions[99].put(new Tag("final", Tag.START), new GrammarTransition(99, 103, this.substringsFilterSetFinal));
        this.transitions[99].put(new Tag("substrings", Tag.END), new GrammarTransition(99, 106, this.substringsFilterClose));
        this.transitions[86].put(new Tag("any", Tag.START), new GrammarTransition(86, 101, this.substringsFilterAddAny));
        this.transitions[101].put(new Tag("any", Tag.START), new GrammarTransition(101, 101, this.substringsFilterAddAny));
        this.transitions[101].put(new Tag("final", Tag.START), new GrammarTransition(101, 103, this.substringsFilterSetFinal));
        this.transitions[101].put(new Tag("substrings", Tag.END), new GrammarTransition(101, 106, this.substringsFilterClose));
        this.transitions[86].put(new Tag("final", Tag.START), new GrammarTransition(86, 103, this.substringsFilterSetFinal));
        this.transitions[103].put(new Tag("substrings", Tag.END), new GrammarTransition(103, 106, this.substringsFilterClose));
    }

    public static Dsmlv2Grammar getInstance() {
        return instance;
    }
}

