/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.subtree;

import org.apache.directory.server.core.subtree.RefinementLeafEvaluator;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.exception.LdapException;
import org.apache.directory.shared.ldap.filter.AndNode;
import org.apache.directory.shared.ldap.filter.BranchNode;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.filter.NotNode;
import org.apache.directory.shared.ldap.filter.OrNode;
import org.apache.directory.shared.ldap.filter.SimpleNode;

public class RefinementEvaluator {
    private RefinementLeafEvaluator leafEvaluator;

    public RefinementEvaluator(RefinementLeafEvaluator leafEvaluator) {
        this.leafEvaluator = leafEvaluator;
    }

    public boolean evaluate(ExprNode node, EntryAttribute objectClasses) throws LdapException {
        if (node == null) {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_295, new Object[0]));
        }
        if (objectClasses == null) {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_296, new Object[0]));
        }
        if (!objectClasses.instanceOf("objectClass")) {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_297, new Object[0]));
        }
        if (node.isLeaf()) {
            return this.leafEvaluator.evaluate((SimpleNode)node, objectClasses);
        }
        BranchNode bnode = (BranchNode)node;
        if (node instanceof OrNode) {
            for (ExprNode child : bnode.getChildren()) {
                if (!this.evaluate(child, objectClasses)) continue;
                return true;
            }
            return false;
        }
        if (node instanceof AndNode) {
            for (ExprNode child : bnode.getChildren()) {
                if (this.evaluate(child, objectClasses)) continue;
                return false;
            }
            return true;
        }
        if (node instanceof NotNode) {
            if (null != bnode.getFirstChild()) {
                return !this.evaluate(bnode.getFirstChild(), objectClasses);
            }
            throw new IllegalArgumentException(I18n.err(I18n.ERR_243, node));
        }
        throw new IllegalArgumentException(I18n.err(I18n.ERR_244, bnode));
    }
}

