/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.io.decoder;

import java.io.IOException;
import java.util.Enumeration;
import org.apache.directory.server.kerberos.shared.io.decoder.EncryptedDataDecoder;
import org.apache.directory.server.kerberos.shared.messages.application.ApplicationReply;
import org.apache.directory.shared.asn1.der.ASN1InputStream;
import org.apache.directory.shared.asn1.der.DERApplicationSpecific;
import org.apache.directory.shared.asn1.der.DEREncodable;
import org.apache.directory.shared.asn1.der.DERSequence;
import org.apache.directory.shared.asn1.der.DERTaggedObject;

public class ApplicationReplyDecoder {
    public ApplicationReply decode(byte[] encodedAuthHeader) throws IOException {
        ASN1InputStream ais = new ASN1InputStream(encodedAuthHeader);
        DERApplicationSpecific app = (DERApplicationSpecific)ais.readObject();
        DERSequence apreq = (DERSequence)app.getObject();
        return this.decodeApplicationRequestSequence(apreq);
    }

    private ApplicationReply decodeApplicationRequestSequence(DERSequence sequence) {
        ApplicationReply authHeader = null;
        Enumeration<DEREncodable> e = sequence.getObjects();
        while (e.hasMoreElements()) {
            DERTaggedObject object = (DERTaggedObject)e.nextElement();
            int tag = object.getTagNo();
            DEREncodable derObject = object.getObject();
            switch (tag) {
                case 0: {
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    DERSequence tag2 = (DERSequence)derObject;
                    authHeader = new ApplicationReply(EncryptedDataDecoder.decode(tag2));
                }
            }
        }
        return authHeader;
    }
}

