/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.crypto.checksum;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ChecksumType implements Comparable<ChecksumType>
{
    UNKNOWN(-1),
    NULL(0),
    CRC32(1),
    RSA_MD4(2),
    RSA_MD4_DES(3),
    DES_MAC(4),
    DES_MAC_K(5),
    RSA_MD4_DES_K(6),
    RSA_MD5(7),
    RSA_MD5_DES(8),
    RSA_MD5_DES3(9),
    SHA1(10),
    HMAC_SHA1_DES3_KD(12),
    HMAC_SHA1_DES3(13),
    SHA1_2(14),
    HMAC_SHA1_96_AES128(15),
    HMAC_SHA1_96_AES256(16),
    HMAC_MD5(-138);

    private final int ordinal;

    private ChecksumType(int ordinal) {
        this.ordinal = ordinal;
    }

    public static ChecksumType getTypeByOrdinal(int type) {
        switch (type) {
            case -1: {
                return UNKNOWN;
            }
            case 0: {
                return NULL;
            }
            case 1: {
                return CRC32;
            }
            case 2: {
                return RSA_MD4;
            }
            case 3: {
                return RSA_MD4_DES;
            }
            case 4: {
                return DES_MAC;
            }
            case 5: {
                return DES_MAC_K;
            }
            case 6: {
                return RSA_MD4_DES_K;
            }
            case 7: {
                return RSA_MD5;
            }
            case 8: {
                return RSA_MD5_DES;
            }
            case 9: {
                return RSA_MD5_DES3;
            }
            case 10: {
                return SHA1;
            }
            case 12: {
                return HMAC_SHA1_DES3_KD;
            }
            case 13: {
                return HMAC_SHA1_DES3;
            }
            case 14: {
                return SHA1_2;
            }
            case 15: {
                return HMAC_SHA1_96_AES128;
            }
            case 16: {
                return HMAC_SHA1_96_AES256;
            }
            case -138: {
                return HMAC_MD5;
            }
        }
        return UNKNOWN;
    }

    public int getOrdinal() {
        return this.ordinal;
    }
}

