/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.integ;

import java.io.File;
import org.apache.commons.io.FileUtils;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.annotations.CreatePartition;
import org.apache.directory.server.core.factory.DSAnnotationProcessor;
import org.apache.directory.server.core.factory.DefaultDirectoryServiceFactory;
import org.apache.directory.server.core.factory.PartitionFactory;
import org.apache.directory.server.core.integ.FrameworkRunner;
import org.apache.directory.server.factory.ServerAnnotationProcessor;
import org.apache.directory.server.ldap.LdapServer;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.Suite;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.RunnerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrameworkSuite
extends Suite {
    private static final Logger LOG = LoggerFactory.getLogger(FrameworkSuite.class);
    private DirectoryService directoryService;
    private CreateLdapServer ldapServerBuilder;
    private LdapServer ldapServer;

    public FrameworkSuite(Class<?> clazz, RunnerBuilder builder) throws InitializationError {
        super(clazz, builder);
    }

    private void startDS(Description description) throws Exception {
        this.directoryService = DSAnnotationProcessor.getDirectoryService(description);
        if (this.directoryService != null) {
            DSAnnotationProcessor.applyLdifs(description, this.directoryService);
        }
    }

    private void stopDS() {
        if (this.directoryService != null) {
            try {
                LOG.debug("Shuting down DS for {}", (Object)this.directoryService.getInstanceId());
                this.directoryService.shutdown();
                FileUtils.deleteDirectory((File)this.directoryService.getWorkingDirectory());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void addPartitions(Description description) {
        CreatePartition createPartition = (CreatePartition)description.getAnnotation(CreatePartition.class);
        if (createPartition != null) {
            // empty if block
        }
    }

    private void startLdapServer(Description description) throws Exception {
        this.ldapServer = ServerAnnotationProcessor.getLdapServer(description, this.directoryService, 1024);
    }

    private void stopLdapServer() {
        if (this.ldapServer != null && this.ldapServer.isStarted()) {
            this.ldapServer.stop();
        }
    }

    public void run(RunNotifier notifier) {
        try {
            PartitionFactory partitionFactory = DefaultDirectoryServiceFactory.DEFAULT.getPartitionFactory();
            System.out.println("Using partition factory " + partitionFactory.getClass().getSimpleName());
            this.startDS(this.getDescription());
            this.addPartitions(this.getDescription());
            this.startLdapServer(this.getDescription());
            super.run(notifier);
            this.stopLdapServer();
            this.stopDS();
        }
        catch (Exception e) {
            notifier.fireTestFailure(new Failure(this.getDescription(), (Throwable)e));
        }
    }

    protected void runChild(Runner runner, RunNotifier notifier) {
        if (runner instanceof FrameworkRunner) {
            ((FrameworkRunner)runner).setSuite(this);
            super.runChild(runner, notifier);
        } else {
            super.runChild(runner, notifier);
        }
    }

    public DirectoryService getDirectoryService() {
        return this.directoryService;
    }

    public void setDirectoryService(DirectoryService directoryService) {
        this.directoryService = directoryService;
    }

    public CreateLdapServer getLdapServerBuilder() {
        return this.ldapServerBuilder;
    }

    public LdapServer getLdapServer() {
        return this.ldapServer;
    }
}

