/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.controls.replication.syncStateValue;

import java.nio.ByteBuffer;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.asn1.codec.EncoderException;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.codec.controls.AbstractControl;
import org.apache.directory.shared.ldap.codec.controls.replication.syncStateValue.SyncStateValueControlDecoder;
import org.apache.directory.shared.ldap.message.control.replication.SyncStateTypeEnum;
import org.apache.directory.shared.ldap.util.StringTools;

public class SyncStateValueControl
extends AbstractControl {
    public static final String CONTROL_OID = "1.3.6.1.4.1.4203.1.9.1.2";
    private SyncStateTypeEnum syncStateType;
    private byte[] cookie;
    private byte[] entryUUID;
    private int syncStateSeqLength;

    public SyncStateValueControl() {
        super(CONTROL_OID);
        this.decoder = new SyncStateValueControlDecoder();
    }

    public byte[] getCookie() {
        return this.cookie;
    }

    public void setCookie(byte[] cookie) {
        this.cookie = cookie;
    }

    public SyncStateTypeEnum getSyncStateType() {
        return this.syncStateType;
    }

    public void setSyncStateType(SyncStateTypeEnum syncStateType) {
        this.syncStateType = syncStateType;
    }

    public byte[] getEntryUUID() {
        return this.entryUUID;
    }

    public void setEntryUUID(byte[] entryUUID) {
        this.entryUUID = entryUUID;
    }

    public int computeLength() {
        this.syncStateSeqLength = 3;
        this.syncStateSeqLength += 1 + TLV.getNbBytes(this.entryUUID.length) + this.entryUUID.length;
        if (this.cookie != null) {
            this.syncStateSeqLength += 1 + TLV.getNbBytes(this.cookie.length) + this.cookie.length;
        }
        this.valueLength = 1 + TLV.getNbBytes(this.syncStateSeqLength) + this.syncStateSeqLength;
        return super.computeLength(this.valueLength);
    }

    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException(I18n.err("ERR_04023", new Object[0]));
        }
        super.encode(buffer);
        buffer.put((byte)4);
        buffer.put(TLV.getBytes(this.valueLength));
        buffer.put((byte)48);
        buffer.put(TLV.getBytes(this.syncStateSeqLength));
        buffer.put((byte)10);
        buffer.put((byte)1);
        buffer.put(Value.getBytes(this.syncStateType.getValue()));
        Value.encode(buffer, this.entryUUID);
        if (this.cookie != null) {
            Value.encode(buffer, this.cookie);
        }
        return buffer;
    }

    public byte[] getValue() {
        if (this.value == null) {
            try {
                this.computeLength();
                ByteBuffer buffer = ByteBuffer.allocate(this.valueLength);
                buffer.put((byte)48);
                buffer.put(TLV.getBytes(this.syncStateSeqLength));
                buffer.put((byte)10);
                buffer.put((byte)1);
                buffer.put(Value.getBytes(this.syncStateType.getValue()));
                Value.encode(buffer, this.entryUUID);
                if (this.cookie != null) {
                    Value.encode(buffer, this.cookie);
                }
                this.value = buffer.array();
            }
            catch (Exception e) {
                return null;
            }
        }
        return this.value;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("    SyncStateValue control :\n");
        sb.append("        oid : ").append(this.getOid()).append('\n');
        sb.append("        critical : ").append(this.isCritical()).append('\n');
        sb.append("        syncStateType     : '").append((Object)this.syncStateType).append("'\n");
        sb.append("        entryUUID         : '").append(StringTools.dumpBytes(this.entryUUID)).append("'\n");
        sb.append("        cookie            : '").append(StringTools.dumpBytes(this.cookie)).append("'\n");
        return sb.toString();
    }
}

