/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm.search.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.Store;
import org.apache.directory.server.xdbm.search.Evaluator;
import org.apache.directory.server.xdbm.search.impl.AndEvaluator;
import org.apache.directory.server.xdbm.search.impl.ApproximateEvaluator;
import org.apache.directory.server.xdbm.search.impl.EqualityEvaluator;
import org.apache.directory.server.xdbm.search.impl.GreaterEqEvaluator;
import org.apache.directory.server.xdbm.search.impl.LessEqEvaluator;
import org.apache.directory.server.xdbm.search.impl.NotEvaluator;
import org.apache.directory.server.xdbm.search.impl.OneLevelScopeEvaluator;
import org.apache.directory.server.xdbm.search.impl.OrEvaluator;
import org.apache.directory.server.xdbm.search.impl.PresenceEvaluator;
import org.apache.directory.server.xdbm.search.impl.SubstringEvaluator;
import org.apache.directory.server.xdbm.search.impl.SubtreeScopeEvaluator;
import org.apache.directory.shared.ldap.NotImplementedException;
import org.apache.directory.shared.ldap.entry.ServerEntry;
import org.apache.directory.shared.ldap.filter.AndNode;
import org.apache.directory.shared.ldap.filter.ApproximateNode;
import org.apache.directory.shared.ldap.filter.EqualityNode;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.filter.GreaterEqNode;
import org.apache.directory.shared.ldap.filter.LessEqNode;
import org.apache.directory.shared.ldap.filter.NotNode;
import org.apache.directory.shared.ldap.filter.OrNode;
import org.apache.directory.shared.ldap.filter.PresenceNode;
import org.apache.directory.shared.ldap.filter.ScopeNode;
import org.apache.directory.shared.ldap.filter.SearchScope;
import org.apache.directory.shared.ldap.filter.SubstringNode;
import org.apache.directory.shared.ldap.schema.SchemaManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EvaluatorBuilder<ID> {
    private final Store<ServerEntry, ID> db;
    private final SchemaManager schemaManager;

    public EvaluatorBuilder(Store<ServerEntry, ID> db, SchemaManager schemaManager) throws Exception {
        this.db = db;
        this.schemaManager = schemaManager;
    }

    public <T> Evaluator<? extends ExprNode, ServerEntry, ID> build(ExprNode node) throws Exception {
        switch (node.getAssertionType()) {
            case APPROXIMATE: {
                return new ApproximateEvaluator((ApproximateNode)node, this.db, this.schemaManager);
            }
            case EQUALITY: {
                return new EqualityEvaluator((EqualityNode)node, this.db, this.schemaManager);
            }
            case GREATEREQ: {
                return new GreaterEqEvaluator((GreaterEqNode)node, this.db, this.schemaManager);
            }
            case LESSEQ: {
                return new LessEqEvaluator((LessEqNode)node, this.db, this.schemaManager);
            }
            case PRESENCE: {
                return new PresenceEvaluator<ID>((PresenceNode)node, this.db, this.schemaManager);
            }
            case SCOPE: {
                if (((ScopeNode)node).getScope() == SearchScope.ONELEVEL) {
                    return new OneLevelScopeEvaluator<ServerEntry, ID>(this.db, (ScopeNode)node);
                }
                return new SubtreeScopeEvaluator<ServerEntry, ID>(this.db, (ScopeNode)node);
            }
            case SUBSTRING: {
                return new SubstringEvaluator<ID>((SubstringNode)node, this.db, this.schemaManager);
            }
            case AND: {
                return this.buildAndEvaluator((AndNode)node);
            }
            case NOT: {
                return new NotEvaluator<ID>((NotNode)node, this.build(((NotNode)node).getFirstChild()));
            }
            case OR: {
                return this.buildOrEvaluator((OrNode)node);
            }
            case ASSERTION: 
            case EXTENSIBLE: {
                throw new NotImplementedException();
            }
        }
        throw new IllegalStateException(I18n.err(I18n.ERR_260, new Object[]{node.getAssertionType()}));
    }

    AndEvaluator<ID> buildAndEvaluator(AndNode node) throws Exception {
        List<ExprNode> children = node.getChildren();
        ArrayList evaluators = new ArrayList(children.size());
        for (ExprNode child : children) {
            evaluators.add(this.build(child));
        }
        return new AndEvaluator(node, evaluators);
    }

    OrEvaluator<ID> buildOrEvaluator(OrNode node) throws Exception {
        List<ExprNode> children = node.getChildren();
        ArrayList evaluators = new ArrayList(children.size());
        for (ExprNode child : children) {
            evaluators.add(this.build(child));
        }
        return new OrEvaluator(node, evaluators);
    }
}

