/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.name;

import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.entry.BinaryValue;
import org.apache.directory.shared.ldap.exception.LdapException;
import org.apache.directory.shared.ldap.exception.LdapInvalidDnException;
import org.apache.directory.shared.ldap.name.NameComponentNormalizer;
import org.apache.directory.shared.ldap.schema.Normalizer;

public class SimpleNameComponentNormalizer
implements NameComponentNormalizer {
    private final Normalizer normalizer;

    public SimpleNameComponentNormalizer(Normalizer normalizer) {
        this.normalizer = normalizer;
    }

    public Object normalizeByName(String name, String val) throws LdapException {
        return this.normalizer.normalize(val);
    }

    public Object normalizeByName(String name, byte[] val) throws LdapException {
        return this.normalizer.normalize(new BinaryValue(val));
    }

    public Object normalizeByOid(String oid, String val) throws LdapException {
        return this.normalizer.normalize(val);
    }

    public Object normalizeByOid(String oid, byte[] val) throws LdapException {
        return this.normalizer.normalize(new BinaryValue(val));
    }

    public boolean isDefined(String oid) {
        return true;
    }

    public String normalizeName(String attributeName) throws LdapInvalidDnException {
        throw new UnsupportedOperationException(I18n.err("ERR_04216", new Object[0]));
    }
}

