/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.dhcp.service;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.apache.directory.server.dhcp.DhcpException;
import org.apache.directory.server.dhcp.messages.DhcpMessage;
import org.apache.directory.server.dhcp.messages.MessageType;
import org.apache.directory.server.dhcp.options.AddressOption;
import org.apache.directory.server.dhcp.options.OptionsField;
import org.apache.directory.server.dhcp.options.dhcp.ClientIdentifier;
import org.apache.directory.server.dhcp.options.dhcp.IpAddressLeaseTime;
import org.apache.directory.server.dhcp.options.dhcp.MaximumDhcpMessageSize;
import org.apache.directory.server.dhcp.options.dhcp.ParameterRequestList;
import org.apache.directory.server.dhcp.options.dhcp.RequestedIpAddress;
import org.apache.directory.server.dhcp.options.dhcp.ServerIdentifier;
import org.apache.directory.server.dhcp.service.AbstractDhcpService;
import org.apache.directory.server.dhcp.service.Lease;
import org.apache.directory.server.dhcp.store.DhcpStore;

public class StoreBasedDhcpService
extends AbstractDhcpService {
    private final DhcpStore dhcpStore;

    public StoreBasedDhcpService(DhcpStore dhcpStore) {
        this.dhcpStore = dhcpStore;
    }

    private Lease getExistingLease(InetSocketAddress clientAddress, DhcpMessage request) throws DhcpException {
        IpAddressLeaseTime requestedLeaseTimeOption = (IpAddressLeaseTime)request.getOptions().get(IpAddressLeaseTime.class);
        long requestedLeaseTime = null != requestedLeaseTimeOption ? requestedLeaseTimeOption.getIntValue() * 1000L : -1L;
        InetAddress requestedAddress = null;
        AddressOption requestedAddressOption = (AddressOption)request.getOptions().get(RequestedIpAddress.class);
        if (null != requestedAddressOption) {
            requestedAddress = requestedAddressOption.getAddress();
        }
        if (null == requestedAddress) {
            requestedAddress = request.getCurrentClientAddress();
        }
        InetAddress selectionBase = this.determineSelectionBase(clientAddress, request);
        Lease lease = this.dhcpStore.getExistingLease(request.getHardwareAddress(), requestedAddress, selectionBase, requestedLeaseTime, request.getOptions());
        if (null == lease) {
            return null;
        }
        return lease;
    }

    private Lease getLeaseOffer(InetSocketAddress clientAddress, DhcpMessage request) throws DhcpException {
        IpAddressLeaseTime requestedLeaseTimeOption = (IpAddressLeaseTime)request.getOptions().get(IpAddressLeaseTime.class);
        long requestedLeaseTime = null != requestedLeaseTimeOption ? requestedLeaseTimeOption.getIntValue() * 1000L : -1L;
        InetAddress requestedAddress = null;
        AddressOption requestedAddressOption = (AddressOption)request.getOptions().get(RequestedIpAddress.class);
        if (null != requestedAddressOption) {
            requestedAddress = requestedAddressOption.getAddress();
        }
        InetAddress selectionBase = this.determineSelectionBase(clientAddress, request);
        Lease lease = this.dhcpStore.getLeaseOffer(request.getHardwareAddress(), requestedAddress, selectionBase, requestedLeaseTime, request.getOptions());
        return lease;
    }

    protected DhcpMessage handleRELEASE(InetSocketAddress localAddress, InetSocketAddress clientAddress, DhcpMessage request) throws DhcpException {
        AddressOption serverIdentOption = (AddressOption)request.getOptions().get(ServerIdentifier.class);
        if (null != serverIdentOption && serverIdentOption.getAddress().isAnyLocalAddress()) {
            return null;
        }
        Lease lease = this.getExistingLease(clientAddress, request);
        DhcpMessage reply = this.initGeneralReply(localAddress, request);
        if (null == lease) {
            reply.setMessageType(MessageType.DHCPNAK);
            reply.setCurrentClientAddress(null);
            reply.setAssignedClientAddress(null);
            reply.setNextServerAddress(null);
        } else {
            this.dhcpStore.releaseLease(lease);
            reply.getOptions().merge(lease.getOptions());
            reply.setAssignedClientAddress(lease.getClientAddress());
            reply.setNextServerAddress(lease.getNextServerAddress());
            OptionsField options = reply.getOptions();
            options.remove(RequestedIpAddress.class);
            options.remove(ParameterRequestList.class);
            options.remove(ClientIdentifier.class);
            options.remove(MaximumDhcpMessageSize.class);
            options.add(new IpAddressLeaseTime((lease.getExpires() - System.currentTimeMillis()) / 1000L));
            this.stripUnwantedOptions(request, options);
        }
        return reply;
    }

    protected DhcpMessage handleDISCOVER(InetSocketAddress localAddress, InetSocketAddress clientAddress, DhcpMessage request) throws DhcpException {
        Lease lease = this.getLeaseOffer(clientAddress, request);
        if (null == lease) {
            return null;
        }
        DhcpMessage reply = this.initGeneralReply(localAddress, request);
        reply.getOptions().merge(lease.getOptions());
        reply.setMessageType(MessageType.DHCPOFFER);
        reply.setAssignedClientAddress(lease.getClientAddress());
        reply.setNextServerAddress(lease.getNextServerAddress());
        OptionsField options = reply.getOptions();
        options.remove(RequestedIpAddress.class);
        options.remove(ParameterRequestList.class);
        options.remove(ClientIdentifier.class);
        options.remove(MaximumDhcpMessageSize.class);
        options.add(new IpAddressLeaseTime((lease.getExpires() - System.currentTimeMillis()) / 1000L));
        this.stripUnwantedOptions(request, options);
        return reply;
    }

    protected DhcpMessage handleREQUEST(InetSocketAddress localAddress, InetSocketAddress clientAddress, DhcpMessage request) throws DhcpException {
        AddressOption serverIdentOption = (AddressOption)request.getOptions().get(ServerIdentifier.class);
        if (null != serverIdentOption && serverIdentOption.getAddress().isAnyLocalAddress()) {
            return null;
        }
        Lease lease = this.getExistingLease(clientAddress, request);
        DhcpMessage reply = this.initGeneralReply(localAddress, request);
        if (null == lease) {
            reply.setMessageType(MessageType.DHCPNAK);
            reply.setCurrentClientAddress(null);
            reply.setAssignedClientAddress(null);
            reply.setNextServerAddress(null);
        } else {
            reply.getOptions().merge(lease.getOptions());
            reply.setAssignedClientAddress(lease.getClientAddress());
            reply.setNextServerAddress(lease.getNextServerAddress());
            OptionsField options = reply.getOptions();
            options.remove(RequestedIpAddress.class);
            options.remove(ParameterRequestList.class);
            options.remove(ClientIdentifier.class);
            options.remove(MaximumDhcpMessageSize.class);
            options.add(new IpAddressLeaseTime((lease.getExpires() - System.currentTimeMillis()) / 1000L));
            this.stripUnwantedOptions(request, options);
        }
        return reply;
    }
}

