/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.subtree;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.directory.SearchControls;
import org.apache.directory.server.core.DefaultCoreSession;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.LdapPrincipal;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.filtering.EntryFilter;
import org.apache.directory.server.core.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.interceptor.BaseInterceptor;
import org.apache.directory.server.core.interceptor.NextInterceptor;
import org.apache.directory.server.core.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.interceptor.context.ListOperationContext;
import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.interceptor.context.OperationContext;
import org.apache.directory.server.core.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.interceptor.context.SearchingOperationContext;
import org.apache.directory.server.core.partition.ByPassConstants;
import org.apache.directory.server.core.partition.PartitionNexus;
import org.apache.directory.server.core.subtree.Subentry;
import org.apache.directory.server.core.subtree.SubentryCache;
import org.apache.directory.server.core.subtree.SubtreeEvaluator;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.codec.search.controls.subentries.SubentriesControl;
import org.apache.directory.shared.ldap.constants.AuthenticationLevel;
import org.apache.directory.shared.ldap.entry.DefaultServerAttribute;
import org.apache.directory.shared.ldap.entry.DefaultServerEntry;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.Modification;
import org.apache.directory.shared.ldap.entry.ModificationOperation;
import org.apache.directory.shared.ldap.entry.ServerEntry;
import org.apache.directory.shared.ldap.entry.ServerModification;
import org.apache.directory.shared.ldap.entry.StringValue;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.exception.LdapInvalidAttributeValueException;
import org.apache.directory.shared.ldap.exception.LdapNoSuchAttributeException;
import org.apache.directory.shared.ldap.exception.LdapSchemaViolationException;
import org.apache.directory.shared.ldap.filter.EqualityNode;
import org.apache.directory.shared.ldap.filter.PresenceNode;
import org.apache.directory.shared.ldap.filter.SearchScope;
import org.apache.directory.shared.ldap.message.AliasDerefMode;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.name.DN;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.NormalizerMappingResolver;
import org.apache.directory.shared.ldap.schema.SchemaManager;
import org.apache.directory.shared.ldap.schema.normalizers.OidNormalizer;
import org.apache.directory.shared.ldap.schema.registries.OidRegistry;
import org.apache.directory.shared.ldap.subtree.SubtreeSpecification;
import org.apache.directory.shared.ldap.subtree.SubtreeSpecificationParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubentryInterceptor
extends BaseInterceptor {
    private static final String SUBENTRY_CONTROL = "1.3.6.1.4.1.4203.1.10.1";
    public static final String AC_AREA = "accessControlSpecificArea";
    public static final String AC_INNERAREA = "accessControlInnerArea";
    public static final String SCHEMA_AREA = "subschemaAdminSpecificArea";
    public static final String COLLECTIVE_AREA = "collectiveAttributeSpecificArea";
    public static final String COLLECTIVE_INNERAREA = "collectiveAttributeInnerArea";
    public static final String TRIGGER_AREA = "triggerExecutionSpecificArea";
    public static final String TRIGGER_INNERAREA = "triggerExecutionInnerArea";
    public static final String[] SUBENTRY_OPATTRS = new String[]{"accessControlSubentries", "subschemaSubentry", "collectiveAttributeSubentries", "triggerExecutionSubentries"};
    private static final Logger LOG = LoggerFactory.getLogger(SubentryInterceptor.class);
    private final SubentryCache subentryCache = new SubentryCache();
    private SubtreeSpecificationParser ssParser;
    private SubtreeEvaluator evaluator;
    private PartitionNexus nexus;
    private SchemaManager schemaManager;
    private OidRegistry oidRegistry;
    private AttributeType objectClassType;

    @Override
    public void init(DirectoryService directoryService) throws Exception {
        super.init(directoryService);
        this.nexus = directoryService.getPartitionNexus();
        this.schemaManager = directoryService.getSchemaManager();
        this.oidRegistry = this.schemaManager.getGlobalOidRegistry();
        this.objectClassType = this.schemaManager.lookupAttributeTypeRegistry(this.schemaManager.getAttributeTypeRegistry().getOidByName("objectClass"));
        this.ssParser = new SubtreeSpecificationParser(new NormalizerMappingResolver(){

            @Override
            public Map<String, OidNormalizer> getNormalizerMapping() throws Exception {
                return SubentryInterceptor.this.schemaManager.getNormalizerMapping();
            }
        }, this.schemaManager.getNormalizerMapping());
        this.evaluator = new SubtreeEvaluator(this.oidRegistry, this.schemaManager);
        Set<String> suffixes = this.nexus.listSuffixes(null);
        EqualityNode<String> filter = new EqualityNode<String>("objectClass", new StringValue("subentry"));
        SearchControls controls = new SearchControls();
        controls.setSearchScope(2);
        controls.setReturningAttributes(new String[]{"subtreeSpecification", "objectClass"});
        for (String suffix : suffixes) {
            DN suffixDn = new DN(suffix);
            suffixDn.normalize(this.schemaManager.getNormalizerMapping());
            DN adminDn = new DN("0.9.2342.19200300.100.1.1=admin,2.5.4.11=system");
            adminDn.normalize(this.schemaManager.getNormalizerMapping());
            DefaultCoreSession adminSession = new DefaultCoreSession(new LdapPrincipal(adminDn, AuthenticationLevel.STRONG), directoryService);
            SearchOperationContext searchOperationContext = new SearchOperationContext(adminSession, suffixDn, filter, controls);
            searchOperationContext.setAliasDerefMode(AliasDerefMode.NEVER_DEREF_ALIASES);
            EntryFilteringCursor subentries = this.nexus.search(searchOperationContext);
            while (subentries.next()) {
                SubtreeSpecification ss;
                ServerEntry subentry = (ServerEntry)subentries.get();
                DN dnName = subentry.getDn();
                String subtree = subentry.get("subtreeSpecification").getString();
                try {
                    ss = this.ssParser.parse(subtree);
                }
                catch (Exception e) {
                    LOG.warn("Failed while parsing subtreeSpecification for " + dnName);
                    continue;
                }
                dnName.normalize(this.schemaManager.getNormalizerMapping());
                this.subentryCache.setSubentry(dnName.getNormName(), ss, this.getSubentryTypes(subentry));
            }
        }
    }

    private int getSubentryTypes(ServerEntry subentry) throws Exception {
        int types = 0;
        EntryAttribute oc = subentry.get("objectClass");
        if (oc == null) {
            throw new LdapSchemaViolationException(ResultCodeEnum.OBJECT_CLASS_VIOLATION, I18n.err(I18n.ERR_305, new Object[0]));
        }
        if (oc.contains("accessControlSubentry")) {
            types |= 4;
        }
        if (oc.contains("subschema")) {
            types |= 2;
        }
        if (oc.contains("collectiveAttributeSubentry")) {
            types |= 1;
        }
        if (oc.contains("triggerExecutionSubentry")) {
            types |= 8;
        }
        return types;
    }

    @Override
    public EntryFilteringCursor list(NextInterceptor nextInterceptor, ListOperationContext opContext) throws Exception {
        EntryFilteringCursor cursor = nextInterceptor.list(opContext);
        if (!this.isSubentryVisible(opContext)) {
            cursor.addEntryFilter(new HideSubentriesFilter());
        }
        return cursor;
    }

    @Override
    public EntryFilteringCursor search(NextInterceptor nextInterceptor, SearchOperationContext opContext) throws Exception {
        EntryFilteringCursor cursor = nextInterceptor.search(opContext);
        if (opContext.getScope() == SearchScope.OBJECT) {
            return cursor;
        }
        if (!this.isSubentryVisible(opContext)) {
            cursor.addEntryFilter(new HideSubentriesFilter());
        } else {
            cursor.addEntryFilter(new HideEntriesFilter());
        }
        return cursor;
    }

    private boolean isSubentryVisible(OperationContext opContext) throws Exception {
        if (!opContext.hasRequestControls()) {
            return false;
        }
        if (opContext.hasRequestControl(SUBENTRY_CONTROL)) {
            SubentriesControl subentriesControl = (SubentriesControl)opContext.getRequestControl(SUBENTRY_CONTROL);
            return subentriesControl.isVisible();
        }
        return false;
    }

    public ServerEntry getSubentryAttributes(DN dn, ServerEntry entryAttrs) throws Exception {
        DefaultServerEntry subentryAttrs = new DefaultServerEntry(this.schemaManager, dn);
        Iterator<String> list = this.subentryCache.nameIterator();
        while (list.hasNext()) {
            EntryAttribute operational;
            String subentryDnStr = list.next();
            DN subentryDn = new DN(subentryDnStr);
            DN apDn = (DN)subentryDn.clone();
            apDn.remove(apDn.size() - 1);
            Subentry subentry = this.subentryCache.getSubentry(subentryDnStr);
            SubtreeSpecification ss = subentry.getSubtreeSpecification();
            if (!this.evaluator.evaluate(ss, apDn, dn, entryAttrs)) continue;
            if (subentry.isAccessControlSubentry()) {
                operational = subentryAttrs.get("accessControlSubentries");
                if (operational == null) {
                    operational = new DefaultServerAttribute("accessControlSubentries", this.schemaManager.lookupAttributeTypeRegistry("accessControlSubentries"));
                    subentryAttrs.put(operational);
                }
                operational.add(subentryDn.getNormName());
            }
            if (subentry.isSchemaSubentry()) {
                operational = subentryAttrs.get("subschemaSubentry");
                if (operational == null) {
                    operational = new DefaultServerAttribute("subschemaSubentry", this.schemaManager.lookupAttributeTypeRegistry("subschemaSubentry"));
                    subentryAttrs.put(operational);
                }
                operational.add(subentryDn.getNormName());
            }
            if (subentry.isCollectiveSubentry()) {
                operational = subentryAttrs.get("collectiveAttributeSubentries");
                if (operational == null) {
                    operational = new DefaultServerAttribute("collectiveAttributeSubentries", this.schemaManager.lookupAttributeTypeRegistry("collectiveAttributeSubentries"));
                    subentryAttrs.put(operational);
                }
                operational.add(subentryDn.getNormName());
            }
            if (!subentry.isTriggerSubentry()) continue;
            operational = subentryAttrs.get("triggerExecutionSubentries");
            if (operational == null) {
                operational = new DefaultServerAttribute("triggerExecutionSubentries", this.schemaManager.lookupAttributeTypeRegistry("triggerExecutionSubentries"));
                subentryAttrs.put(operational);
            }
            operational.add(subentryDn.getNormName());
        }
        return subentryAttrs;
    }

    @Override
    public void add(NextInterceptor next, AddOperationContext addContext) throws Exception {
        DN name = addContext.getDn();
        ClonedServerEntry entry = addContext.getEntry();
        EntryAttribute objectClasses = entry.get("objectClass");
        if (objectClasses.contains("subentry")) {
            SubtreeSpecification ss;
            DN apName = (DN)name.clone();
            apName.remove(name.size() - 1);
            ClonedServerEntry ap = addContext.lookup(apName, ByPassConstants.LOOKUP_BYPASS);
            EntryAttribute administrativeRole = ap.get("administrativeRole");
            if (administrativeRole == null || administrativeRole.size() <= 0) {
                throw new LdapNoSuchAttributeException(I18n.err(I18n.ERR_306, apName));
            }
            Subentry subentry = new Subentry();
            subentry.setTypes(this.getSubentryTypes(entry));
            ServerEntry operational = this.getSubentryOperatationalAttributes(name, subentry);
            String subtree = entry.get("subtreeSpecification").getString();
            try {
                ss = this.ssParser.parse(subtree);
            }
            catch (Exception e) {
                String msg = I18n.err(I18n.ERR_307, name.getName());
                LOG.warn(msg);
                throw new LdapInvalidAttributeValueException(ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX, msg);
            }
            this.subentryCache.setSubentry(name.getNormName(), ss, this.getSubentryTypes(entry));
            next.add(addContext);
            DN baseDn = (DN)apName.clone();
            baseDn.addAll(ss.getBase());
            PresenceNode filter = new PresenceNode("2.5.4.0");
            SearchControls controls = new SearchControls();
            controls.setSearchScope(2);
            controls.setReturningAttributes(new String[]{"+", "*"});
            SearchOperationContext searchOperationContext = new SearchOperationContext(addContext.getSession(), baseDn, filter, controls);
            searchOperationContext.setAliasDerefMode(AliasDerefMode.NEVER_DEREF_ALIASES);
            EntryFilteringCursor subentries = this.nexus.search(searchOperationContext);
            while (subentries.next()) {
                ServerEntry candidate = (ServerEntry)subentries.get();
                DN dn = candidate.getDn();
                dn.normalize(this.schemaManager.getNormalizerMapping());
                if (!this.evaluator.evaluate(ss, apName, dn, candidate)) continue;
                this.nexus.modify(new ModifyOperationContext(addContext.getSession(), dn, this.getOperationalModsForAdd(candidate, operational)));
            }
            addContext.setEntry(entry);
        } else {
            Iterator<String> list = this.subentryCache.nameIterator();
            while (list.hasNext()) {
                EntryAttribute operational;
                String subentryDnStr = list.next();
                DN subentryDn = new DN(subentryDnStr);
                DN apDn = (DN)subentryDn.clone();
                apDn.remove(apDn.size() - 1);
                Subentry subentry = this.subentryCache.getSubentry(subentryDnStr);
                SubtreeSpecification ss = subentry.getSubtreeSpecification();
                if (!this.evaluator.evaluate(ss, apDn, name, entry)) continue;
                if (subentry.isAccessControlSubentry()) {
                    operational = entry.get("accessControlSubentries");
                    if (operational == null) {
                        operational = new DefaultServerAttribute(this.schemaManager.lookupAttributeTypeRegistry("accessControlSubentries"));
                        entry.put(operational);
                    }
                    operational.add(subentryDn.getNormName());
                }
                if (subentry.isSchemaSubentry()) {
                    operational = entry.get("subschemaSubentry");
                    if (operational == null) {
                        operational = new DefaultServerAttribute(this.schemaManager.lookupAttributeTypeRegistry("subschemaSubentry"));
                        entry.put(operational);
                    }
                    operational.add(subentryDn.getNormName());
                }
                if (subentry.isCollectiveSubentry()) {
                    operational = entry.get("collectiveAttributeSubentries");
                    if (operational == null) {
                        operational = new DefaultServerAttribute(this.schemaManager.lookupAttributeTypeRegistry("collectiveAttributeSubentries"));
                        entry.put(operational);
                    }
                    operational.add(subentryDn.getNormName());
                }
                if (!subentry.isTriggerSubentry()) continue;
                operational = entry.get("triggerExecutionSubentries");
                if (operational == null) {
                    operational = new DefaultServerAttribute(this.schemaManager.lookupAttributeTypeRegistry("triggerExecutionSubentries"));
                    entry.put(operational);
                }
                operational.add(subentryDn.getNormName());
            }
            addContext.setEntry(entry);
            next.add(addContext);
        }
    }

    @Override
    public void delete(NextInterceptor next, DeleteOperationContext opContext) throws Exception {
        DN name = opContext.getDn();
        ClonedServerEntry entry = opContext.lookup(name, ByPassConstants.LOOKUP_BYPASS);
        EntryAttribute objectClasses = entry.get(this.objectClassType);
        if (objectClasses.contains("subentry")) {
            SubtreeSpecification ss = this.subentryCache.removeSubentry(name.getNormName()).getSubtreeSpecification();
            next.delete(opContext);
            DN apName = (DN)name.clone();
            apName.remove(name.size() - 1);
            DN baseDn = (DN)apName.clone();
            baseDn.addAll(ss.getBase());
            PresenceNode filter = new PresenceNode(this.schemaManager.getAttributeTypeRegistry().getOidByName("objectClass"));
            SearchControls controls = new SearchControls();
            controls.setSearchScope(2);
            controls.setReturningAttributes(new String[]{"+", "*"});
            SearchOperationContext searchOperationContext = new SearchOperationContext(opContext.getSession(), baseDn, filter, controls);
            searchOperationContext.setAliasDerefMode(AliasDerefMode.NEVER_DEREF_ALIASES);
            EntryFilteringCursor subentries = this.nexus.search(searchOperationContext);
            while (subentries.next()) {
                ServerEntry candidate = (ServerEntry)subentries.get();
                DN dn = new DN(candidate.getDn());
                dn.normalize(this.schemaManager.getNormalizerMapping());
                if (!this.evaluator.evaluate(ss, apName, dn, candidate)) continue;
                this.nexus.modify(new ModifyOperationContext(opContext.getSession(), dn, this.getOperationalModsForRemove(name, candidate)));
            }
        } else {
            next.delete(opContext);
        }
    }

    private boolean hasAdministrativeDescendant(OperationContext opContext, DN name) throws Exception {
        PresenceNode filter = new PresenceNode("administrativeRole");
        SearchControls controls = new SearchControls();
        controls.setSearchScope(2);
        SearchOperationContext searchOperationContext = new SearchOperationContext(opContext.getSession(), name, filter, controls);
        searchOperationContext.setAliasDerefMode(AliasDerefMode.NEVER_DEREF_ALIASES);
        EntryFilteringCursor aps = this.nexus.search(searchOperationContext);
        if (aps.next()) {
            aps.close();
            return true;
        }
        return false;
    }

    private List<Modification> getModsOnEntryRdnChange(DN oldName, DN newName, ServerEntry entry) throws Exception {
        ArrayList<Modification> modList = new ArrayList<Modification>();
        Iterator<String> subentries = this.subentryCache.nameIterator();
        while (subentries.hasNext()) {
            EntryAttribute opAttr;
            ModificationOperation op;
            boolean isNewNameSelected;
            String subentryDn = subentries.next();
            DN apDn = new DN(subentryDn);
            apDn.remove(apDn.size() - 1);
            SubtreeSpecification ss = this.subentryCache.getSubentry(subentryDn).getSubtreeSpecification();
            boolean isOldNameSelected = this.evaluator.evaluate(ss, apDn, oldName, entry);
            if (isOldNameSelected == (isNewNameSelected = this.evaluator.evaluate(ss, apDn, newName, entry))) continue;
            if (isOldNameSelected && !isNewNameSelected) {
                for (String aSUBENTRY_OPATTRS : SUBENTRY_OPATTRS) {
                    op = ModificationOperation.REPLACE_ATTRIBUTE;
                    opAttr = entry.get(aSUBENTRY_OPATTRS);
                    if (opAttr == null) continue;
                    opAttr = opAttr.clone();
                    opAttr.remove(subentryDn);
                    if (opAttr.size() < 1) {
                        op = ModificationOperation.REMOVE_ATTRIBUTE;
                    }
                    modList.add(new ServerModification(op, opAttr));
                }
                continue;
            }
            if (!isNewNameSelected || isOldNameSelected) continue;
            for (String aSUBENTRY_OPATTRS : SUBENTRY_OPATTRS) {
                op = ModificationOperation.ADD_ATTRIBUTE;
                opAttr = new DefaultServerAttribute(aSUBENTRY_OPATTRS, this.schemaManager.lookupAttributeTypeRegistry(aSUBENTRY_OPATTRS));
                opAttr.add(subentryDn);
                modList.add(new ServerModification(op, opAttr));
            }
        }
        return modList;
    }

    @Override
    public void rename(NextInterceptor next, RenameOperationContext opContext) throws Exception {
        DN name = opContext.getDn();
        ServerEntry entry = (ServerEntry)opContext.getEntry().getClonedEntry();
        EntryAttribute objectClasses = entry.get(this.objectClassType);
        if (objectClasses.contains("subentry")) {
            Subentry subentry = this.subentryCache.getSubentry(name.getNormName());
            SubtreeSpecification ss = subentry.getSubtreeSpecification();
            DN apName = (DN)name.clone();
            apName.remove(apName.size() - 1);
            DN baseDn = (DN)apName.clone();
            baseDn.addAll(ss.getBase());
            DN newName = (DN)name.clone();
            newName.remove(newName.size() - 1);
            newName.add(opContext.getNewRdn());
            String newNormName = newName.getNormName();
            this.subentryCache.setSubentry(newNormName, ss, subentry.getTypes());
            next.rename(opContext);
            subentry = this.subentryCache.getSubentry(newNormName);
            PresenceNode filter = new PresenceNode(this.schemaManager.getAttributeTypeRegistry().getOidByName("objectClass"));
            SearchControls controls = new SearchControls();
            controls.setSearchScope(2);
            controls.setReturningAttributes(new String[]{"+", "*"});
            SearchOperationContext searchOperationContext = new SearchOperationContext(opContext.getSession(), baseDn, filter, controls);
            searchOperationContext.setAliasDerefMode(AliasDerefMode.NEVER_DEREF_ALIASES);
            EntryFilteringCursor subentries = this.nexus.search(searchOperationContext);
            while (subentries.next()) {
                ServerEntry candidate = (ServerEntry)subentries.get();
                DN dn = candidate.getDn();
                dn.normalize(this.schemaManager.getNormalizerMapping());
                if (!this.evaluator.evaluate(ss, apName, dn, candidate)) continue;
                this.nexus.modify(new ModifyOperationContext(opContext.getSession(), dn, this.getOperationalModsForReplace(name, newName, subentry, candidate)));
            }
        } else {
            if (this.hasAdministrativeDescendant(opContext, name)) {
                String msg = I18n.err(I18n.ERR_308, new Object[0]);
                LOG.warn(msg);
                throw new LdapSchemaViolationException(ResultCodeEnum.NOT_ALLOWED_ON_RDN, msg);
            }
            next.rename(opContext);
            DN newName = opContext.getNewDn();
            List<Modification> mods = this.getModsOnEntryRdnChange(name, newName, entry);
            if (mods.size() > 0) {
                this.nexus.modify(new ModifyOperationContext(opContext.getSession(), newName, mods));
            }
        }
    }

    @Override
    public void moveAndRename(NextInterceptor next, MoveAndRenameOperationContext opContext) throws Exception {
        DN oriChildName = opContext.getDn();
        DN parent = opContext.getParent();
        ClonedServerEntry entry = opContext.lookup(oriChildName, ByPassConstants.LOOKUP_BYPASS);
        EntryAttribute objectClasses = entry.get(this.objectClassType);
        if (objectClasses.contains("subentry")) {
            Subentry subentry = this.subentryCache.getSubentry(oriChildName.getNormName());
            SubtreeSpecification ss = subentry.getSubtreeSpecification();
            DN apName = (DN)oriChildName.clone();
            apName.remove(apName.size() - 1);
            DN baseDn = (DN)apName.clone();
            baseDn.addAll(ss.getBase());
            DN newName = (DN)parent.clone();
            newName.remove(newName.size() - 1);
            newName.add(opContext.getNewRdn());
            String newNormName = newName.getNormName();
            this.subentryCache.setSubentry(newNormName, ss, subentry.getTypes());
            next.moveAndRename(opContext);
            subentry = this.subentryCache.getSubentry(newNormName);
            PresenceNode filter = new PresenceNode(this.schemaManager.getAttributeTypeRegistry().getOidByName("objectClass"));
            SearchControls controls = new SearchControls();
            controls.setSearchScope(2);
            controls.setReturningAttributes(new String[]{"+", "*"});
            SearchOperationContext searchOperationContext = new SearchOperationContext(opContext.getSession(), baseDn, filter, controls);
            searchOperationContext.setAliasDerefMode(AliasDerefMode.NEVER_DEREF_ALIASES);
            EntryFilteringCursor subentries = this.nexus.search(searchOperationContext);
            while (subentries.next()) {
                ServerEntry candidate = (ServerEntry)subentries.get();
                DN dn = candidate.getDn();
                dn.normalize(this.schemaManager.getNormalizerMapping());
                if (!this.evaluator.evaluate(ss, apName, dn, candidate)) continue;
                this.nexus.modify(new ModifyOperationContext(opContext.getSession(), dn, this.getOperationalModsForReplace(oriChildName, newName, subentry, candidate)));
            }
        } else {
            if (this.hasAdministrativeDescendant(opContext, oriChildName)) {
                String msg = I18n.err(I18n.ERR_308, new Object[0]);
                LOG.warn(msg);
                throw new LdapSchemaViolationException(ResultCodeEnum.NOT_ALLOWED_ON_RDN, msg);
            }
            next.moveAndRename(opContext);
            DN newName = (DN)parent.clone();
            newName.add(opContext.getNewRdn());
            newName.normalize(this.schemaManager.getNormalizerMapping());
            List<Modification> mods = this.getModsOnEntryRdnChange(oriChildName, newName, entry);
            if (mods.size() > 0) {
                this.nexus.modify(new ModifyOperationContext(opContext.getSession(), newName, mods));
            }
        }
    }

    @Override
    public void move(NextInterceptor next, MoveOperationContext opContext) throws Exception {
        DN oriChildName = opContext.getDn();
        DN newParentName = opContext.getParent();
        ClonedServerEntry entry = opContext.lookup(oriChildName, ByPassConstants.LOOKUP_BYPASS);
        EntryAttribute objectClasses = entry.get("objectClass");
        if (objectClasses.contains("subentry")) {
            Subentry subentry = this.subentryCache.getSubentry(oriChildName.getNormName());
            SubtreeSpecification ss = subentry.getSubtreeSpecification();
            DN apName = (DN)oriChildName.clone();
            apName.remove(apName.size() - 1);
            DN baseDn = (DN)apName.clone();
            baseDn.addAll(ss.getBase());
            DN newName = (DN)newParentName.clone();
            newName.remove(newName.size() - 1);
            newName.add(newParentName.get(newParentName.size() - 1));
            String newNormName = newName.getNormName();
            this.subentryCache.setSubentry(newNormName, ss, subentry.getTypes());
            next.move(opContext);
            subentry = this.subentryCache.getSubentry(newNormName);
            PresenceNode filter = new PresenceNode("objectClass");
            SearchControls controls = new SearchControls();
            controls.setSearchScope(2);
            controls.setReturningAttributes(new String[]{"+", "*"});
            SearchOperationContext searchOperationContext = new SearchOperationContext(opContext.getSession(), baseDn, filter, controls);
            searchOperationContext.setAliasDerefMode(AliasDerefMode.NEVER_DEREF_ALIASES);
            EntryFilteringCursor subentries = this.nexus.search(searchOperationContext);
            while (subentries.next()) {
                ServerEntry candidate = (ServerEntry)subentries.get();
                DN dn = candidate.getDn();
                dn.normalize(this.schemaManager.getNormalizerMapping());
                if (!this.evaluator.evaluate(ss, apName, dn, candidate)) continue;
                this.nexus.modify(new ModifyOperationContext(opContext.getSession(), dn, this.getOperationalModsForReplace(oriChildName, newName, subentry, candidate)));
            }
        } else {
            if (this.hasAdministrativeDescendant(opContext, oriChildName)) {
                String msg = I18n.err(I18n.ERR_308, new Object[0]);
                LOG.warn(msg);
                throw new LdapSchemaViolationException(ResultCodeEnum.NOT_ALLOWED_ON_RDN, msg);
            }
            next.move(opContext);
            DN newName = (DN)newParentName.clone();
            newName.add(oriChildName.get(oriChildName.size() - 1));
            List<Modification> mods = this.getModsOnEntryRdnChange(oriChildName, newName, entry);
            if (mods.size() > 0) {
                this.nexus.modify(new ModifyOperationContext(opContext.getSession(), newName, mods));
            }
        }
    }

    private int getSubentryTypes(ServerEntry entry, List<Modification> mods) throws Exception {
        EntryAttribute ocFinalState = entry.get("objectClass").clone();
        block5: for (Modification mod : mods) {
            if (!mod.getAttribute().getId().equalsIgnoreCase("objectClass")) continue;
            switch (mod.getOperation()) {
                case ADD_ATTRIBUTE: {
                    for (Value value : mod.getAttribute()) {
                        ocFinalState.add(value.getString());
                    }
                    continue block5;
                }
                case REMOVE_ATTRIBUTE: {
                    for (Value value : mod.getAttribute()) {
                        ocFinalState.remove(value.getString());
                    }
                    continue block5;
                }
                case REPLACE_ATTRIBUTE: {
                    ocFinalState = mod.getAttribute();
                }
            }
        }
        DefaultServerEntry attrs = new DefaultServerEntry(this.schemaManager, DN.EMPTY_DN);
        attrs.put(ocFinalState);
        return this.getSubentryTypes(attrs);
    }

    @Override
    public void modify(NextInterceptor next, ModifyOperationContext opContext) throws Exception {
        DN name = opContext.getDn();
        List<Modification> mods = opContext.getModItems();
        ClonedServerEntry entry = opContext.lookup(name, ByPassConstants.LOOKUP_BYPASS);
        ServerEntry oldEntry = (ServerEntry)entry.clone();
        EntryAttribute objectClasses = entry.get(this.objectClassType);
        boolean isSubtreeSpecificationModification = false;
        Modification subtreeMod = null;
        for (Modification mod : mods) {
            if (!"subtreeSpecification".equalsIgnoreCase(mod.getAttribute().getId())) continue;
            isSubtreeSpecificationModification = true;
            subtreeMod = mod;
        }
        if (objectClasses.contains("subentry") && isSubtreeSpecificationModification) {
            SubtreeSpecification ssNew;
            SubtreeSpecification ssOld = this.subentryCache.removeSubentry(name.getNormName()).getSubtreeSpecification();
            try {
                ssNew = this.ssParser.parse(subtreeMod.getAttribute().getString());
            }
            catch (Exception e) {
                String msg = I18n.err(I18n.ERR_71, new Object[0]);
                LOG.error(msg, (Throwable)e);
                throw new LdapInvalidAttributeValueException(ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX, msg);
            }
            this.subentryCache.setSubentry(name.getNormName(), ssNew, this.getSubentryTypes(entry, mods));
            next.modify(opContext);
            DN apName = (DN)name.clone();
            apName.remove(apName.size() - 1);
            DN oldBaseDn = (DN)apName.clone();
            oldBaseDn.addAll(ssOld.getBase());
            PresenceNode filter = new PresenceNode(this.schemaManager.getAttributeTypeRegistry().getOidByName("objectClass"));
            SearchControls controls = new SearchControls();
            controls.setSearchScope(2);
            controls.setReturningAttributes(new String[]{"+", "*"});
            SearchOperationContext searchOperationContext = new SearchOperationContext(opContext.getSession(), oldBaseDn, filter, controls);
            searchOperationContext.setAliasDerefMode(AliasDerefMode.NEVER_DEREF_ALIASES);
            EntryFilteringCursor subentries = this.nexus.search(searchOperationContext);
            while (subentries.next()) {
                ServerEntry candidate = (ServerEntry)subentries.get();
                DN dn = candidate.getDn();
                dn.normalize(this.schemaManager.getNormalizerMapping());
                if (!this.evaluator.evaluate(ssOld, apName, dn, candidate)) continue;
                this.nexus.modify(new ModifyOperationContext(opContext.getSession(), dn, this.getOperationalModsForRemove(name, candidate)));
            }
            Subentry subentry = this.subentryCache.getSubentry(name.getNormName());
            ServerEntry operational = this.getSubentryOperatationalAttributes(name, subentry);
            DN newBaseDn = (DN)apName.clone();
            newBaseDn.addAll(ssNew.getBase());
            searchOperationContext = new SearchOperationContext(opContext.getSession(), newBaseDn, filter, controls);
            searchOperationContext.setAliasDerefMode(AliasDerefMode.NEVER_DEREF_ALIASES);
            subentries = this.nexus.search(searchOperationContext);
            while (subentries.next()) {
                ServerEntry candidate = (ServerEntry)subentries.get();
                DN dn = candidate.getDn();
                dn.normalize(this.schemaManager.getNormalizerMapping());
                if (!this.evaluator.evaluate(ssNew, apName, dn, candidate)) continue;
                this.nexus.modify(new ModifyOperationContext(opContext.getSession(), dn, this.getOperationalModsForAdd(candidate, operational)));
            }
        } else {
            ClonedServerEntry newEntry;
            List<Modification> subentriesOpAttrMods;
            next.modify(opContext);
            if (!objectClasses.contains("subentry") && (subentriesOpAttrMods = this.getModsOnEntryModification(name, oldEntry, newEntry = opContext.lookup(name, ByPassConstants.LOOKUP_BYPASS))).size() > 0) {
                this.nexus.modify(new ModifyOperationContext(opContext.getSession(), name, subentriesOpAttrMods));
            }
        }
    }

    private List<Modification> getOperationalModsForReplace(DN oldName, DN newName, Subentry subentry, ServerEntry entry) throws Exception {
        EntryAttribute operational;
        ArrayList<Modification> modList = new ArrayList<Modification>();
        if (subentry.isAccessControlSubentry()) {
            operational = entry.get("accessControlSubentries").clone();
            if (operational == null) {
                operational = new DefaultServerAttribute("accessControlSubentries", this.schemaManager.lookupAttributeTypeRegistry("accessControlSubentries"));
                operational.add(newName.toString());
            } else {
                operational.remove(oldName.toString());
                operational.add(newName.toString());
            }
            modList.add(new ServerModification(ModificationOperation.REPLACE_ATTRIBUTE, operational));
        }
        if (subentry.isSchemaSubentry()) {
            operational = entry.get("subschemaSubentry").clone();
            if (operational == null) {
                operational = new DefaultServerAttribute("subschemaSubentry", this.schemaManager.lookupAttributeTypeRegistry("subschemaSubentry"));
                operational.add(newName.toString());
            } else {
                operational.remove(oldName.toString());
                operational.add(newName.toString());
            }
            modList.add(new ServerModification(ModificationOperation.REPLACE_ATTRIBUTE, operational));
        }
        if (subentry.isCollectiveSubentry()) {
            operational = entry.get("collectiveAttributeSubentries").clone();
            if (operational == null) {
                operational = new DefaultServerAttribute("collectiveAttributeSubentries", this.schemaManager.lookupAttributeTypeRegistry("collectiveAttributeSubentries"));
                operational.add(newName.toString());
            } else {
                operational.remove(oldName.toString());
                operational.add(newName.toString());
            }
            modList.add(new ServerModification(ModificationOperation.REPLACE_ATTRIBUTE, operational));
        }
        if (subentry.isTriggerSubentry()) {
            operational = entry.get("triggerExecutionSubentries").clone();
            if (operational == null) {
                operational = new DefaultServerAttribute("triggerExecutionSubentries", this.schemaManager.lookupAttributeTypeRegistry("triggerExecutionSubentries"));
                operational.add(newName.toString());
            } else {
                operational.remove(oldName.toString());
                operational.add(newName.toString());
            }
            modList.add(new ServerModification(ModificationOperation.REPLACE_ATTRIBUTE, operational));
        }
        return modList;
    }

    private ServerEntry getSubentryOperatationalAttributes(DN name, Subentry subentry) throws Exception {
        DefaultServerEntry operational = new DefaultServerEntry(this.schemaManager, name);
        if (subentry.isAccessControlSubentry()) {
            if (operational.get("accessControlSubentries") == null) {
                operational.put("accessControlSubentries", name.getNormName());
            } else {
                operational.get("accessControlSubentries").add(name.getNormName());
            }
        }
        if (subentry.isSchemaSubentry()) {
            if (operational.get("subschemaSubentry") == null) {
                operational.put("subschemaSubentry", name.getNormName());
            } else {
                operational.get("subschemaSubentry").add(name.getNormName());
            }
        }
        if (subentry.isCollectiveSubentry()) {
            if (operational.get("collectiveAttributeSubentries") == null) {
                operational.put("collectiveAttributeSubentries", name.getNormName());
            } else {
                operational.get("collectiveAttributeSubentries").add(name.getNormName());
            }
        }
        if (subentry.isTriggerSubentry()) {
            if (operational.get("triggerExecutionSubentries") == null) {
                operational.put("triggerExecutionSubentries", name.getNormName());
            } else {
                operational.get("triggerExecutionSubentries").add(name.getNormName());
            }
        }
        return operational;
    }

    private List<Modification> getOperationalModsForRemove(DN subentryDn, ServerEntry candidate) throws Exception {
        ArrayList<Modification> modList = new ArrayList<Modification>();
        String dn = subentryDn.getNormName();
        for (String opAttrId : SUBENTRY_OPATTRS) {
            EntryAttribute opAttr = candidate.get(opAttrId);
            if (opAttr == null || !opAttr.contains(dn)) continue;
            AttributeType attributeType = this.schemaManager.lookupAttributeTypeRegistry(opAttrId);
            DefaultServerAttribute attr = new DefaultServerAttribute(opAttrId, attributeType, dn);
            modList.add(new ServerModification(ModificationOperation.REMOVE_ATTRIBUTE, attr));
        }
        return modList;
    }

    public List<Modification> getOperationalModsForAdd(ServerEntry entry, ServerEntry operational) throws Exception {
        ArrayList<Modification> modList = new ArrayList<Modification>();
        for (AttributeType attributeType : operational.getAttributeTypes()) {
            ModificationOperation op = ModificationOperation.REPLACE_ATTRIBUTE;
            DefaultServerAttribute result = new DefaultServerAttribute(attributeType);
            EntryAttribute opAttrAdditions = operational.get(attributeType);
            EntryAttribute opAttrInEntry = entry.get(attributeType);
            for (Value value : opAttrAdditions) {
                result.add(value);
            }
            if (opAttrInEntry != null && opAttrInEntry.size() > 0) {
                for (Value value : opAttrInEntry) {
                    result.add(value);
                }
            } else {
                op = ModificationOperation.ADD_ATTRIBUTE;
            }
            modList.add(new ServerModification(op, result));
        }
        return modList;
    }

    private List<Modification> getModsOnEntryModification(DN name, ServerEntry oldEntry, ServerEntry newEntry) throws Exception {
        ArrayList<Modification> modList = new ArrayList<Modification>();
        Iterator<String> subentries = this.subentryCache.nameIterator();
        while (subentries.hasNext()) {
            ModificationOperation op;
            boolean isNewEntrySelected;
            String subentryDn = subentries.next();
            DN apDn = new DN(subentryDn);
            apDn.remove(apDn.size() - 1);
            SubtreeSpecification ss = this.subentryCache.getSubentry(subentryDn).getSubtreeSpecification();
            boolean isOldEntrySelected = this.evaluator.evaluate(ss, apDn, name, oldEntry);
            if (isOldEntrySelected == (isNewEntrySelected = this.evaluator.evaluate(ss, apDn, name, newEntry))) continue;
            if (isOldEntrySelected && !isNewEntrySelected) {
                for (String aSUBENTRY_OPATTRS : SUBENTRY_OPATTRS) {
                    op = ModificationOperation.REPLACE_ATTRIBUTE;
                    EntryAttribute opAttr = oldEntry.get(aSUBENTRY_OPATTRS);
                    if (opAttr == null) continue;
                    opAttr = opAttr.clone();
                    opAttr.remove(subentryDn);
                    if (opAttr.size() < 1) {
                        op = ModificationOperation.REMOVE_ATTRIBUTE;
                    }
                    modList.add(new ServerModification(op, opAttr));
                }
                continue;
            }
            if (!isNewEntrySelected || isOldEntrySelected) continue;
            for (String attribute : SUBENTRY_OPATTRS) {
                op = ModificationOperation.ADD_ATTRIBUTE;
                AttributeType type = this.schemaManager.lookupAttributeTypeRegistry(attribute);
                DefaultServerAttribute opAttr = new DefaultServerAttribute(attribute, type);
                opAttr.add(subentryDn);
                modList.add(new ServerModification(op, opAttr));
            }
        }
        return modList;
    }

    public class HideEntriesFilter
    implements EntryFilter {
        public boolean accept(SearchingOperationContext operation, ClonedServerEntry entry) throws Exception {
            String dn = entry.getDn().getNormName();
            if (SubentryInterceptor.this.subentryCache.hasSubentry(dn)) {
                return true;
            }
            EntryAttribute objectClasses = entry.get("objectClass");
            if (objectClasses != null) {
                return objectClasses.contains("subentry");
            }
            DN ndn = new DN(dn);
            ndn.normalize(SubentryInterceptor.this.schemaManager.getNormalizerMapping());
            return SubentryInterceptor.this.subentryCache.hasSubentry(ndn.getNormName());
        }
    }

    public class HideSubentriesFilter
    implements EntryFilter {
        public boolean accept(SearchingOperationContext operation, ClonedServerEntry entry) throws Exception {
            String dn = entry.getDn().getNormName();
            if (SubentryInterceptor.this.subentryCache.hasSubentry(dn)) {
                return false;
            }
            EntryAttribute objectClasses = entry.get("objectClass");
            if (objectClasses != null) {
                return !objectClasses.contains("subentry");
            }
            DN ndn = new DN(dn);
            ndn.normalize(SubentryInterceptor.this.schemaManager.getNormalizerMapping());
            String normalizedDn = ndn.getNormName();
            return !SubentryInterceptor.this.subentryCache.hasSubentry(normalizedDn);
        }
    }
}

