/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.schema.manager.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.NotImplementedException;
import org.apache.directory.shared.ldap.entry.Entry;
import org.apache.directory.shared.ldap.exception.LdapException;
import org.apache.directory.shared.ldap.exception.LdapInvalidDnException;
import org.apache.directory.shared.ldap.exception.LdapProtocolErrorException;
import org.apache.directory.shared.ldap.exception.LdapUnwillingToPerformException;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.name.DN;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.EntityFactory;
import org.apache.directory.shared.ldap.schema.LdapComparator;
import org.apache.directory.shared.ldap.schema.LdapSyntax;
import org.apache.directory.shared.ldap.schema.LoadableSchemaObject;
import org.apache.directory.shared.ldap.schema.MatchingRule;
import org.apache.directory.shared.ldap.schema.Normalizer;
import org.apache.directory.shared.ldap.schema.ObjectClass;
import org.apache.directory.shared.ldap.schema.SchemaManager;
import org.apache.directory.shared.ldap.schema.SchemaObject;
import org.apache.directory.shared.ldap.schema.SchemaObjectWrapper;
import org.apache.directory.shared.ldap.schema.SyntaxChecker;
import org.apache.directory.shared.ldap.schema.loader.ldif.SchemaEntityFactory;
import org.apache.directory.shared.ldap.schema.normalizers.OidNormalizer;
import org.apache.directory.shared.ldap.schema.registries.AttributeTypeRegistry;
import org.apache.directory.shared.ldap.schema.registries.ComparatorRegistry;
import org.apache.directory.shared.ldap.schema.registries.DITContentRuleRegistry;
import org.apache.directory.shared.ldap.schema.registries.DITStructureRuleRegistry;
import org.apache.directory.shared.ldap.schema.registries.ImmutableAttributeTypeRegistry;
import org.apache.directory.shared.ldap.schema.registries.ImmutableComparatorRegistry;
import org.apache.directory.shared.ldap.schema.registries.ImmutableDITContentRuleRegistry;
import org.apache.directory.shared.ldap.schema.registries.ImmutableDITStructureRuleRegistry;
import org.apache.directory.shared.ldap.schema.registries.ImmutableLdapSyntaxRegistry;
import org.apache.directory.shared.ldap.schema.registries.ImmutableMatchingRuleRegistry;
import org.apache.directory.shared.ldap.schema.registries.ImmutableMatchingRuleUseRegistry;
import org.apache.directory.shared.ldap.schema.registries.ImmutableNameFormRegistry;
import org.apache.directory.shared.ldap.schema.registries.ImmutableNormalizerRegistry;
import org.apache.directory.shared.ldap.schema.registries.ImmutableObjectClassRegistry;
import org.apache.directory.shared.ldap.schema.registries.ImmutableSyntaxCheckerRegistry;
import org.apache.directory.shared.ldap.schema.registries.LdapSyntaxRegistry;
import org.apache.directory.shared.ldap.schema.registries.MatchingRuleRegistry;
import org.apache.directory.shared.ldap.schema.registries.MatchingRuleUseRegistry;
import org.apache.directory.shared.ldap.schema.registries.NameFormRegistry;
import org.apache.directory.shared.ldap.schema.registries.NormalizerRegistry;
import org.apache.directory.shared.ldap.schema.registries.ObjectClassRegistry;
import org.apache.directory.shared.ldap.schema.registries.OidRegistry;
import org.apache.directory.shared.ldap.schema.registries.Registries;
import org.apache.directory.shared.ldap.schema.registries.Schema;
import org.apache.directory.shared.ldap.schema.registries.SchemaLoader;
import org.apache.directory.shared.ldap.schema.registries.SyntaxCheckerRegistry;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSchemaManager
implements SchemaManager {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultSchemaManager.class);
    private DN namingContext;
    private volatile Registries registries;
    private List<Throwable> errors;
    private SchemaLoader schemaLoader;
    protected final EntityFactory factory;
    private DN schemaModificationAttributesDN;
    private Map<String, Set<String>> schemaDependences = new HashMap<String, Set<String>>();
    private boolean isRelaxed = false;
    public static final boolean STRICT = false;
    public static final boolean RELAXED = true;

    public DefaultSchemaManager(SchemaLoader loader) throws Exception {
        this.namingContext = DN.EMPTY_DN;
        this.schemaLoader = loader;
        this.errors = new ArrayList<Throwable>();
        this.registries = new Registries(this);
        this.factory = new SchemaEntityFactory();
        this.isRelaxed = false;
    }

    public DefaultSchemaManager(SchemaLoader loader, DN namingContext) throws Exception {
        this.namingContext = namingContext;
        this.schemaLoader = loader;
        this.errors = new ArrayList<Throwable>();
        this.registries = new Registries(this);
        this.factory = new SchemaEntityFactory();
        this.isRelaxed = false;
    }

    private Registries cloneRegistries() throws Exception {
        this.errors = new ArrayList<Throwable>();
        Registries clonedRegistries = this.registries.clone();
        this.errors = clonedRegistries.checkRefInteg();
        clonedRegistries.setRelaxed();
        return clonedRegistries;
    }

    private Schema[] toArray(String ... schemas) throws Exception {
        Schema[] schemaArray = new Schema[schemas.length];
        int n = 0;
        for (String schemaName : schemas) {
            Schema schema = this.schemaLoader.getSchema(schemaName);
            if (schema == null) {
                throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, I18n.err("ERR_11001", schemaName));
            }
            schemaArray[n++] = schema;
        }
        return schemaArray;
    }

    private void addSchemaObjects(Schema schema, Registries registries) throws Exception {
        registries.addSchema(schema.getSchemaName());
        this.addComparators(schema, registries);
        this.addNormalizers(schema, registries);
        this.addSyntaxCheckers(schema, registries);
        this.addSyntaxes(schema, registries);
        this.addMatchingRules(schema, registries);
        this.addAttributeTypes(schema, registries);
        this.addObjectClasses(schema, registries);
        this.addMatchingRuleUses(schema, registries);
        this.addDitContentRules(schema, registries);
        this.addNameForms(schema, registries);
        this.addDitStructureRules(schema, registries);
    }

    private void deleteSchemaObjects(Schema schema, Registries registries) throws Exception {
        Map<String, Set<SchemaObjectWrapper>> schemaObjects = registries.getObjectBySchemaName();
        Set<SchemaObjectWrapper> content = schemaObjects.get(StringTools.toLowerCase(schema.getSchemaName()));
        ArrayList<SchemaObject> toBeDeleted = new ArrayList<SchemaObject>();
        for (SchemaObjectWrapper schemaObjectWrapper : content) {
            toBeDeleted.add(schemaObjectWrapper.get());
        }
        for (SchemaObject schemaObject : toBeDeleted) {
            registries.delete(this.errors, schemaObject);
        }
    }

    private boolean hasSchemaObjects(Schema schema, Registries registries) throws Exception {
        Map<String, Set<SchemaObjectWrapper>> schemaObjects = registries.getObjectBySchemaName();
        Set<SchemaObjectWrapper> content = schemaObjects.get(StringTools.toLowerCase(schema.getSchemaName()));
        return content != null && !content.isEmpty();
    }

    @Override
    public boolean disable(Schema ... schemas) throws Exception {
        boolean disabled = false;
        if (this.errors != null) {
            this.errors.clear();
        }
        Registries clonedRegistries = this.cloneRegistries();
        clonedRegistries.setRelaxed();
        for (Schema schema : schemas) {
            this.unload(clonedRegistries, schema);
        }
        this.errors = clonedRegistries.buildReferences();
        clonedRegistries.clear();
        if (this.errors.isEmpty()) {
            this.errors = clonedRegistries.checkRefInteg();
            if (this.errors.isEmpty()) {
                for (Schema schema : schemas) {
                    this.unload(this.registries, schema);
                    schema.disable();
                }
                this.errors = this.registries.buildReferences();
                this.registries.setStrict();
                disabled = true;
            }
        }
        clonedRegistries.clear();
        return disabled;
    }

    @Override
    public boolean disable(String ... schemaNames) throws Exception {
        Schema[] schemas = this.toArray(schemaNames);
        return this.disable(schemas);
    }

    @Override
    public boolean disabledRelaxed(Schema ... schemas) {
        return false;
    }

    @Override
    public boolean disabledRelaxed(String ... schemas) {
        return false;
    }

    @Override
    public List<Schema> getDisabled() {
        ArrayList<Schema> disabled = new ArrayList<Schema>();
        for (Schema schema : this.registries.getLoadedSchemas().values()) {
            if (!schema.isDisabled()) continue;
            disabled.add(schema);
        }
        return disabled;
    }

    @Override
    public boolean enable(Schema ... schemas) throws Exception {
        boolean enabled = false;
        if (this.errors != null) {
            this.errors.clear();
        }
        Registries clonedRegistries = this.cloneRegistries();
        clonedRegistries.setRelaxed();
        for (Schema schema : schemas) {
            schema.enable();
            this.load(clonedRegistries, schema);
        }
        this.errors = clonedRegistries.buildReferences();
        clonedRegistries.clear();
        if (this.errors.isEmpty()) {
            this.errors = clonedRegistries.checkRefInteg();
            if (this.errors.isEmpty()) {
                for (Schema schema : schemas) {
                    schema.enable();
                    this.load(this.registries, schema);
                }
                this.errors = this.registries.buildReferences();
                this.registries.setStrict();
                enabled = true;
            }
        }
        clonedRegistries.clear();
        return enabled;
    }

    @Override
    public boolean enable(String ... schemaNames) throws Exception {
        Schema[] schemas = this.toArray(schemaNames);
        return this.enable(schemas);
    }

    @Override
    public boolean enableRelaxed(Schema ... schemas) {
        return false;
    }

    @Override
    public boolean enableRelaxed(String ... schemas) {
        return false;
    }

    @Override
    public List<Schema> getEnabled() {
        ArrayList<Schema> enabled = new ArrayList<Schema>();
        for (Schema schema : this.registries.getLoadedSchemas().values()) {
            if (!schema.isEnabled()) continue;
            enabled.add(schema);
        }
        return enabled;
    }

    @Override
    public List<Throwable> getErrors() {
        return this.errors;
    }

    @Override
    public Registries getRegistries() {
        return this.registries;
    }

    public boolean isDisabledAccepted() {
        return false;
    }

    @Override
    public boolean load(Schema ... schemas) throws Exception {
        if (schemas.length == 0) {
            return true;
        }
        boolean loaded = false;
        if (this.errors != null) {
            this.errors.clear();
        }
        Registries clonedRegistries = this.cloneRegistries();
        clonedRegistries.setRelaxed();
        for (Schema schema : schemas) {
            if (this.load(clonedRegistries, schema) || this.errors.isEmpty()) continue;
            return false;
        }
        this.errors = clonedRegistries.buildReferences();
        if (this.errors.isEmpty()) {
            this.errors = clonedRegistries.checkRefInteg();
            if (this.errors.isEmpty()) {
                this.registries.setRelaxed();
                for (Schema schema : schemas) {
                    this.load(this.registries, schema);
                    if (schema.getDependencies() != null) {
                        for (String dep : schema.getDependencies()) {
                            Set<String> deps = this.schemaDependences.get(dep);
                            if (deps == null) {
                                deps = new HashSet<String>();
                                deps.add(schema.getSchemaName());
                            }
                            this.schemaDependences.put(dep, deps);
                        }
                    }
                    this.schemaLoader.addSchema(schema);
                }
                this.errors = this.registries.buildReferences();
                this.registries.setStrict();
                loaded = true;
            }
        }
        clonedRegistries.clear();
        return loaded;
    }

    @Override
    public boolean load(String ... schemaNames) throws Exception {
        if (schemaNames.length == 0) {
            return true;
        }
        Schema[] schemas = this.toArray(schemaNames);
        return this.load(schemas);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean load(Registries registries, Schema schema) throws Exception {
        if (schema == null) {
            LOG.info("The schema is null");
            return false;
        }
        if (registries.isSchemaLoaded(schema.getSchemaName())) {
            return true;
        }
        if (schema.isDisabled()) {
            if (!registries.isDisabledAccepted()) return false;
            LOG.info("Loading {} disbaled schema: \n{}", (Object)schema.getSchemaName(), (Object)schema);
            registries.schemaLoaded(schema);
            this.addSchemaObjects(schema, registries);
            return true;
        } else {
            LOG.info("Loading {} enabled schema: \n{}", (Object)schema.getSchemaName(), (Object)schema);
            if (schema.getDependencies() != null) {
                for (String dependency : schema.getDependencies()) {
                    if (this.schemaLoader.getSchema(dependency) != null) continue;
                    String msg = I18n.err("ERR_11002", schema.getSchemaName());
                    LOG.info(msg);
                    LdapProtocolErrorException error = new LdapProtocolErrorException(msg);
                    this.errors.add(error);
                    return false;
                }
            }
            registries.schemaLoaded(schema);
            this.addSchemaObjects(schema, registries);
        }
        return true;
    }

    private boolean unload(Registries registries, Schema schema) throws Exception {
        if (schema == null) {
            LOG.info("The schema is null");
            return false;
        }
        if (!registries.isSchemaLoaded(schema.getSchemaName())) {
            return true;
        }
        if (schema.isEnabled()) {
            LOG.info("Unloading {} schema: \n{}", (Object)schema.getSchemaName(), (Object)schema);
            this.deleteSchemaObjects(schema, registries);
            registries.schemaUnloaded(schema);
        }
        return true;
    }

    private void addAttributeTypes(Schema schema, Registries registries) throws Exception {
        for (Entry entry : this.schemaLoader.loadAttributeTypes(schema)) {
            AttributeType attributeType = this.factory.getAttributeType(this, entry, registries, schema.getSchemaName());
            this.addSchemaObject(registries, attributeType, schema);
        }
    }

    private void addComparators(Schema schema, Registries registries) throws Exception {
        for (Entry entry : this.schemaLoader.loadComparators(schema)) {
            LdapComparator<?> comparator = this.factory.getLdapComparator((SchemaManager)this, entry, registries, schema.getSchemaName());
            this.addSchemaObject(registries, comparator, schema);
        }
    }

    private void addDitContentRules(Schema schema, Registries registries) throws Exception {
        Iterator<Entry> i$ = this.schemaLoader.loadDitContentRules(schema).iterator();
        if (i$.hasNext()) {
            Entry entry = i$.next();
            throw new NotImplementedException(I18n.err("ERR_11003", new Object[0]));
        }
    }

    private void addDitStructureRules(Schema schema, Registries registries) throws Exception {
        Iterator<Entry> i$ = this.schemaLoader.loadDitStructureRules(schema).iterator();
        if (i$.hasNext()) {
            Entry entry = i$.next();
            throw new NotImplementedException(I18n.err("ERR_11004", new Object[0]));
        }
    }

    private void addMatchingRules(Schema schema, Registries registries) throws Exception {
        for (Entry entry : this.schemaLoader.loadMatchingRules(schema)) {
            MatchingRule matchingRule = this.factory.getMatchingRule(this, entry, registries, schema.getSchemaName());
            this.addSchemaObject(registries, matchingRule, schema);
        }
    }

    private void addMatchingRuleUses(Schema schema, Registries registries) throws Exception {
        Iterator<Entry> i$ = this.schemaLoader.loadMatchingRuleUses(schema).iterator();
        if (i$.hasNext()) {
            Entry entry = i$.next();
            throw new NotImplementedException(I18n.err("ERR_11005", new Object[0]));
        }
    }

    private void addNameForms(Schema schema, Registries registries) throws Exception {
        Iterator<Entry> i$ = this.schemaLoader.loadNameForms(schema).iterator();
        if (i$.hasNext()) {
            Entry entry = i$.next();
            throw new NotImplementedException(I18n.err("ERR_11006", new Object[0]));
        }
    }

    private void addNormalizers(Schema schema, Registries registries) throws Exception {
        for (Entry entry : this.schemaLoader.loadNormalizers(schema)) {
            Normalizer normalizer = this.factory.getNormalizer((SchemaManager)this, entry, registries, schema.getSchemaName());
            this.addSchemaObject(registries, normalizer, schema);
        }
    }

    private void addObjectClasses(Schema schema, Registries registries) throws Exception {
        for (Entry entry : this.schemaLoader.loadObjectClasses(schema)) {
            ObjectClass objectClass = this.factory.getObjectClass(this, entry, registries, schema.getSchemaName());
            this.addSchemaObject(registries, objectClass, schema);
        }
    }

    private void addSyntaxes(Schema schema, Registries registries) throws Exception {
        for (Entry entry : this.schemaLoader.loadSyntaxes(schema)) {
            LdapSyntax syntax = this.factory.getSyntax(this, entry, registries, schema.getSchemaName());
            this.addSchemaObject(registries, syntax, schema);
        }
    }

    private void addSyntaxCheckers(Schema schema, Registries registries) throws Exception {
        for (Entry entry : this.schemaLoader.loadSyntaxCheckers(schema)) {
            SyntaxChecker syntaxChecker = this.factory.getSyntaxChecker((SchemaManager)this, entry, registries, schema.getSchemaName());
            this.addSchemaObject(registries, syntaxChecker, schema);
        }
    }

    private SchemaObject addSchemaObject(Registries registries, SchemaObject schemaObject, Schema schema) throws Exception {
        if (registries.isRelaxed()) {
            if (registries.isDisabledAccepted() || schema.isEnabled() && schemaObject.isEnabled()) {
                registries.add(this.errors, schemaObject);
            } else {
                this.errors.add(new Throwable());
            }
        } else if (schema.isEnabled() && schemaObject.isEnabled()) {
            registries.add(this.errors, schemaObject);
        } else {
            this.errors.add(new Throwable());
        }
        return schemaObject;
    }

    @Override
    public boolean loadAllEnabled() throws Exception {
        Schema[] schemas = this.schemaLoader.getAllEnabled().toArray(new Schema[0]);
        return this.loadWithDeps(schemas);
    }

    @Override
    public boolean loadAllEnabledRelaxed() throws Exception {
        return false;
    }

    @Override
    public boolean loadDisabled(Schema ... schemas) throws Exception {
        Registries clonedRegistries = this.cloneRegistries();
        clonedRegistries.setDisabledAccepted(true);
        for (Schema schema : schemas) {
            schema.enable();
            this.load(clonedRegistries, schema);
        }
        clonedRegistries.clear();
        if (this.errors.size() == 0) {
            for (Schema schema : schemas) {
                this.load(this.registries, schema);
            }
            return true;
        }
        for (Schema schema : schemas) {
            schema.disable();
        }
        return false;
    }

    @Override
    public boolean loadDisabled(String ... schemaNames) throws Exception {
        Schema[] schemas = this.toArray(schemaNames);
        return this.loadDisabled(schemas);
    }

    @Override
    public boolean loadRelaxed(Schema ... schemas) throws Exception {
        return false;
    }

    @Override
    public boolean loadRelaxed(String ... schemaNames) throws Exception {
        Schema[] schemas = this.toArray(schemaNames);
        return false;
    }

    @Override
    public boolean loadWithDeps(Schema ... schemas) throws Exception {
        boolean loaded = false;
        if (this.errors != null) {
            this.errors.clear();
        }
        Registries clonedRegistries = this.cloneRegistries();
        clonedRegistries.setRelaxed();
        for (Schema schema : schemas) {
            this.loadDepsFirst(clonedRegistries, schema);
        }
        this.errors = clonedRegistries.buildReferences();
        if (this.errors.isEmpty()) {
            this.errors = clonedRegistries.checkRefInteg();
            if (this.errors.isEmpty()) {
                this.registries.setRelaxed();
                for (Schema schema : schemas) {
                    this.loadDepsFirst(this.registries, schema);
                }
                this.errors = this.registries.buildReferences();
                this.registries.setStrict();
                loaded = true;
            }
        }
        clonedRegistries.clear();
        return loaded;
    }

    @Override
    public boolean loadWithDeps(String ... schemas) throws Exception {
        return this.loadWithDeps(this.toArray(schemas));
    }

    private final void loadDepsFirst(Registries registries, Schema schema) throws Exception {
        if (schema == null) {
            LOG.info("The schema is null");
            return;
        }
        if (schema.isDisabled() && !registries.isDisabledAccepted()) {
            LOG.info("The schema is disabled and the registries does not accepted disabled schema");
            return;
        }
        String schemaName = schema.getSchemaName();
        if (registries.isSchemaLoaded(schemaName)) {
            LOG.info("{} schema has already been loaded" + schema.getSchemaName());
            return;
        }
        String[] deps = schema.getDependencies();
        if (deps == null || deps.length == 0) {
            this.load(registries, schema);
            return;
        }
        for (String depName : deps) {
            if (registries.isSchemaLoaded(schemaName)) continue;
            Schema schemaDep = this.schemaLoader.getSchema(depName);
            this.loadDepsFirst(registries, schemaDep);
        }
        this.load(registries, schema);
    }

    @Override
    public boolean loadWithDepsRelaxed(Schema ... schemas) throws Exception {
        return false;
    }

    @Override
    public boolean loadWithDepsRelaxed(String ... schemas) throws Exception {
        return false;
    }

    @Override
    public void setRegistries(Registries registries) {
    }

    @Override
    public boolean unload(Schema ... schemas) throws Exception {
        boolean unloaded = false;
        if (this.errors != null) {
            this.errors.clear();
        }
        Registries clonedRegistries = this.cloneRegistries();
        clonedRegistries.setRelaxed();
        for (Schema schema : schemas) {
            this.unload(clonedRegistries, schema);
        }
        this.errors = clonedRegistries.buildReferences();
        if (this.errors.isEmpty()) {
            this.errors = clonedRegistries.checkRefInteg();
            if (this.errors.isEmpty()) {
                this.registries.setRelaxed();
                for (Schema schema : schemas) {
                    this.unload(this.registries, schema);
                    for (String dep : schema.getDependencies()) {
                        Set<String> deps = this.schemaDependences.get(dep);
                        if (deps == null) continue;
                        deps.remove(schema.getSchemaName());
                    }
                    this.schemaLoader.removeSchema(schema);
                }
                this.errors = this.registries.buildReferences();
                this.registries.setStrict();
                unloaded = true;
            }
        }
        clonedRegistries.clear();
        return unloaded;
    }

    @Override
    public boolean unload(String ... schemaNames) throws Exception {
        Schema[] schemas = this.toArray(schemaNames);
        return this.unload(schemas);
    }

    @Override
    public boolean verify(Schema ... schemas) throws Exception {
        Registries clonedRegistries = this.cloneRegistries();
        for (Schema schema : schemas) {
            try {
                boolean loaded = this.load(clonedRegistries, schema);
                if (!loaded) {
                    clonedRegistries.clear();
                    return false;
                }
                List<Throwable> errors = clonedRegistries.checkRefInteg();
                if (errors.size() == 0) continue;
                clonedRegistries.clear();
                return false;
            }
            catch (Exception e) {
                clonedRegistries.clear();
                return false;
            }
        }
        clonedRegistries.clear();
        return true;
    }

    @Override
    public boolean verify(String ... schemas) throws Exception {
        return this.verify(this.toArray(schemas));
    }

    @Override
    public void setSchemaLoader(SchemaLoader schemaLoader) {
        this.schemaLoader = schemaLoader;
    }

    @Override
    public DN getNamingContext() {
        return this.namingContext;
    }

    @Override
    public void initialize() throws Exception {
        try {
            this.schemaModificationAttributesDN = new DN("cn=schemaModifications,ou=schema");
            this.schemaModificationAttributesDN.normalize(this.getRegistries().getAttributeTypeRegistry().getNormalizerMapping());
        }
        catch (LdapInvalidDnException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public SchemaLoader getLoader() {
        return this.schemaLoader;
    }

    @Override
    public AttributeTypeRegistry getAttributeTypeRegistry() {
        return new ImmutableAttributeTypeRegistry(this.registries.getAttributeTypeRegistry());
    }

    @Override
    public ComparatorRegistry getComparatorRegistry() {
        return new ImmutableComparatorRegistry(this.registries.getComparatorRegistry());
    }

    @Override
    public DITContentRuleRegistry getDITContentRuleRegistry() {
        return new ImmutableDITContentRuleRegistry(this.registries.getDitContentRuleRegistry());
    }

    @Override
    public DITStructureRuleRegistry getDITStructureRuleRegistry() {
        return new ImmutableDITStructureRuleRegistry(this.registries.getDitStructureRuleRegistry());
    }

    @Override
    public MatchingRuleRegistry getMatchingRuleRegistry() {
        return new ImmutableMatchingRuleRegistry(this.registries.getMatchingRuleRegistry());
    }

    @Override
    public MatchingRuleUseRegistry getMatchingRuleUseRegistry() {
        return new ImmutableMatchingRuleUseRegistry(this.registries.getMatchingRuleUseRegistry());
    }

    @Override
    public NameFormRegistry getNameFormRegistry() {
        return new ImmutableNameFormRegistry(this.registries.getNameFormRegistry());
    }

    @Override
    public NormalizerRegistry getNormalizerRegistry() {
        return new ImmutableNormalizerRegistry(this.registries.getNormalizerRegistry());
    }

    @Override
    public ObjectClassRegistry getObjectClassRegistry() {
        return new ImmutableObjectClassRegistry(this.registries.getObjectClassRegistry());
    }

    @Override
    public LdapSyntaxRegistry getLdapSyntaxRegistry() {
        return new ImmutableLdapSyntaxRegistry(this.registries.getLdapSyntaxRegistry());
    }

    @Override
    public SyntaxCheckerRegistry getSyntaxCheckerRegistry() {
        return new ImmutableSyntaxCheckerRegistry(this.registries.getSyntaxCheckerRegistry());
    }

    @Override
    public AttributeType lookupAttributeTypeRegistry(String oid) throws LdapException {
        return (AttributeType)this.registries.getAttributeTypeRegistry().lookup(StringTools.toLowerCase(oid).trim());
    }

    @Override
    public LdapComparator<?> lookupComparatorRegistry(String oid) throws LdapException {
        return (LdapComparator)this.registries.getComparatorRegistry().lookup(oid);
    }

    @Override
    public MatchingRule lookupMatchingRuleRegistry(String oid) throws LdapException {
        return (MatchingRule)this.registries.getMatchingRuleRegistry().lookup(StringTools.toLowerCase(oid).trim());
    }

    @Override
    public Normalizer lookupNormalizerRegistry(String oid) throws LdapException {
        return (Normalizer)this.registries.getNormalizerRegistry().lookup(oid);
    }

    @Override
    public ObjectClass lookupObjectClassRegistry(String oid) throws LdapException {
        return (ObjectClass)this.registries.getObjectClassRegistry().lookup(StringTools.toLowerCase(oid).trim());
    }

    @Override
    public LdapSyntax lookupLdapSyntaxRegistry(String oid) throws LdapException {
        return (LdapSyntax)this.registries.getLdapSyntaxRegistry().lookup(StringTools.toLowerCase(oid).trim());
    }

    @Override
    public SyntaxChecker lookupSyntaxCheckerRegistry(String oid) throws LdapException {
        return (SyntaxChecker)this.registries.getSyntaxCheckerRegistry().lookup(oid);
    }

    private boolean checkOidExist(SchemaObject schemaObject) {
        if (!(schemaObject instanceof LoadableSchemaObject)) {
            return this.registries.getGlobalOidRegistry().contains(schemaObject.getOid());
        }
        if (schemaObject instanceof LdapComparator) {
            return this.registries.getComparatorRegistry().contains(schemaObject.getOid());
        }
        if (schemaObject instanceof SyntaxChecker) {
            return this.registries.getSyntaxCheckerRegistry().contains(schemaObject.getOid());
        }
        if (schemaObject instanceof Normalizer) {
            return this.registries.getNormalizerRegistry().contains(schemaObject.getOid());
        }
        return false;
    }

    private SchemaObject getSchemaObject(SchemaObject schemaObject) throws LdapException {
        if (schemaObject instanceof LoadableSchemaObject) {
            return schemaObject;
        }
        return this.registries.getGlobalOidRegistry().getSchemaObject(schemaObject.getOid());
    }

    private String getSchemaName(SchemaObject schemaObject) {
        String schemaName = StringTools.toLowerCase(schemaObject.getSchemaName());
        if (StringTools.isEmpty(schemaName)) {
            return "other";
        }
        if (this.schemaLoader.getSchema(schemaName) == null) {
            return null;
        }
        return schemaName;
    }

    private SchemaObject copy(SchemaObject schemaObject) {
        SchemaObject copy = null;
        if (!(schemaObject instanceof LoadableSchemaObject)) {
            copy = schemaObject.copy();
        } else if (((LoadableSchemaObject)schemaObject).isValid()) {
            copy = schemaObject;
        } else {
            LdapUnwillingToPerformException error = new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, I18n.err("ERR_11007", schemaObject.getOid()));
            this.errors.add(error);
        }
        return copy;
    }

    @Override
    public boolean add(SchemaObject schemaObject) throws Exception {
        this.errors.clear();
        SchemaObject copy = this.copy(schemaObject);
        if (copy == null) {
            return false;
        }
        if (this.registries.isRelaxed()) {
            this.registries.add(this.errors, copy);
            return this.errors.isEmpty();
        }
        if (this.checkOidExist(copy)) {
            LdapProtocolErrorException error = new LdapProtocolErrorException(I18n.err("ERR_11008", schemaObject.getOid()));
            this.errors.add(error);
            return false;
        }
        String schemaName = this.getSchemaName(copy);
        if (schemaName == null) {
            LdapUnwillingToPerformException error = new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, I18n.err("ERR_11009", schemaObject.getOid(), copy.getSchemaName()));
            this.errors.add(error);
            return false;
        }
        Schema schema = this.getLoadedSchema(schemaName);
        if (schema == null) {
            String msg = I18n.err("ERR_11010", copy.getOid());
            LOG.info(msg);
            LdapProtocolErrorException error = new LdapProtocolErrorException(msg);
            this.errors.add(error);
            return false;
        }
        if (schema.isEnabled() && copy.isEnabled()) {
            Registries clonedRegistries = this.registries.clone();
            clonedRegistries.add(this.errors, copy);
            clonedRegistries.clear();
            if (this.errors.isEmpty()) {
                copy = this.copy(schemaObject);
                this.registries.add(this.errors, copy);
                LOG.debug("Added {} into the enabled schema {}", (Object)copy.getName(), (Object)schemaName);
                return true;
            }
            String msg = "Cannot add the SchemaObject " + copy.getOid() + " into the registries, " + "the resulting registries would be inconsistent :" + StringTools.listToString(this.errors);
            LOG.info(msg);
            return false;
        }
        this.registries.associateWithSchema(this.errors, copy);
        LOG.debug("Added {} into the disabled schema {}", (Object)copy.getName(), (Object)schemaName);
        return this.errors.isEmpty();
    }

    @Override
    public boolean delete(SchemaObject schemaObject) throws Exception {
        this.errors.clear();
        if (this.registries.isRelaxed()) {
            this.registries.delete(this.errors, schemaObject);
            return this.errors.isEmpty();
        }
        if (!this.checkOidExist(schemaObject)) {
            LdapProtocolErrorException error = new LdapProtocolErrorException(I18n.err("ERR_11011", schemaObject.getOid()));
            this.errors.add(error);
            return false;
        }
        SchemaObject toDelete = this.getSchemaObject(schemaObject);
        Set<SchemaObjectWrapper> referencing = this.registries.getReferencing(toDelete);
        if (referencing != null && !referencing.isEmpty()) {
            String msg = I18n.err("ERR_11012", schemaObject.getOid(), StringTools.setToString(referencing));
            LdapProtocolErrorException error = new LdapProtocolErrorException(msg);
            this.errors.add(error);
            return false;
        }
        String schemaName = this.getSchemaName(toDelete);
        Schema schema = this.getLoadedSchema(schemaName);
        if (schema == null) {
            String msg = I18n.err("ERR_11013", schemaObject.getOid());
            LOG.info(msg);
            LdapProtocolErrorException error = new LdapProtocolErrorException(msg);
            this.errors.add(error);
            return false;
        }
        if (schema.isEnabled() && schemaObject.isEnabled()) {
            Registries clonedRegistries = this.registries.clone();
            clonedRegistries.delete(this.errors, toDelete);
            clonedRegistries.clear();
            if (this.errors.isEmpty()) {
                this.registries.delete(this.errors, toDelete);
                LOG.debug("Removed {} from the enabled schema {}", (Object)toDelete.getName(), (Object)schemaName);
                return true;
            }
            String msg = "Cannot delete the SchemaObject " + schemaObject.getOid() + " from the registries, " + "the resulting registries would be inconsistent :" + StringTools.listToString(this.errors);
            LOG.info(msg);
            return false;
        }
        this.registries.associateWithSchema(this.errors, schemaObject);
        LOG.debug("Removed {} from the disabled schema {}", (Object)schemaObject.getName(), (Object)schemaName);
        return this.errors.isEmpty();
    }

    @Override
    public Map<String, OidNormalizer> getNormalizerMapping() {
        return this.registries.getAttributeTypeRegistry().getNormalizerMapping();
    }

    @Override
    public OidRegistry getGlobalOidRegistry() {
        return this.registries.getGlobalOidRegistry();
    }

    @Override
    public Schema getLoadedSchema(String schemaName) {
        return this.schemaLoader.getSchema(schemaName);
    }

    @Override
    public boolean isSchemaLoaded(String schemaName) {
        try {
            Schema schema = this.schemaLoader.getSchema(schemaName);
            return schema != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public SchemaObject unregisterAttributeType(String attributeTypeOid) throws LdapException {
        return this.registries.getAttributeTypeRegistry().unregister(attributeTypeOid);
    }

    @Override
    public SchemaObject unregisterComparator(String comparatorOid) throws LdapException {
        return this.registries.getComparatorRegistry().unregister(comparatorOid);
    }

    @Override
    public SchemaObject unregisterDitControlRule(String ditControlRuleOid) throws LdapException {
        return this.registries.getDitContentRuleRegistry().unregister(ditControlRuleOid);
    }

    @Override
    public SchemaObject unregisterDitStructureRule(String ditStructureRuleOid) throws LdapException {
        return this.registries.getDitStructureRuleRegistry().unregister(ditStructureRuleOid);
    }

    @Override
    public SchemaObject unregisterLdapSyntax(String ldapSyntaxOid) throws LdapException {
        return this.registries.getLdapSyntaxRegistry().unregister(ldapSyntaxOid);
    }

    @Override
    public SchemaObject unregisterMatchingRule(String matchingRuleOid) throws LdapException {
        return this.registries.getMatchingRuleRegistry().unregister(matchingRuleOid);
    }

    @Override
    public SchemaObject unregisterMatchingRuleUse(String matchingRuleUseOid) throws LdapException {
        return this.registries.getMatchingRuleUseRegistry().unregister(matchingRuleUseOid);
    }

    @Override
    public SchemaObject unregisterNameForm(String nameFormOid) throws LdapException {
        return this.registries.getNameFormRegistry().unregister(nameFormOid);
    }

    @Override
    public SchemaObject unregisterNormalizer(String normalizerOid) throws LdapException {
        return this.registries.getNormalizerRegistry().unregister(normalizerOid);
    }

    @Override
    public SchemaObject unregisterObjectClass(String objectClassOid) throws LdapException {
        return this.registries.getObjectClassRegistry().unregister(objectClassOid);
    }

    @Override
    public SchemaObject unregisterSyntaxChecker(String syntaxCheckerOid) throws LdapException {
        return this.registries.getSyntaxCheckerRegistry().unregister(syntaxCheckerOid);
    }

    public boolean isRelaxed() {
        return this.isRelaxed;
    }

    public boolean isStrict() {
        return !this.isRelaxed;
    }

    @Override
    public Set<String> listDependentSchemaNames(String schemaName) {
        return this.schemaDependences.get(schemaName);
    }

    public void setRelaxed() {
        this.isRelaxed = true;
    }

    public void setStrict() {
        this.isRelaxed = false;
    }

    @Override
    public boolean isDisabled(String schemaName) {
        Schema schema = this.registries.getLoadedSchema(schemaName);
        return schema != null && schema.isDisabled();
    }

    @Override
    public boolean isDisabled(Schema schema) {
        return schema != null && schema.isDisabled();
    }

    @Override
    public boolean isEnabled(String schemaName) {
        Schema schema = this.registries.getLoadedSchema(schemaName);
        return schema != null && schema.isEnabled();
    }

    @Override
    public boolean isEnabled(Schema schema) {
        return schema != null && schema.isEnabled();
    }
}

