/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm.search.impl;

import java.util.Iterator;
import java.util.regex.Pattern;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.Index;
import org.apache.directory.server.xdbm.IndexCursor;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.server.xdbm.Store;
import org.apache.directory.server.xdbm.search.Evaluator;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.ServerEntry;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.filter.SubstringNode;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.MatchingRule;
import org.apache.directory.shared.ldap.schema.Normalizer;
import org.apache.directory.shared.ldap.schema.SchemaManager;
import org.apache.directory.shared.ldap.schema.normalizers.NoOpNormalizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubstringEvaluator<ID>
implements Evaluator<SubstringNode, ServerEntry, ID> {
    private final Store<ServerEntry, ID> db;
    private final SchemaManager schemaManager;
    private final SubstringNode node;
    private final Pattern regex;
    private final AttributeType type;
    private final Normalizer normalizer;
    private final Index<String, ServerEntry, ID> idx;

    public SubstringEvaluator(SubstringNode node, Store<ServerEntry, ID> db, SchemaManager schemaManager) throws Exception {
        this.db = db;
        this.node = node;
        this.schemaManager = schemaManager;
        String oid = schemaManager.getAttributeTypeRegistry().getOidByName(node.getAttribute());
        this.type = schemaManager.lookupAttributeTypeRegistry(oid);
        MatchingRule rule = this.type.getSubstring();
        if (rule == null) {
            rule = this.type.getEquality();
        }
        this.normalizer = rule != null ? rule.getNormalizer() : new NoOpNormalizer(this.type.getSyntaxOid());
        this.regex = node.getRegex(this.normalizer);
        this.idx = db.hasIndexOn(node.getAttribute()) ? db.getIndex(node.getAttribute()) : null;
    }

    @Override
    public boolean evaluate(IndexEntry<?, ServerEntry, ID> indexEntry) throws Exception {
        if (this.idx == null) {
            return this.evaluateWithoutIndex(indexEntry);
        }
        return this.evaluateWithIndex((ID)indexEntry);
    }

    @Override
    public boolean evaluateId(ID id) throws Exception {
        if (this.idx == null) {
            return this.evaluateWithoutIndex(id);
        }
        return this.evaluateWithIndex(id);
    }

    @Override
    public boolean evaluateEntry(ServerEntry entry) throws Exception {
        if (this.idx == null) {
            return this.evaluateWithoutIndex(entry);
        }
        return this.evaluateWithIndex(entry);
    }

    public Pattern getPattern() {
        return this.regex;
    }

    @Override
    public SubstringNode getExpression() {
        return this.node;
    }

    private boolean evaluateWithIndex(IndexEntry<?, ServerEntry, ID> indexEntry) throws Exception {
        IndexCursor<String, ServerEntry, ID> entries = this.idx.reverseCursor(indexEntry.getId());
        while (entries.next()) {
            IndexEntry rec = (IndexEntry)entries.get();
            if (!this.regex.matcher((String)rec.getValue()).matches()) continue;
            entries.close();
            return true;
        }
        return false;
    }

    private boolean evaluateWithIndex(ServerEntry entry) throws Exception {
        throw new UnsupportedOperationException(I18n.err(I18n.ERR_721, new Object[0]));
    }

    private boolean evaluateWithIndex(ID id) throws Exception {
        IndexCursor<String, ServerEntry, ID> entries = this.idx.reverseCursor(id);
        while (entries.next()) {
            IndexEntry rec = (IndexEntry)entries.get();
            if (!this.regex.matcher((String)rec.getValue()).matches()) continue;
            entries.close();
            return true;
        }
        return false;
    }

    private boolean evaluateWithoutIndex(ID id) throws Exception {
        return this.evaluateWithoutIndex(this.db.lookup(id));
    }

    private boolean evaluateWithoutIndex(ServerEntry entry) throws Exception {
        EntryAttribute attr = entry.get(this.type);
        if (attr != null) {
            for (Value value : attr) {
                value.normalize(this.normalizer);
                String strValue = (String)value.getNormalizedValue();
                if (!this.regex.matcher(strValue).matches()) continue;
                return true;
            }
        }
        if (this.schemaManager.getAttributeTypeRegistry().hasDescendants(this.node.getAttribute())) {
            Iterator<AttributeType> descendants = this.schemaManager.getAttributeTypeRegistry().descendants(this.node.getAttribute());
            while (descendants.hasNext()) {
                AttributeType descendant = descendants.next();
                attr = entry.get(descendant);
                if (null == attr) continue;
                for (Value value : attr) {
                    value.normalize(this.normalizer);
                    String strValue = (String)value.getNormalizedValue();
                    if (!this.regex.matcher(strValue).matches()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean evaluateWithoutIndex(IndexEntry<String, ServerEntry, ID> indexEntry) throws Exception {
        EntryAttribute attr;
        ServerEntry entry = indexEntry.getObject();
        if (null == entry) {
            entry = this.db.lookup(indexEntry.getId());
            indexEntry.setObject(entry);
        }
        if ((attr = entry.get(this.type)) != null) {
            for (Value value : attr) {
                value.normalize(this.normalizer);
                String strValue = (String)value.getNormalizedValue();
                if (!this.regex.matcher(strValue).matches()) continue;
                indexEntry.setValue(strValue);
                return true;
            }
        }
        if (this.schemaManager.getAttributeTypeRegistry().hasDescendants(this.node.getAttribute())) {
            Iterator<AttributeType> descendants = this.schemaManager.getAttributeTypeRegistry().descendants(this.node.getAttribute());
            while (descendants.hasNext()) {
                AttributeType descendant = descendants.next();
                attr = entry.get(descendant);
                if (null == attr) continue;
                for (Value value : attr) {
                    value.normalize(this.normalizer);
                    String strValue = (String)value.getNormalizedValue();
                    if (!this.regex.matcher(strValue).matches()) continue;
                    indexEntry.setValue(strValue);
                    return true;
                }
            }
        }
        return false;
    }
}

