/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.changepw.service;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.naming.NamingException;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.directory.server.changepw.ChangePasswordServer;
import org.apache.directory.server.changepw.exceptions.ChangePasswordException;
import org.apache.directory.server.changepw.exceptions.ErrorType;
import org.apache.directory.server.changepw.io.ChangePasswordDataDecoder;
import org.apache.directory.server.changepw.messages.ChangePasswordReply;
import org.apache.directory.server.changepw.messages.ChangePasswordReplyModifier;
import org.apache.directory.server.changepw.messages.ChangePasswordRequest;
import org.apache.directory.server.changepw.service.ChangePasswordContext;
import org.apache.directory.server.changepw.value.ChangePasswordData;
import org.apache.directory.server.changepw.value.ChangePasswordDataModifier;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.kerberos.shared.KerberosUtils;
import org.apache.directory.server.kerberos.shared.crypto.encryption.CipherTextHandler;
import org.apache.directory.server.kerberos.shared.crypto.encryption.EncryptionType;
import org.apache.directory.server.kerberos.shared.crypto.encryption.KeyUsage;
import org.apache.directory.server.kerberos.shared.exceptions.KerberosException;
import org.apache.directory.server.kerberos.shared.messages.ApplicationRequest;
import org.apache.directory.server.kerberos.shared.messages.application.ApplicationReply;
import org.apache.directory.server.kerberos.shared.messages.application.PrivateMessage;
import org.apache.directory.server.kerberos.shared.messages.components.Authenticator;
import org.apache.directory.server.kerberos.shared.messages.components.EncApRepPart;
import org.apache.directory.server.kerberos.shared.messages.components.EncApRepPartModifier;
import org.apache.directory.server.kerberos.shared.messages.components.EncKrbPrivPart;
import org.apache.directory.server.kerberos.shared.messages.components.EncKrbPrivPartModifier;
import org.apache.directory.server.kerberos.shared.messages.components.Ticket;
import org.apache.directory.server.kerberos.shared.messages.value.EncryptedData;
import org.apache.directory.server.kerberos.shared.messages.value.EncryptionKey;
import org.apache.directory.server.kerberos.shared.messages.value.HostAddress;
import org.apache.directory.server.kerberos.shared.messages.value.HostAddresses;
import org.apache.directory.server.kerberos.shared.replay.InMemoryReplayCache;
import org.apache.directory.server.kerberos.shared.replay.ReplayCache;
import org.apache.directory.server.kerberos.shared.store.PrincipalStore;
import org.apache.directory.server.kerberos.shared.store.PrincipalStoreEntry;
import org.apache.mina.core.session.IoSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangePasswordService {
    private static final Logger LOG = LoggerFactory.getLogger(ChangePasswordService.class);
    private static final ReplayCache replayCache = new InMemoryReplayCache();
    private static final CipherTextHandler cipherTextHandler = new CipherTextHandler();

    public static void execute(IoSession session, ChangePasswordContext changepwContext) throws KerberosException, IOException {
        if (LOG.isDebugEnabled()) {
            ChangePasswordService.monitorRequest(changepwContext);
        }
        ChangePasswordService.configureChangePassword(changepwContext);
        ChangePasswordService.getAuthHeader(session, changepwContext);
        ChangePasswordService.verifyServiceTicket(changepwContext);
        ChangePasswordService.getServerEntry(changepwContext);
        ChangePasswordService.verifyServiceTicketAuthHeader(changepwContext);
        ChangePasswordService.extractPassword(changepwContext);
        if (LOG.isDebugEnabled()) {
            ChangePasswordService.monitorContext(changepwContext);
        }
        ChangePasswordService.processPasswordChange(changepwContext);
        ChangePasswordService.buildReply(changepwContext);
        if (LOG.isDebugEnabled()) {
            ChangePasswordService.monitorReply(changepwContext);
        }
    }

    private static void processPasswordChange(ChangePasswordContext changepwContext) throws KerberosException {
        PrincipalStore store = changepwContext.getStore();
        Authenticator authenticator = changepwContext.getAuthenticator();
        String newPassword = changepwContext.getPassword();
        KerberosPrincipal clientPrincipal = authenticator.getClientPrincipal();
        try {
            String principalName = store.changePassword(clientPrincipal, newPassword);
            LOG.debug("Successfully modified principal {}.", (Object)principalName);
        }
        catch (NamingException ne) {
            throw new ChangePasswordException(ErrorType.KRB5_KPASSWD_SOFTERROR, ne.getExplanation().getBytes(), (Throwable)ne);
        }
        catch (Exception e) {
            throw new ChangePasswordException(ErrorType.KRB5_KPASSWD_HARDERROR, (Throwable)e);
        }
    }

    private static void monitorRequest(ChangePasswordContext changepwContext) throws KerberosException {
        try {
            ChangePasswordRequest request = (ChangePasswordRequest)changepwContext.getRequest();
            short versionNumber = request.getVersionNumber();
            StringBuffer sb = new StringBuffer();
            sb.append("Responding to change password request:");
            sb.append("\n\tversionNumber    " + versionNumber);
            LOG.debug(sb.toString());
        }
        catch (Exception e) {
            LOG.error(I18n.err(I18n.ERR_152, new Object[0]), (Throwable)e);
        }
    }

    private static void configureChangePassword(ChangePasswordContext changepwContext) {
        changepwContext.setReplayCache(replayCache);
        changepwContext.setCipherTextHandler(cipherTextHandler);
    }

    private static void getAuthHeader(IoSession session, ChangePasswordContext changepwContext) throws KerberosException {
        ChangePasswordRequest request = (ChangePasswordRequest)changepwContext.getRequest();
        if (request.getVersionNumber() != 1) {
            throw new ChangePasswordException(ErrorType.KRB5_KPASSWD_BAD_VERSION);
        }
        if (request.getAuthHeader() == null || request.getAuthHeader().getTicket() == null) {
            throw new ChangePasswordException(ErrorType.KRB5_KPASSWD_AUTHERROR);
        }
        ApplicationRequest authHeader = request.getAuthHeader();
        Ticket ticket = authHeader.getTicket();
        changepwContext.setAuthHeader(authHeader);
        changepwContext.setTicket(ticket);
    }

    private static void verifyServiceTicket(ChangePasswordContext changepwContext) throws KerberosException {
        ChangePasswordServer config = changepwContext.getConfig();
        Ticket ticket = changepwContext.getTicket();
        String primaryRealm = config.getPrimaryRealm();
        KerberosPrincipal changepwPrincipal = config.getServicePrincipal();
        KerberosPrincipal serverPrincipal = ticket.getServerPrincipal();
        if (!ticket.getRealm().equals(primaryRealm) || !serverPrincipal.equals(changepwPrincipal)) {
            throw new KerberosException(org.apache.directory.server.kerberos.shared.exceptions.ErrorType.KRB_AP_ERR_NOT_US);
        }
    }

    private static void getServerEntry(ChangePasswordContext changepwContext) throws KerberosException {
        KerberosPrincipal principal = changepwContext.getTicket().getServerPrincipal();
        PrincipalStore store = changepwContext.getStore();
        changepwContext.setServerEntry(KerberosUtils.getEntry(principal, store, org.apache.directory.server.kerberos.shared.exceptions.ErrorType.KDC_ERR_S_PRINCIPAL_UNKNOWN));
    }

    private static void verifyServiceTicketAuthHeader(ChangePasswordContext changepwContext) throws KerberosException {
        ApplicationRequest authHeader = changepwContext.getAuthHeader();
        Ticket ticket = changepwContext.getTicket();
        EncryptionType encryptionType = ticket.getEncPart().getEType();
        EncryptionKey serverKey = changepwContext.getServerEntry().getKeyMap().get((Object)encryptionType);
        long clockSkew = changepwContext.getConfig().getAllowableClockSkew();
        ReplayCache replayCache = changepwContext.getReplayCache();
        boolean emptyAddressesAllowed = changepwContext.getConfig().isEmptyAddressesAllowed();
        InetAddress clientAddress = changepwContext.getClientAddress();
        CipherTextHandler cipherTextHandler = changepwContext.getCipherTextHandler();
        Authenticator authenticator = KerberosUtils.verifyAuthHeader(authHeader, ticket, serverKey, clockSkew, replayCache, emptyAddressesAllowed, clientAddress, cipherTextHandler, KeyUsage.NUMBER11, false);
        ChangePasswordRequest request = (ChangePasswordRequest)changepwContext.getRequest();
        if (request.getVersionNumber() == 1 && !ticket.getEncTicketPart().getFlags().isInitial()) {
            throw new ChangePasswordException(ErrorType.KRB5_KPASSWD_INITIAL_FLAG_NEEDED);
        }
        changepwContext.setAuthenticator(authenticator);
    }

    private static void extractPassword(ChangePasswordContext changepwContext) throws KerberosException, IOException {
        EncKrbPrivPart privatePart;
        ChangePasswordRequest request = (ChangePasswordRequest)changepwContext.getRequest();
        Authenticator authenticator = changepwContext.getAuthenticator();
        CipherTextHandler cipherTextHandler = changepwContext.getCipherTextHandler();
        EncryptionKey subSessionKey = authenticator.getSubSessionKey();
        EncryptedData encReqPrivPart = request.getPrivateMessage().getEncryptedPart();
        try {
            privatePart = (EncKrbPrivPart)cipherTextHandler.unseal(EncKrbPrivPart.class, subSessionKey, encReqPrivPart, KeyUsage.NUMBER13);
        }
        catch (KerberosException ke) {
            throw new ChangePasswordException(ErrorType.KRB5_KPASSWD_SOFTERROR, (Throwable)ke);
        }
        ChangePasswordData passwordData = null;
        if (request.getVersionNumber() == 1) {
            ChangePasswordDataModifier modifier = new ChangePasswordDataModifier();
            modifier.setNewPassword(privatePart.getUserData());
            passwordData = modifier.getChangePasswdData();
        } else {
            ChangePasswordDataDecoder passwordDecoder = new ChangePasswordDataDecoder();
            passwordData = passwordDecoder.decodeChangePasswordData(privatePart.getUserData());
        }
        try {
            changepwContext.setPassword(new String(passwordData.getPassword(), "UTF-8"));
        }
        catch (UnsupportedEncodingException uee) {
            throw new ChangePasswordException(ErrorType.KRB5_KPASSWD_SOFTERROR, (Throwable)uee);
        }
    }

    private static void monitorContext(ChangePasswordContext changepwContext) throws KerberosException {
        try {
            PrincipalStore store = changepwContext.getStore();
            ApplicationRequest authHeader = changepwContext.getAuthHeader();
            Ticket ticket = changepwContext.getTicket();
            ReplayCache replayCache = changepwContext.getReplayCache();
            long clockSkew = changepwContext.getConfig().getAllowableClockSkew();
            Authenticator authenticator = changepwContext.getAuthenticator();
            KerberosPrincipal clientPrincipal = authenticator.getClientPrincipal();
            String desiredPassword = changepwContext.getPassword();
            InetAddress clientAddress = changepwContext.getClientAddress();
            HostAddresses clientAddresses = ticket.getEncTicketPart().getClientAddresses();
            boolean caddrContainsSender = false;
            if (ticket.getEncTicketPart().getClientAddresses() != null) {
                caddrContainsSender = ticket.getEncTicketPart().getClientAddresses().contains(new HostAddress(clientAddress));
            }
            StringBuffer sb = new StringBuffer();
            sb.append("Monitoring context:");
            sb.append("\n\tstore                  " + store);
            sb.append("\n\tauthHeader             " + authHeader);
            sb.append("\n\tticket                 " + ticket);
            sb.append("\n\treplayCache            " + replayCache);
            sb.append("\n\tclockSkew              " + clockSkew);
            sb.append("\n\tclientPrincipal        " + clientPrincipal);
            sb.append("\n\tdesiredPassword        " + desiredPassword);
            sb.append("\n\tclientAddress          " + clientAddress);
            sb.append("\n\tclientAddresses        " + clientAddresses);
            sb.append("\n\tcaddr contains sender  " + caddrContainsSender);
            sb.append("\n\tTicket principal       " + ticket.getServerPrincipal());
            PrincipalStoreEntry ticketPrincipal = changepwContext.getServerEntry();
            sb.append("\n\tcn                     " + ticketPrincipal.getCommonName());
            sb.append("\n\trealm                  " + ticketPrincipal.getRealmName());
            sb.append("\n\tService principal      " + ticketPrincipal.getPrincipal());
            sb.append("\n\tSAM type               " + ticketPrincipal.getSamType());
            EncryptionType encryptionType = ticket.getEncPart().getEType();
            int keyVersion = ticketPrincipal.getKeyMap().get((Object)encryptionType).getKeyVersion();
            sb.append("\n\tTicket key type        " + (Object)((Object)encryptionType));
            sb.append("\n\tService key version    " + keyVersion);
            LOG.debug(sb.toString());
        }
        catch (Exception e) {
            LOG.error(I18n.err(I18n.ERR_154, new Object[0]), (Throwable)e);
        }
    }

    private static void buildReply(ChangePasswordContext changepwContext) throws KerberosException, UnknownHostException {
        EncryptedData encRepPart;
        EncryptedData encPrivPart;
        Authenticator authenticator = changepwContext.getAuthenticator();
        Ticket ticket = changepwContext.getTicket();
        CipherTextHandler cipherTextHandler = changepwContext.getCipherTextHandler();
        EncKrbPrivPartModifier modifier = new EncKrbPrivPartModifier();
        byte[] resultCode = new byte[]{0, 0};
        modifier.setUserData(resultCode);
        modifier.setSenderAddress(new HostAddress(InetAddress.getLocalHost()));
        EncKrbPrivPart privPart = modifier.getEncKrbPrivPart();
        EncryptionKey subSessionKey = authenticator.getSubSessionKey();
        try {
            encPrivPart = cipherTextHandler.seal(subSessionKey, privPart, KeyUsage.NUMBER13);
        }
        catch (KerberosException ke) {
            throw new ChangePasswordException(ErrorType.KRB5_KPASSWD_SOFTERROR, (Throwable)ke);
        }
        PrivateMessage privateMessage = new PrivateMessage(encPrivPart);
        EncApRepPartModifier encApModifier = new EncApRepPartModifier();
        encApModifier.setClientTime(authenticator.getClientTime());
        encApModifier.setClientMicroSecond(authenticator.getClientMicroSecond());
        encApModifier.setSequenceNumber(new Integer(authenticator.getSequenceNumber()));
        encApModifier.setSubSessionKey(authenticator.getSubSessionKey());
        EncApRepPart repPart = encApModifier.getEncApRepPart();
        try {
            encRepPart = cipherTextHandler.seal(ticket.getEncTicketPart().getSessionKey(), repPart, KeyUsage.NUMBER12);
        }
        catch (KerberosException ke) {
            throw new ChangePasswordException(ErrorType.KRB5_KPASSWD_SOFTERROR, (Throwable)ke);
        }
        ApplicationReply appReply = new ApplicationReply(encRepPart);
        ChangePasswordReplyModifier replyModifier = new ChangePasswordReplyModifier();
        replyModifier.setApplicationReply(appReply);
        replyModifier.setPrivateMessage(privateMessage);
        changepwContext.setReply(replyModifier.getChangePasswordReply());
    }

    private static void monitorReply(ChangePasswordContext changepwContext) throws KerberosException {
        try {
            ChangePasswordReply reply = (ChangePasswordReply)changepwContext.getReply();
            ApplicationReply appReply = reply.getApplicationReply();
            PrivateMessage priv = reply.getPrivateMessage();
            StringBuilder sb = new StringBuilder();
            sb.append("Responding with change password reply:");
            sb.append("\n\tappReply               " + appReply);
            sb.append("\n\tpriv                   " + priv);
            LOG.debug(sb.toString());
        }
        catch (Exception e) {
            LOG.error(I18n.err(I18n.ERR_155, new Object[0]), (Throwable)e);
        }
    }
}

