/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.schema.comparators;

import java.io.IOException;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.schema.LdapComparator;
import org.apache.directory.shared.ldap.schema.PrepareString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumericStringComparator
extends LdapComparator<String> {
    private static final Logger LOG = LoggerFactory.getLogger(NumericStringComparator.class);
    private static final long serialVersionUID = 1L;

    public NumericStringComparator(String oid) {
        super(oid);
    }

    @Override
    public int compare(String backendValue, String assertValue) {
        LOG.debug("comparing numericStringOrdering objects '{}' with '{}'", (Object)backendValue, (Object)assertValue);
        if (backendValue == assertValue) {
            return 0;
        }
        if (backendValue == null || assertValue == null) {
            return backendValue == null ? -1 : 1;
        }
        try {
            backendValue = PrepareString.normalize(backendValue, PrepareString.StringType.NUMERIC_STRING);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(I18n.err("ERR_04224", backendValue));
        }
        try {
            assertValue = PrepareString.normalize(assertValue, PrepareString.StringType.NUMERIC_STRING);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(I18n.err("ERR_04224", assertValue));
        }
        return backendValue.compareTo(assertValue);
    }
}

