/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.compare;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.codec.EncoderException;
import org.apache.directory.shared.ldap.codec.LdapResponseCodec;
import org.apache.directory.shared.ldap.codec.MessageTypeEnum;

public class CompareResponseCodec
extends LdapResponseCodec {
    protected int computeLengthProtocolOp() {
        int ldapResultLength = super.computeLdapResultLength();
        return 1 + TLV.getNbBytes(ldapResultLength) + ldapResultLength;
    }

    protected void encodeProtocolOp(ByteBuffer buffer) throws EncoderException {
        try {
            buffer.put((byte)111);
            buffer.put(TLV.getBytes(this.getLdapResponseLength()));
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException("The PDU buffer size is too small !");
        }
        super.encode(buffer);
    }

    public MessageTypeEnum getMessageType() {
        return MessageTypeEnum.COMPARE_RESPONSE;
    }

    public String getMessageTypeName() {
        return "COMPARE_RESPONSE";
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("    Compare Response\n");
        sb.append(super.toString());
        return sb.toString();
    }
}

