/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.dsmlv2.reponse;

import org.apache.directory.shared.asn1.primitives.OID;
import org.apache.directory.shared.dsmlv2.DsmlDecorator;
import org.apache.directory.shared.dsmlv2.ParserUtils;
import org.apache.directory.shared.dsmlv2.reponse.LdapResponseDecorator;
import org.apache.directory.shared.dsmlv2.reponse.LdapResultDsml;
import org.apache.directory.shared.ldap.codec.MessageTypeEnum;
import org.apache.directory.shared.ldap.codec.extended.ExtendedResponseCodec;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class ExtendedResponseDsml
extends LdapResponseDecorator
implements DsmlDecorator {
    public ExtendedResponseDsml() {
        super(new ExtendedResponseCodec());
    }

    public ExtendedResponseDsml(ExtendedResponseCodec ldapMessage) {
        super(ldapMessage);
    }

    public MessageTypeEnum getMessageType() {
        return this.instance.getMessageType();
    }

    public Element toDsml(Element root) {
        Object response;
        Element element = root.addElement("extendedResponse");
        ExtendedResponseCodec extendedResponse = (ExtendedResponseCodec)this.instance;
        LdapResultDsml ldapResultDsml = new LdapResultDsml(extendedResponse.getLdapResult(), this.instance);
        ldapResultDsml.toDsml(element);
        String responseName = extendedResponse.getResponseName();
        if (responseName != null) {
            element.addElement("responseName").addText(responseName);
        }
        if ((response = extendedResponse.getResponse()) != null) {
            if (ParserUtils.needsBase64Encoding(response)) {
                Namespace xsdNamespace = new Namespace("xsd", "http://www.w3c.org/2001/XMLSchema");
                Namespace xsiNamespace = new Namespace("xsi", "http://www.w3c.org/2001/XMLSchema-instance");
                element.getDocument().getRootElement().add(xsdNamespace);
                element.getDocument().getRootElement().add(xsiNamespace);
                Element responseElement = element.addElement("response").addText(ParserUtils.base64Encode(response));
                responseElement.addAttribute(new QName("type", xsiNamespace), "xsd:base64Binary");
            } else {
                element.addElement("response").addText(response.toString());
            }
        }
        return element;
    }

    public String getResponseName() {
        return ((ExtendedResponseCodec)this.instance).getResponseName();
    }

    public void setResponseName(OID responseName) {
        ((ExtendedResponseCodec)this.instance).setResponseName(responseName);
    }

    public Object getResponse() {
        return ((ExtendedResponseCodec)this.instance).getResponse();
    }

    public void setResponse(Object response) {
        ((ExtendedResponseCodec)this.instance).setResponse(response);
    }
}

