/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.jndi;

import javax.naming.AuthenticationException;
import javax.naming.AuthenticationNotSupportedException;
import javax.naming.CommunicationException;
import javax.naming.ContextNotEmptyException;
import javax.naming.InvalidNameException;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.NoPermissionException;
import javax.naming.OperationNotSupportedException;
import javax.naming.ServiceUnavailableException;
import javax.naming.TimeLimitExceededException;
import javax.naming.directory.AttributeInUseException;
import javax.naming.directory.InvalidAttributeIdentifierException;
import javax.naming.directory.InvalidAttributeValueException;
import javax.naming.directory.InvalidSearchFilterException;
import javax.naming.directory.NoSuchAttributeException;
import javax.naming.directory.SchemaViolationException;
import javax.naming.ldap.BasicControl;
import org.apache.directory.shared.ldap.codec.controls.ControlImpl;
import org.apache.directory.shared.ldap.exception.LdapAffectMultipleDsaException;
import org.apache.directory.shared.ldap.exception.LdapAliasDereferencingException;
import org.apache.directory.shared.ldap.exception.LdapAliasException;
import org.apache.directory.shared.ldap.exception.LdapAttributeInUseException;
import org.apache.directory.shared.ldap.exception.LdapAuthenticationException;
import org.apache.directory.shared.ldap.exception.LdapAuthenticationNotSupportedException;
import org.apache.directory.shared.ldap.exception.LdapContextNotEmptyException;
import org.apache.directory.shared.ldap.exception.LdapEntryAlreadyExistsException;
import org.apache.directory.shared.ldap.exception.LdapInvalidAttributeTypeException;
import org.apache.directory.shared.ldap.exception.LdapInvalidAttributeValueException;
import org.apache.directory.shared.ldap.exception.LdapInvalidDnException;
import org.apache.directory.shared.ldap.exception.LdapInvalidSearchFilterException;
import org.apache.directory.shared.ldap.exception.LdapLoopDetectedException;
import org.apache.directory.shared.ldap.exception.LdapNoPermissionException;
import org.apache.directory.shared.ldap.exception.LdapNoSuchAttributeException;
import org.apache.directory.shared.ldap.exception.LdapNoSuchObjectException;
import org.apache.directory.shared.ldap.exception.LdapOperationErrorException;
import org.apache.directory.shared.ldap.exception.LdapOtherException;
import org.apache.directory.shared.ldap.exception.LdapPartialResultException;
import org.apache.directory.shared.ldap.exception.LdapProtocolErrorException;
import org.apache.directory.shared.ldap.exception.LdapReferralException;
import org.apache.directory.shared.ldap.exception.LdapSchemaViolationException;
import org.apache.directory.shared.ldap.exception.LdapServiceUnavailableException;
import org.apache.directory.shared.ldap.exception.LdapTimeLimitExceededException;
import org.apache.directory.shared.ldap.exception.LdapUnwillingToPerformException;
import org.apache.directory.shared.ldap.jndi.WrappedPartialResultException;
import org.apache.directory.shared.ldap.jndi.WrappedReferralException;
import org.apache.directory.shared.ldap.message.control.Control;

public class JndiUtils {
    public static javax.naming.ldap.Control toJndiControl(Control control) {
        byte[] value = control.getValue();
        BasicControl jndiControl = new BasicControl(control.getOid(), control.isCritical(), value);
        return jndiControl;
    }

    public static javax.naming.ldap.Control[] toJndiControls(Control ... controls) {
        if (controls != null) {
            javax.naming.ldap.Control[] jndiControls = new javax.naming.ldap.Control[controls.length];
            int i = 0;
            for (Control control : controls) {
                jndiControls[i++] = JndiUtils.toJndiControl(control);
            }
            return jndiControls;
        }
        return null;
    }

    public static Control fromJndiControl(javax.naming.ldap.Control jndiControl) {
        ControlImpl control = new ControlImpl(jndiControl.getID());
        control.setValue(jndiControl.getEncodedValue());
        return control;
    }

    public static Control[] fromJndiControls(javax.naming.ldap.Control ... jndiControls) {
        if (jndiControls != null) {
            Control[] controls = new Control[jndiControls.length];
            int i = 0;
            for (javax.naming.ldap.Control jndiControl : jndiControls) {
                controls[i++] = JndiUtils.fromJndiControl(jndiControl);
            }
            return controls;
        }
        return null;
    }

    public static void wrap(Throwable t) throws NamingException {
        if (t instanceof NamingException) {
            throw (NamingException)t;
        }
        NamingException ne = null;
        ne = t instanceof LdapAffectMultipleDsaException ? new NamingException(t.getLocalizedMessage()) : (t instanceof LdapAliasDereferencingException ? new NamingException(t.getLocalizedMessage()) : (t instanceof LdapAliasException ? new NamingException(t.getLocalizedMessage()) : (t instanceof LdapAttributeInUseException ? new AttributeInUseException(t.getLocalizedMessage()) : (t instanceof LdapAuthenticationException ? new AuthenticationException(t.getLocalizedMessage()) : (t instanceof LdapAuthenticationNotSupportedException ? new AuthenticationNotSupportedException(t.getLocalizedMessage()) : (t instanceof LdapContextNotEmptyException ? new ContextNotEmptyException(t.getLocalizedMessage()) : (t instanceof LdapEntryAlreadyExistsException ? new NameAlreadyBoundException(t.getLocalizedMessage()) : (t instanceof LdapInvalidAttributeTypeException ? new InvalidAttributeIdentifierException(t.getLocalizedMessage()) : (t instanceof LdapInvalidAttributeValueException ? new InvalidAttributeValueException(t.getLocalizedMessage()) : (t instanceof LdapInvalidDnException ? new InvalidNameException(t.getLocalizedMessage()) : (t instanceof LdapInvalidSearchFilterException ? new InvalidSearchFilterException(t.getLocalizedMessage()) : (t instanceof LdapLoopDetectedException ? new NamingException(t.getLocalizedMessage()) : (t instanceof LdapNoPermissionException ? new NoPermissionException(t.getLocalizedMessage()) : (t instanceof LdapNoSuchAttributeException ? new NoSuchAttributeException(t.getLocalizedMessage()) : (t instanceof LdapNoSuchObjectException ? new NameNotFoundException(t.getLocalizedMessage()) : (t instanceof LdapOperationErrorException ? new NamingException(t.getLocalizedMessage()) : (t instanceof LdapOtherException ? new NamingException(t.getLocalizedMessage()) : (t instanceof LdapProtocolErrorException ? new CommunicationException(t.getLocalizedMessage()) : (t instanceof LdapReferralException ? new WrappedReferralException((LdapReferralException)t) : (t instanceof LdapPartialResultException ? new WrappedPartialResultException((LdapPartialResultException)t) : (t instanceof LdapSchemaViolationException ? new SchemaViolationException(t.getLocalizedMessage()) : (t instanceof LdapServiceUnavailableException ? new ServiceUnavailableException(t.getLocalizedMessage()) : (t instanceof LdapTimeLimitExceededException ? new TimeLimitExceededException(t.getLocalizedMessage()) : (t instanceof LdapUnwillingToPerformException ? new OperationNotSupportedException(t.getLocalizedMessage()) : new NamingException(t.getLocalizedMessage())))))))))))))))))))))))));
        ne.setRootCause(t);
        throw ne;
    }
}

