/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.crypto.encryption;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum EncryptionType {
    UNKNOWN(-1),
    NULL(0),
    DES_CBC_CRC(1),
    DES_CBC_MD4(2),
    DES_CBC_MD5(3),
    RESERVED4(4),
    DES3_CBC_MD5(5),
    RESERVED6(6),
    DES3_CBC_SHA1(7),
    DSAWITHSHA1_CMSOID(9),
    MD5WITHRSAENCRYPTION_CMSOID(10),
    SHA1WITHRSAENCRYPTION_CMSOID(11),
    RC2CBC_ENVOID(12),
    RSAENCRYPTION_ENVOID(13),
    RSAES_OAEP_ENV_OID(14),
    DES_EDE3_CBC_ENV_OID(15),
    DES3_CBC_SHA1_KD(16),
    AES128_CTS_HMAC_SHA1_96(17),
    AES256_CTS_HMAC_SHA1_96(18),
    RC4_HMAC(23),
    RC4_HMAC_EXP(24),
    SUBKEY_KEYMATERIAL(65),
    RC4_MD4(-128),
    RC4_HMAC_OLD(-133),
    RC4_HMAC_OLD_EXP(-135);

    private final int ordinal;
    private static Map<String, EncryptionType> encryptionTypes;

    private EncryptionType(int ordinal) {
        this.ordinal = ordinal;
    }

    public static Collection<EncryptionType> getEncryptionTypes() {
        return encryptionTypes.values();
    }

    public static EncryptionType getTypeByOrdinal(int type) {
        switch (type) {
            case 0: {
                return NULL;
            }
            case 1: {
                return DES_CBC_CRC;
            }
            case 2: {
                return DES_CBC_MD4;
            }
            case 3: {
                return DES_CBC_MD5;
            }
            case 4: {
                return RESERVED4;
            }
            case 5: {
                return DES3_CBC_MD5;
            }
            case 6: {
                return RESERVED6;
            }
            case 7: {
                return DES3_CBC_SHA1;
            }
            case 9: {
                return DSAWITHSHA1_CMSOID;
            }
            case 10: {
                return MD5WITHRSAENCRYPTION_CMSOID;
            }
            case 11: {
                return SHA1WITHRSAENCRYPTION_CMSOID;
            }
            case 12: {
                return RC2CBC_ENVOID;
            }
            case 13: {
                return RSAENCRYPTION_ENVOID;
            }
            case 14: {
                return RSAES_OAEP_ENV_OID;
            }
            case 15: {
                return DES_EDE3_CBC_ENV_OID;
            }
            case 16: {
                return DES3_CBC_SHA1_KD;
            }
            case 17: {
                return AES128_CTS_HMAC_SHA1_96;
            }
            case 18: {
                return AES256_CTS_HMAC_SHA1_96;
            }
            case 23: {
                return RC4_HMAC;
            }
            case 24: {
                return RC4_HMAC_EXP;
            }
            case 65: {
                return SUBKEY_KEYMATERIAL;
            }
            case -128: {
                return RC4_MD4;
            }
            case -133: {
                return RC4_HMAC_OLD;
            }
            case -135: {
                return RC4_HMAC_OLD_EXP;
            }
        }
        return UNKNOWN;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public String getName() {
        switch (this) {
            case NULL: {
                return "NULL";
            }
            case DES_CBC_CRC: {
                return "des-cbc-crc";
            }
            case DES_CBC_MD4: {
                return "des-cbc-md4";
            }
            case DES_CBC_MD5: {
                return "des-cbc-md5";
            }
            case RESERVED4: {
                return "[reserved]";
            }
            case DES3_CBC_MD5: {
                return "des3-cbc-md5";
            }
            case RESERVED6: {
                return "[reserved]";
            }
            case DES3_CBC_SHA1: {
                return "des3-cbc-sha1";
            }
            case DSAWITHSHA1_CMSOID: {
                return "dsaWithSHA1-CmsOID";
            }
            case MD5WITHRSAENCRYPTION_CMSOID: {
                return "md5WithRSAEncryption-CmsOID";
            }
            case SHA1WITHRSAENCRYPTION_CMSOID: {
                return "sha1WithRSAEncryption-CmsOID";
            }
            case RC2CBC_ENVOID: {
                return "rc2CBC-EnvOID";
            }
            case RSAENCRYPTION_ENVOID: {
                return "rsaEncryption-EnvOID";
            }
            case RSAES_OAEP_ENV_OID: {
                return "rsaES-OAEP-ENV-OID";
            }
            case DES_EDE3_CBC_ENV_OID: {
                return "des-ede3-cbc-Env-OID";
            }
            case DES3_CBC_SHA1_KD: {
                return "des3-cbc-sha1-kd";
            }
            case AES128_CTS_HMAC_SHA1_96: {
                return "aes128-cts-hmac-sha1-96";
            }
            case AES256_CTS_HMAC_SHA1_96: {
                return "aes256-cts-hmac-sha1-96";
            }
            case RC4_HMAC: {
                return "rc4-hmac";
            }
            case RC4_HMAC_EXP: {
                return "rc4-hmac-exp";
            }
            case SUBKEY_KEYMATERIAL: {
                return "subkey-keymaterial";
            }
            case RC4_MD4: {
                return "rc4-md4";
            }
            case RC4_HMAC_OLD: {
                return "rc4-hmac-old";
            }
            case RC4_HMAC_OLD_EXP: {
                return "rc4-hmac-old-exp";
            }
            case UNKNOWN: {
                return "UNKNOWN";
            }
        }
        return "UNKNOWN";
    }

    public static EncryptionType getByName(String type) {
        if (type == null) {
            return UNKNOWN;
        }
        String lcType = type.toLowerCase();
        if (encryptionTypes.containsKey(lcType)) {
            return encryptionTypes.get(lcType);
        }
        return UNKNOWN;
    }

    public String toString() {
        return this.getName() + " (" + this.ordinal + ")";
    }

    static {
        encryptionTypes = new HashMap<String, EncryptionType>();
        encryptionTypes.put("null", NULL);
        encryptionTypes.put("des-cbc-crc", DES_CBC_CRC);
        encryptionTypes.put("des-cbc-md4", DES_CBC_MD4);
        encryptionTypes.put("des-cbc-md5", DES_CBC_MD5);
        encryptionTypes.put("[reserved]", RESERVED4);
        encryptionTypes.put("des3-cbc-md5", DES3_CBC_MD5);
        encryptionTypes.put("[reserved]", RESERVED6);
        encryptionTypes.put("des3-cbc-sha1", DES3_CBC_SHA1);
        encryptionTypes.put("dsaWithSHA1-CmsOID", DSAWITHSHA1_CMSOID);
        encryptionTypes.put("md5WithRSAEncryption-CmsOID", MD5WITHRSAENCRYPTION_CMSOID);
        encryptionTypes.put("sha1WithRSAEncryption-CmsOID", SHA1WITHRSAENCRYPTION_CMSOID);
        encryptionTypes.put("rc2CBC-EnvOID", RC2CBC_ENVOID);
        encryptionTypes.put("rsaEncryption-EnvOID", RSAENCRYPTION_ENVOID);
        encryptionTypes.put("rsaES-OAEP-ENV-OID", RSAES_OAEP_ENV_OID);
        encryptionTypes.put("des-ede3-cbc-Env-OID", DES_EDE3_CBC_ENV_OID);
        encryptionTypes.put("des3-cbc-sha1-kd", DES3_CBC_SHA1_KD);
        encryptionTypes.put("aes128-cts-hmac-sha1-96", AES128_CTS_HMAC_SHA1_96);
        encryptionTypes.put("aes256-cts-hmac-sha1-96", AES256_CTS_HMAC_SHA1_96);
        encryptionTypes.put("rc4-hmac", RC4_HMAC);
        encryptionTypes.put("rc4-hmac-exp", RC4_HMAC_EXP);
        encryptionTypes.put("subkey-keymaterial", SUBKEY_KEYMATERIAL);
        encryptionTypes.put("rc4-md4", RC4_MD4);
        encryptionTypes.put("rc4-hmac-old", RC4_HMAC_OLD);
        encryptionTypes.put("rc4-hmac-old-exp", RC4_HMAC_OLD_EXP);
        encryptionTypes.put("UNKNOWN", UNKNOWN);
    }
}

