/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.hadoop.hdfs;

import io.fabric8.hadoop.Factory;
import java.io.File;
import java.util.Dictionary;
import java.util.Enumeration;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NameNode;

public class NameNodeFactory
extends Factory<NameNode> {
    @Override
    protected NameNode doCreate(Dictionary properties) throws Exception {
        Configuration conf = new Configuration();
        Enumeration e = properties.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            Object val = properties.get(key);
            conf.set(key.toString(), val.toString());
        }
        boolean exists = false;
        for (File file : FSNamesystem.getNamespaceDirs(conf)) {
            exists |= file.exists();
        }
        if (!exists) {
            NameNode.format(conf);
        }
        NameNode nameNode = NameNode.createNameNode(null, conf);
        return nameNode;
    }

    @Override
    protected void doDelete(NameNode service) throws Exception {
        service.stop();
    }
}

