/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.hadoop;

import io.fabric8.hadoop.Factory;
import io.fabric8.hadoop.hdfs.DataNodeFactory;
import io.fabric8.hadoop.hdfs.NameNodeFactory;
import io.fabric8.hadoop.hdfs.SecondaryNameNodeFactory;
import io.fabric8.hadoop.mapred.JobTrackerFactory;
import io.fabric8.hadoop.mapred.TaskTrackerFactory;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Dictionary;
import javax.security.auth.Subject;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;

public class HadoopFactory
implements ManagedService {
    public static final String CONFIG_PID = "io.fabric8.hadoop";
    private DataNodeFactory dataNodeFactory;
    private NameNodeFactory nameNodeFactory;
    private SecondaryNameNodeFactory secondaryNameNodeFactory;
    private JobTrackerFactory jobTrackerFactory;
    private TaskTrackerFactory taskTrackerFactory;

    public DataNodeFactory getDataNodeFactory() {
        return this.dataNodeFactory;
    }

    public void setDataNodeFactory(DataNodeFactory dataNodeFactory) {
        this.dataNodeFactory = dataNodeFactory;
    }

    public NameNodeFactory getNameNodeFactory() {
        return this.nameNodeFactory;
    }

    public void setNameNodeFactory(NameNodeFactory nameNodeFactory) {
        this.nameNodeFactory = nameNodeFactory;
    }

    public SecondaryNameNodeFactory getSecondaryNameNodeFactory() {
        return this.secondaryNameNodeFactory;
    }

    public void setSecondaryNameNodeFactory(SecondaryNameNodeFactory secondaryNameNodeFactory) {
        this.secondaryNameNodeFactory = secondaryNameNodeFactory;
    }

    public JobTrackerFactory getJobTrackerFactory() {
        return this.jobTrackerFactory;
    }

    public void setJobTrackerFactory(JobTrackerFactory jobTrackerFactory) {
        this.jobTrackerFactory = jobTrackerFactory;
    }

    public TaskTrackerFactory getTaskTrackerFactory() {
        return this.taskTrackerFactory;
    }

    public void setTaskTrackerFactory(TaskTrackerFactory taskTrackerFactory) {
        this.taskTrackerFactory = taskTrackerFactory;
    }

    public void updated(Dictionary properties) throws ConfigurationException {
        this.updateFactory(properties, "nameNode", this.nameNodeFactory);
        this.updateFactory(properties, "dataNode", this.dataNodeFactory);
        this.updateFactory(properties, "secondaryNameNode", this.secondaryNameNodeFactory);
        this.updateFactory(properties, "jobTracker", this.jobTrackerFactory);
        this.updateFactory(properties, "taskTracker", this.taskTrackerFactory);
    }

    private void updateFactory(final Dictionary properties, String prop, final Factory<?> factory) throws ConfigurationException {
        if (this.getBool(properties, prop)) {
            try {
                Subject.doAs(null, new PrivilegedExceptionAction<Object>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public Object run() throws Exception {
                        ClassLoader oldTccl = Thread.currentThread().getContextClassLoader();
                        try {
                            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                            factory.delete();
                            factory.create(properties);
                        }
                        finally {
                            Thread.currentThread().setContextClassLoader(oldTccl);
                        }
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                if (e.getCause() instanceof ConfigurationException) {
                    throw (ConfigurationException)e.getCause();
                }
                throw new RuntimeException(e.getCause());
            }
        } else {
            factory.delete();
        }
    }

    public void destroy() throws ConfigurationException {
        this.updated(null);
        DefaultMetricsSystem.INSTANCE.shutdown();
    }

    private boolean getBool(Dictionary properties, String key) {
        Object val;
        Object object = val = properties != null ? (Object)properties.get(key) : null;
        if (val != null) {
            return Boolean.parseBoolean(val.toString());
        }
        return false;
    }
}

