/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.hadoop;

import java.util.Dictionary;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;

public abstract class Factory<T> {
    protected BundleContext bundleContext;
    protected T service;
    protected ServiceRegistration registration;

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void create(Dictionary properties) throws ConfigurationException {
        this.delete();
        try {
            this.service = this.doCreate(properties);
            try {
                this.registration = this.bundleContext.registerService(this.service.getClass().getName(), this.service, properties);
            }
            catch (Throwable t) {
                this.delete();
            }
        }
        catch (Throwable t) {
            this.delete();
            throw new RuntimeException("Unable to create service", t);
        }
    }

    protected abstract T doCreate(Dictionary var1) throws Exception;

    public void delete() {
        if (this.registration != null) {
            try {
                this.registration.unregister();
            }
            catch (Throwable t) {
                // empty catch block
            }
            this.registration = null;
        }
        if (this.service != null) {
            try {
                this.doDelete(this.service);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.service = null;
        }
    }

    protected abstract void doDelete(T var1) throws Exception;
}

