/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.mapred.JobTracker;

public class HDFSMonitorThread
extends Thread {
    public static final Log LOG = LogFactory.getLog(HDFSMonitorThread.class);
    private final JobTracker jt;
    private final FileSystem fs;
    private final int hdfsMonitorInterval;

    public HDFSMonitorThread(Configuration conf, JobTracker jt, FileSystem fs) {
        super("JT-HDFS-Monitor-Thread");
        this.jt = jt;
        this.fs = fs;
        this.hdfsMonitorInterval = conf.getInt("mapreduce.jt.hdfs.monitor.interval.ms", 5000);
        this.setDaemon(true);
    }

    @Override
    public void run() {
        LOG.info((Object)"Starting HDFS Health Monitoring...");
        boolean previouslyHealthy = true;
        boolean done = false;
        while (!done && !this.isInterrupted()) {
            boolean currentlyHealthy = DistributedFileSystem.isHealthy(this.fs.getUri());
            if (currentlyHealthy != previouslyHealthy) {
                JobTracker.SafeModeAction action;
                if (currentlyHealthy) {
                    action = JobTracker.SafeModeAction.SAFEMODE_LEAVE;
                    LOG.info((Object)"HDFS healthy again, instructing JobTracker to leave 'safemode' ...");
                } else {
                    action = JobTracker.SafeModeAction.SAFEMODE_ENTER;
                    LOG.info((Object)"HDFS is unhealthy, instructing JobTracker to enter 'safemode' ...");
                }
                try {
                    if (this.jt.isInAdminSafeMode()) {
                        LOG.info((Object)("JobTracker is in admin-set safemode, not overriding through " + (Object)((Object)action)));
                        previouslyHealthy = currentlyHealthy;
                    } else {
                        previouslyHealthy = !this.jt.setSafeModeInternal(action);
                    }
                }
                catch (IOException ioe) {
                    LOG.info((Object)("Failed to setSafeMode with action " + (Object)((Object)action)), (Throwable)ioe);
                }
            }
            try {
                Thread.sleep(this.hdfsMonitorInterval);
            }
            catch (InterruptedException e) {
                done = true;
            }
        }
        LOG.info((Object)"Stoping HDFS Health Monitoring...");
    }
}

